/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.memory.SynonymMap;

public class SynonymTokenFilter
extends TokenFilter {
    public static final String SYNONYM_TOKEN_TYPE = "SYNONYM";
    private final SynonymMap synonyms;
    private final int maxSynonyms;
    private String[] stack = null;
    private int index = 0;
    private Token current = null;
    private int todo = 0;

    public SynonymTokenFilter(TokenStream input, SynonymMap synonyms, int maxSynonyms) {
        super(input);
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (synonyms == null) {
            throw new IllegalArgumentException("synonyms must not be null");
        }
        if (maxSynonyms < 0) {
            throw new IllegalArgumentException("maxSynonyms must not be negative");
        }
        this.synonyms = synonyms;
        this.maxSynonyms = maxSynonyms;
    }

    @Override
    public Token next() throws IOException {
        Token token;
        while (this.todo > 0 && this.index < this.stack.length) {
            if ((token = this.createToken(this.stack[this.index++], this.current)) == null) continue;
            --this.todo;
            return token;
        }
        token = this.input.next();
        if (token == null) {
            return null;
        }
        this.stack = this.synonyms.getSynonyms(token.termText());
        if (this.stack.length > this.maxSynonyms) {
            SynonymTokenFilter.randomize(this.stack);
        }
        this.index = 0;
        this.current = token;
        this.todo = this.maxSynonyms;
        return token;
    }

    protected Token createToken(String synonym, Token current) {
        Token token = new Token(synonym, current.startOffset(), current.endOffset(), SYNONYM_TOKEN_TYPE);
        token.setPositionIncrement(0);
        return token;
    }

    private static void randomize(Object[] arr) {
        int seed = 1234567;
        int randomState = 4 * seed + 1;
        int len = arr.length;
        for (int i = 0; i < len - 1; ++i) {
            int r = (randomState *= 663608941) % (len - i);
            if (r < 0) {
                r = -r;
            }
            Object tmp = arr[i];
            arr[i] = arr[i + r];
            arr[i + r] = tmp;
        }
    }
}

