/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.index.memory.PatternAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class MemoryIndexTest
extends TestCase {
    private Analyzer analyzer;
    private boolean fastMode = false;
    private final boolean verbose = false;
    private static final String FIELD_NAME = "content";
    public String fileDir;
    private static final Charset DEFAULT_PLATFORM_CHARSET = Charset.forName(new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding());

    public static void main(String[] args) throws Throwable {
        new MemoryIndexTest().run(args);
    }

    public void setUp() {
        this.fileDir = System.getProperty("lucene.common.dir", null);
    }

    public void testMany() throws Throwable {
        String[] files = MemoryIndexTest.listFiles(new String[]{"*.txt", "*.html", "*.xml", "xdocs/*.xml", "src/java/test/org/apache/lucene/queryParser/*.java", "contrib/memory/src/java/org/apache/lucene/index/memory/*.java"});
        System.out.println("files = " + Arrays.asList(files));
        String[] xargs = new String[]{"1", "1", "memram", "@contrib/memory/src/test/org/apache/lucene/index/memory/testqueries.txt"};
        String[] args = new String[xargs.length + files.length];
        System.arraycopy(xargs, 0, args, 0, xargs.length);
        System.arraycopy(files, 0, args, xargs.length, files.length);
        this.run(args);
    }

    private void run(String[] args) throws Throwable {
        int k = -1;
        int iters = 1;
        if (args.length > ++k) {
            iters = Math.max(1, Integer.parseInt(args[k]));
        }
        int runs = 1;
        if (args.length > ++k) {
            runs = Math.max(1, Integer.parseInt(args[k]));
        }
        String cmd = "memram";
        if (args.length > ++k) {
            cmd = args[k];
        }
        boolean useMemIndex = cmd.indexOf("mem") >= 0;
        boolean useRAMIndex = cmd.indexOf("ram") >= 0;
        String[] queries = new String[]{"term", "term*", "term~", "Apache", "Apach~ AND Copy*"};
        if (args.length > ++k) {
            String arg = args[k];
            queries = arg.startsWith("@") ? this.readLines(new File(this.fileDir, arg.substring(1))) : new String[]{arg};
        }
        File[] files = new File[]{new File("CHANGES.txt"), new File("LICENSE.txt")};
        if (args.length > ++k) {
            files = new File[args.length - k];
            for (int i = k; i < args.length; ++i) {
                files[i - k] = new File(args[i]);
            }
        }
        boolean toLowerCase = true;
        Set stopWords = StopFilter.makeStopSet(StopAnalyzer.ENGLISH_STOP_WORDS);
        Analyzer[] analyzers = new Analyzer[]{new SimpleAnalyzer(), new StopAnalyzer(), new StandardAnalyzer(), PatternAnalyzer.DEFAULT_ANALYZER};
        for (int iter = 0; iter < iters; ++iter) {
            System.out.println("\n########### iteration=" + iter);
            long start = System.currentTimeMillis();
            long bytes = 0L;
            for (int anal = 0; anal < analyzers.length; ++anal) {
                this.analyzer = analyzers[anal];
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.exists() || file.isDirectory()) continue;
                    bytes += file.length();
                    String text = MemoryIndexTest.toString(new FileInputStream(file), null);
                    Document doc = this.createDocument(text);
                    for (int q = 0; q < queries.length; ++q) {
                        try {
                            Query query = this.parseQuery(queries[q]);
                            boolean measureIndexing = false;
                            MemoryIndex memind = null;
                            if (useMemIndex && !measureIndexing) {
                                memind = this.createMemoryIndex(doc);
                            }
                            RAMDirectory ramind = null;
                            if (useRAMIndex && !measureIndexing) {
                                ramind = this.createRAMIndex(doc);
                            }
                            for (int run = 0; run < runs; ++run) {
                                float score1 = 0.0f;
                                float score2 = 0.0f;
                                if (useMemIndex && measureIndexing) {
                                    memind = this.createMemoryIndex(doc);
                                }
                                if (useMemIndex) {
                                    score1 = this.query(memind, query);
                                }
                                if (useRAMIndex && measureIndexing) {
                                    ramind = this.createRAMIndex(doc);
                                }
                                if (useRAMIndex) {
                                    score2 = this.query(ramind, query);
                                }
                                if (!useMemIndex || !useRAMIndex || !(score1 != score2 || score1 < 0.0f || score2 < 0.0f || score1 > 1.0f) && !(score2 > 1.0f)) continue;
                                throw new IllegalStateException("BUG DETECTED:" + i * (q + 1) + " at query=" + queries[q] + ", file=" + file + ", anal=" + this.analyzer);
                            }
                            continue;
                        }
                        catch (Throwable t) {
                            if (t instanceof OutOfMemoryError) {
                                t.printStackTrace();
                            }
                            System.out.println("Fatal error at query=" + queries[q] + ", file=" + file + ", anal=" + this.analyzer);
                            throw t;
                        }
                    }
                }
            }
            long end = System.currentTimeMillis();
            System.out.println("\nsecs = " + (float)(end - start) / 1000.0f);
            System.out.println("queries/sec= " + 1.0f * (float)runs * (float)queries.length * (float)analyzers.length * (float)files.length / ((float)(end - start) / 1000.0f));
            float mb = 1.0f * (float)bytes * (float)queries.length * (float)runs / 1048576.0f;
            System.out.println("MB/sec = " + mb / ((float)(end - start) / 1000.0f));
        }
        if (useMemIndex && useRAMIndex) {
            System.out.println("No bug found. done.");
        } else {
            System.out.println("Done benchmarking (without checking correctness).");
        }
    }

    private String[] readLines(File file) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            String t = line.trim();
            if (t.length() <= 0 || t.charAt(0) == '#' || t.startsWith("//")) continue;
            lines.add(line);
        }
        reader.close();
        String[] result = new String[lines.size()];
        lines.toArray(result);
        return result;
    }

    private Document createDocument(String content) {
        Document doc = new Document();
        doc.add(new Field(FIELD_NAME, content, Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.WITH_POSITIONS));
        return doc;
    }

    private MemoryIndex createMemoryIndex(Document doc) {
        MemoryIndex index = new MemoryIndex();
        Enumeration iter = doc.fields();
        while (iter.hasMoreElements()) {
            Field field = (Field)iter.nextElement();
            index.addField(field.name(), field.stringValue(), this.analyzer);
        }
        return index;
    }

    private RAMDirectory createRAMIndex(Document doc) {
        RAMDirectory dir = new RAMDirectory();
        IndexWriter writer = null;
        try {
            writer = new IndexWriter((Directory)dir, this.analyzer, true);
            writer.setMaxFieldLength(Integer.MAX_VALUE);
            writer.addDocument(doc);
            writer.optimize();
            RAMDirectory rAMDirectory = dir;
            return rAMDirectory;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private float query(Object index, Query query) {
        IndexSearcher searcher = null;
        try {
            float score;
            searcher = index instanceof Directory ? new IndexSearcher((Directory)index) : ((MemoryIndex)index).createSearcher();
            final float[] scores = new float[1];
            searcher.search(query, new HitCollector(){

                @Override
                public void collect(int doc, float score) {
                    scores[0] = score;
                }
            });
            float f = score = scores[0];
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (searcher != null) {
                    ((Searcher)searcher).close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private int getMemorySize(Object index) {
        if (index instanceof Directory) {
            try {
                Directory dir = (Directory)index;
                int size = 0;
                String[] fileNames = dir.list();
                for (int i = 0; i < fileNames.length; ++i) {
                    size = (int)((long)size + dir.fileLength(fileNames[i]));
                }
                return size;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ((MemoryIndex)index).getMemorySize();
    }

    private Query parseQuery(String expression) throws ParseException {
        QueryParser parser = new QueryParser(FIELD_NAME, this.analyzer);
        return parser.parse(expression);
    }

    static String[] listFiles(String[] fileNames) {
        LinkedHashSet<String> allFiles = new LinkedHashSet<String>();
        for (int i = 0; i < fileNames.length; ++i) {
            String suffix;
            File[] files;
            int k = fileNames[i].indexOf("*");
            if (k < 0) {
                allFiles.add(fileNames[i]);
                continue;
            }
            String prefix = fileNames[i].substring(0, k);
            if (prefix.length() == 0) {
                prefix = ".";
            }
            if ((files = new File(prefix).listFiles(new FilenameFilter(suffix = fileNames[i].substring(k + 1)){
                final /* synthetic */ String val$suffix;
                {
                    this.val$suffix = string;
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(this.val$suffix);
                }
            })) == null) continue;
            for (int j = 0; j < files.length; ++j) {
                allFiles.add(files[j].getPath());
            }
        }
        String[] result = new String[allFiles.size()];
        allFiles.toArray(result);
        return result;
    }

    private static String toString(InputStream input, Charset charset) throws IOException {
        if (charset == null) {
            charset = DEFAULT_PLATFORM_CHARSET;
        }
        byte[] data = MemoryIndexTest.toByteArray(input);
        return charset.decode(ByteBuffer.wrap(data)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(InputStream input) throws IOException {
        try {
            byte[] byArray;
            int n;
            int len = Math.max(256, input.available());
            byte[] buffer = new byte[len];
            byte[] output = new byte[len];
            len = 0;
            while ((n = input.read(buffer)) >= 0) {
                if (len + n > output.length) {
                    byte[] tmp = new byte[Math.max(output.length << 1, len + n)];
                    System.arraycopy(output, 0, tmp, 0, len);
                    System.arraycopy(buffer, 0, tmp, len, n);
                    buffer = output;
                    output = tmp;
                } else {
                    System.arraycopy(buffer, 0, output, len, n);
                }
                len += n;
            }
            if (len == output.length) {
                byArray = output;
                return byArray;
            }
            buffer = null;
            buffer = new byte[len];
            System.arraycopy(output, 0, buffer, 0, len);
            byArray = buffer;
            return byArray;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

