/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldNormModifier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class TestFieldNormModifier
extends TestCase {
    public static byte DEFAULT_NORM = Similarity.encodeNorm(1.0f);
    public static int NUM_DOCS = 5;
    public Directory store = new RAMDirectory();
    public static Similarity s = new DefaultSimilarity(){

        @Override
        public float lengthNorm(String fieldName, int numTokens) {
            return numTokens;
        }
    };

    public TestFieldNormModifier(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        IndexWriter writer = new IndexWriter(this.store, (Analyzer)new SimpleAnalyzer(), true);
        for (int i = 0; i < NUM_DOCS; ++i) {
            Document d = new Document();
            d.add(new Field("field", "word", Field.Store.YES, Field.Index.TOKENIZED));
            d.add(new Field("nonorm", "word", Field.Store.YES, Field.Index.NO_NORMS));
            d.add(new Field("untokfield", "20061212 20071212", Field.Store.YES, Field.Index.TOKENIZED));
            for (int j = 1; j <= i; ++j) {
                d.add(new Field("field", "crap", Field.Store.YES, Field.Index.TOKENIZED));
                d.add(new Field("nonorm", "more words", Field.Store.YES, Field.Index.NO_NORMS));
            }
            writer.addDocument(d);
        }
        writer.close();
    }

    public void testMissingField() {
        FieldNormModifier fnm = new FieldNormModifier(this.store, s);
        try {
            fnm.reSetNorms("nobodyherebutuschickens");
        }
        catch (Exception e) {
            TestFieldNormModifier.assertNull((String)"caught something", (Object)e);
        }
    }

    public void testFieldWithNoNorm() throws Exception {
        IndexReader r = IndexReader.open(this.store);
        byte[] norms = r.norms("nonorm");
        TestFieldNormModifier.assertTrue((String)"Whoops we have norms?", (!r.hasNorms("nonorm") ? 1 : 0) != 0);
        for (int i = 0; i < norms.length; ++i) {
            TestFieldNormModifier.assertEquals((String)("" + i), (byte)DEFAULT_NORM, (byte)norms[i]);
        }
        r.close();
        FieldNormModifier fnm = new FieldNormModifier(this.store, s);
        try {
            fnm.reSetNorms("nonorm");
        }
        catch (Exception e) {
            TestFieldNormModifier.assertNull((String)"caught something", (Object)e);
        }
        r = IndexReader.open(this.store);
        norms = r.norms("nonorm");
        TestFieldNormModifier.assertTrue((String)"Whoops we have norms?", (!r.hasNorms("nonorm") ? 1 : 0) != 0);
        for (int i = 0; i < norms.length; ++i) {
            TestFieldNormModifier.assertEquals((String)("" + i), (byte)DEFAULT_NORM, (byte)norms[i]);
        }
        r.close();
    }

    public void testGoodCases() throws Exception {
        IndexSearcher searcher = new IndexSearcher(this.store);
        final float[] scores = new float[NUM_DOCS];
        float lastScore = 0.0f;
        searcher.search((Query)new TermQuery(new Term("field", "word")), new HitCollector(){

            @Override
            public final void collect(int doc, float score) {
                scores[doc] = score;
            }
        });
        searcher.close();
        lastScore = Float.MAX_VALUE;
        for (int i = 0; i < NUM_DOCS; ++i) {
            String msg = "i=" + i + ", " + scores[i] + " <= " + lastScore;
            TestFieldNormModifier.assertTrue((String)msg, (scores[i] <= lastScore ? 1 : 0) != 0);
            lastScore = scores[i];
        }
        FieldNormModifier fnm = new FieldNormModifier(this.store, s);
        fnm.reSetNorms("field");
        searcher = new IndexSearcher(this.store);
        searcher.search((Query)new TermQuery(new Term("field", "word")), new HitCollector(){

            @Override
            public final void collect(int doc, float score) {
                scores[doc] = score;
            }
        });
        searcher.close();
        lastScore = 0.0f;
        for (int i = 0; i < NUM_DOCS; ++i) {
            String msg = "i=" + i + ", " + scores[i] + " >= " + lastScore;
            TestFieldNormModifier.assertTrue((String)msg, (scores[i] >= lastScore ? 1 : 0) != 0);
            lastScore = scores[i];
        }
    }

    public void testNormKiller() throws IOException {
        IndexReader r = IndexReader.open(this.store);
        byte[] oldNorms = r.norms("untokfield");
        r.close();
        FieldNormModifier fnm = new FieldNormModifier(this.store, s);
        fnm.reSetNorms("untokfield");
        r = IndexReader.open(this.store);
        byte[] newNorms = r.norms("untokfield");
        r.close();
        TestFieldNormModifier.assertFalse((boolean)Arrays.equals(oldNorms, newNorms));
        IndexSearcher searcher = new IndexSearcher(this.store);
        final float[] scores = new float[NUM_DOCS];
        float lastScore = 0.0f;
        searcher.search((Query)new TermQuery(new Term("untokfield", "20061212")), new HitCollector(){

            @Override
            public final void collect(int doc, float score) {
                scores[doc] = score;
            }
        });
        searcher.close();
        lastScore = scores[0];
        for (int i = 0; i < NUM_DOCS; ++i) {
            String msg = "i=" + i + ", " + scores[i] + " == " + lastScore;
            TestFieldNormModifier.assertTrue((String)msg, (scores[i] == lastScore ? 1 : 0) != 0);
            lastScore = scores[i];
        }
    }
}

