/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ThaiWordFilter
extends TokenFilter {
    private BreakIterator breaker = BreakIterator.getWordInstance(new Locale("th"));
    private Token thaiToken = null;

    public ThaiWordFilter(TokenStream input) {
        super(input);
    }

    @Override
    public Token next() throws IOException {
        Token tk;
        int end;
        if (this.thaiToken != null) {
            String text = this.thaiToken.termText();
            int start = this.breaker.current();
            end = this.breaker.next();
            if (end != -1) {
                return new Token(text.substring(start, end), this.thaiToken.startOffset() + start, this.thaiToken.startOffset() + end, this.thaiToken.type());
            }
            this.thaiToken = null;
        }
        if ((tk = this.input.next()) == null) {
            return null;
        }
        String text = tk.termText();
        if (Character.UnicodeBlock.of(text.charAt(0)) != Character.UnicodeBlock.THAI) {
            return new Token(text.toLowerCase(), tk.startOffset(), tk.endOffset(), tk.type());
        }
        this.thaiToken = tk;
        this.breaker.setText(text);
        end = this.breaker.next();
        if (end != -1) {
            return new Token(text.substring(0, end), this.thaiToken.startOffset(), this.thaiToken.startOffset() + end, this.thaiToken.type());
        }
        return null;
    }
}

