/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class SnowballAnalyzer
extends Analyzer {
    private String name;
    private Set stopSet;

    public SnowballAnalyzer(String name) {
        this.name = name;
    }

    public SnowballAnalyzer(String name, String[] stopWords) {
        this(name);
        this.stopSet = StopFilter.makeStopSet(stopWords);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(reader);
        result = new StandardFilter(result);
        result = new LowerCaseFilter(result);
        if (this.stopSet != null) {
            result = new StopFilter(result, this.stopSet);
        }
        result = new SnowballFilter(result, this.name);
        return result;
    }
}

