/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;

public class EdgeNGramTokenizerTest
extends TestCase {
    private StringReader input;

    public void setUp() {
        this.input = new StringReader("abcde");
    }

    public void testInvalidInput() throws Exception {
        boolean gotException = false;
        try {
            new EdgeNGramTokenizer((Reader)this.input, EdgeNGramTokenizer.Side.FRONT, 0, 0);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        EdgeNGramTokenizerTest.assertTrue((boolean)gotException);
    }

    public void testInvalidInput2() throws Exception {
        boolean gotException = false;
        try {
            new EdgeNGramTokenizer((Reader)this.input, EdgeNGramTokenizer.Side.FRONT, 2, 1);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        EdgeNGramTokenizerTest.assertTrue((boolean)gotException);
    }

    public void testInvalidInput3() throws Exception {
        boolean gotException = false;
        try {
            new EdgeNGramTokenizer((Reader)this.input, EdgeNGramTokenizer.Side.FRONT, -1, 2);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        EdgeNGramTokenizerTest.assertTrue((boolean)gotException);
    }

    public void testFrontUnigram() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer((Reader)this.input, EdgeNGramTokenizer.Side.FRONT, 1, 1);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertEquals((String)"(a,0,1)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertNull((Object)token);
    }

    public void testBackUnigram() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer((Reader)this.input, EdgeNGramTokenizer.Side.BACK, 1, 1);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertEquals((String)"(e,4,5)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertNull((Object)token);
    }

    public void testOversizedNgrams() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer((Reader)this.input, EdgeNGramTokenizer.Side.FRONT, 6, 6);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertNull((Object)token);
    }

    public void testFrontRangeOfNgrams() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer((Reader)this.input, EdgeNGramTokenizer.Side.FRONT, 1, 3);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertEquals((String)"(a,0,1)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertEquals((String)"(ab,0,2)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertEquals((String)"(abc,0,3)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertNull((Object)token);
    }

    public void testBackRangeOfNgrams() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer((Reader)this.input, EdgeNGramTokenizer.Side.BACK, 1, 3);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertEquals((String)"(e,4,5)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertEquals((String)"(de,3,5)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertEquals((String)"(cde,2,5)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenizerTest.assertNull((Object)token);
    }
}

