/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class ChineseFilter
extends TokenFilter {
    public static final String[] STOP_WORDS = new String[]{"and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    private Hashtable stopTable = new Hashtable(STOP_WORDS.length);

    public ChineseFilter(TokenStream in) {
        super(in);
        for (int i = 0; i < STOP_WORDS.length; ++i) {
            this.stopTable.put(STOP_WORDS[i], STOP_WORDS[i]);
        }
    }

    @Override
    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            String text = token.termText();
            if (this.stopTable.get(text) == null) {
                switch (Character.getType(text.charAt(0))) {
                    case 1: 
                    case 2: {
                        if (text.length() <= 1) break;
                        return token;
                    }
                    case 5: {
                        return token;
                    }
                }
            }
            token = this.input.next();
        }
        return null;
    }
}

