/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.ode;

import org.spaceroots.mantissa.ode.AbstractStepInterpolator;
import org.spaceroots.mantissa.ode.AdaptiveStepsizeIntegrator;
import org.spaceroots.mantissa.ode.DerivativeException;
import org.spaceroots.mantissa.ode.DummyStepInterpolator;
import org.spaceroots.mantissa.ode.FirstOrderDifferentialEquations;
import org.spaceroots.mantissa.ode.GraggBulirschStoerStepInterpolator;
import org.spaceroots.mantissa.ode.IntegratorException;
import org.spaceroots.mantissa.ode.StepHandler;
import org.spaceroots.mantissa.ode.SwitchingFunction;

public class GraggBulirschStoerIntegrator
extends AdaptiveStepsizeIntegrator {
    private static final String methodName = "Gragg-Bulirsch-Stoer";
    private int maxOrder;
    private int[] sequence;
    private int[] costPerStep;
    private double[] costPerTimeUnit;
    private double[] optimalStep;
    private double[][] coeff;
    private boolean performTest;
    private int maxChecks;
    private int maxIter;
    private double stabilityReduction;
    private double stepControl1;
    private double stepControl2;
    private double stepControl3;
    private double stepControl4;
    private double orderControl1;
    private double orderControl2;
    private boolean denseOutput;
    private boolean useInterpolationError;
    private int mudif;

    public GraggBulirschStoerIntegrator(double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.denseOutput = this.handler.requiresDenseOutput() || !this.switchesHandler.isEmpty();
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setStepsizeControl(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public GraggBulirschStoerIntegrator(double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.denseOutput = this.handler.requiresDenseOutput() || !this.switchesHandler.isEmpty();
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setStepsizeControl(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public void setStabilityCheck(boolean performTest, int maxIter, int maxChecks, double stabilityReduction) {
        this.performTest = performTest;
        this.maxIter = maxIter <= 0 ? 2 : maxIter;
        this.maxChecks = maxChecks <= 0 ? 1 : maxChecks;
        this.stabilityReduction = stabilityReduction < 1.0E-4 || stabilityReduction > 0.9999 ? 0.5 : stabilityReduction;
    }

    public void setStepsizeControl(double stepControl1, double stepControl2, double stepControl3, double stepControl4) {
        this.stepControl1 = stepControl1 < 1.0E-4 || stepControl1 > 0.9999 ? 0.65 : stepControl1;
        this.stepControl2 = stepControl2 < 1.0E-4 || stepControl2 > 0.9999 ? 0.94 : stepControl2;
        this.stepControl3 = stepControl3 < 1.0E-4 || stepControl3 > 0.9999 ? 0.02 : stepControl3;
        this.stepControl4 = stepControl4 < 1.0001 || stepControl4 > 999.9 ? 4.0 : stepControl4;
    }

    public void setOrderControl(int maxOrder, double orderControl1, double orderControl2) {
        if (maxOrder <= 6 || maxOrder % 2 != 0) {
            this.maxOrder = 18;
        }
        this.orderControl1 = orderControl1 < 1.0E-4 || orderControl1 > 0.9999 ? 0.8 : orderControl1;
        this.orderControl2 = orderControl2 < 1.0E-4 || orderControl2 > 0.9999 ? 0.9 : orderControl2;
        this.initializeArrays();
    }

    @Override
    public void setStepHandler(StepHandler handler) {
        super.setStepHandler(handler);
        this.denseOutput = handler.requiresDenseOutput() || !this.switchesHandler.isEmpty();
        this.initializeArrays();
    }

    @Override
    public void addSwitchingFunction(SwitchingFunction function, double maxCheckInterval, double convergence) {
        super.addSwitchingFunction(function, maxCheckInterval, convergence);
        this.denseOutput = this.handler.requiresDenseOutput() || !this.switchesHandler.isEmpty();
        this.initializeArrays();
    }

    private void initializeArrays() {
        int k;
        int size = this.maxOrder / 2;
        if (this.sequence == null || this.sequence.length != size) {
            this.sequence = new int[size];
            this.costPerStep = new int[size];
            this.coeff = new double[size][];
            this.costPerTimeUnit = new double[size];
            this.optimalStep = new double[size];
        }
        if (this.denseOutput) {
            for (k = 0; k < size; ++k) {
                this.sequence[k] = 4 * k + 2;
            }
        } else {
            for (k = 0; k < size; ++k) {
                this.sequence[k] = 2 * (k + 1);
            }
        }
        this.costPerStep[0] = this.sequence[0] + 1;
        for (k = 1; k < size; ++k) {
            this.costPerStep[k] = this.costPerStep[k - 1] + this.sequence[k];
        }
        for (k = 0; k < size; ++k) {
            this.coeff[k] = k > 0 ? new double[k] : null;
            for (int l = 0; l < k; ++l) {
                double ratio = (double)this.sequence[k] / (double)this.sequence[k - l - 1];
                this.coeff[k][l] = 1.0 / (ratio * ratio - 1.0);
            }
        }
    }

    public void setInterpolationControl(boolean useInterpolationError, int mudif) {
        this.useInterpolationError = useInterpolationError;
        this.mudif = mudif <= 0 || mudif >= 7 ? 4 : mudif;
    }

    @Override
    public String getName() {
        return methodName;
    }

    private void rescale(double[] y1, double[] y2, double[] scale) {
        if (this.vecAbsoluteTolerance == null) {
            for (int i = 0; i < scale.length; ++i) {
                double yi = Math.max(Math.abs(y1[i]), Math.abs(y2[i]));
                scale[i] = this.scalAbsoluteTolerance + this.scalRelativeTolerance * yi;
            }
        } else {
            for (int i = 0; i < scale.length; ++i) {
                double yi = Math.max(Math.abs(y1[i]), Math.abs(y2[i]));
                scale[i] = this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * yi;
            }
        }
    }

    private boolean tryStep(FirstOrderDifferentialEquations equations, double t0, double[] y0, double step, int k, double[] scale, double[][] f, double[] yMiddle, double[] yEnd, double[] yTmp) throws DerivativeException {
        int i;
        int n = this.sequence[k];
        double subStep = step / (double)n;
        double subStep2 = 2.0 * subStep;
        double t = t0 + subStep;
        for (i = 0; i < y0.length; ++i) {
            yTmp[i] = y0[i];
            yEnd[i] = y0[i] + subStep * f[0][i];
        }
        equations.computeDerivatives(t, yEnd, f[1]);
        for (int j = 1; j < n; ++j) {
            if (2 * j == n) {
                System.arraycopy(yEnd, 0, yMiddle, 0, y0.length);
            }
            t += subStep;
            for (int i2 = 0; i2 < y0.length; ++i2) {
                double middle = yEnd[i2];
                yEnd[i2] = yTmp[i2] + subStep2 * f[j][i2];
                yTmp[i2] = middle;
            }
            equations.computeDerivatives(t, yEnd, f[j + 1]);
            if (!this.performTest || j > this.maxChecks || k >= this.maxIter) continue;
            double initialNorm = 0.0;
            for (int l = 0; l < y0.length; ++l) {
                double ratio = f[0][l] / scale[l];
                initialNorm += ratio * ratio;
            }
            double deltaNorm = 0.0;
            for (int l = 0; l < y0.length; ++l) {
                double ratio = (f[j + 1][l] - f[0][l]) / scale[l];
                deltaNorm += ratio * ratio;
            }
            if (!(deltaNorm > 4.0 * Math.max(1.0E-15, initialNorm))) continue;
            return false;
        }
        for (i = 0; i < y0.length; ++i) {
            yEnd[i] = 0.5 * (yTmp[i] + yEnd[i] + subStep * f[n][i]);
        }
        return true;
    }

    private void extrapolate(int offset, int k, double[][] diag, double[] last) {
        for (int j = 1; j < k; ++j) {
            for (int i = 0; i < last.length; ++i) {
                diag[k - j - 1][i] = diag[k - j][i] + this.coeff[k + offset][j - 1] * (diag[k - j][i] - diag[k - j - 1][i]);
            }
        }
        for (int i = 0; i < last.length; ++i) {
            last[i] = diag[0][i] + this.coeff[k + offset][k - 1] * (diag[0][i] - last[i]);
        }
    }

    @Override
    public void integrate(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t, double[] y) throws DerivativeException, IntegratorException {
        if (equations.getDimension() != y0.length) {
            throw new IntegratorException("dimensions mismatch: ODE problem has dimension {0}, state vector has dimension {1}", new String[]{Integer.toString(equations.getDimension()), Integer.toString(y0.length)});
        }
        if (Math.abs(t - t0) <= 1.0E-12 * Math.max(Math.abs(t0), Math.abs(t))) {
            throw new IntegratorException("too small integration interval: length = {0}", new String[]{Double.toString(Math.abs(t - t0))});
        }
        boolean forward = t > t0;
        double[] yDot0 = new double[y0.length];
        double[] y1 = new double[y0.length];
        double[] yTmp = new double[y0.length];
        double[] yTmpDot = new double[y0.length];
        double[][] diagonal = new double[this.sequence.length - 1][];
        double[][] y1Diag = new double[this.sequence.length - 1][];
        for (int k = 0; k < this.sequence.length - 1; ++k) {
            diagonal[k] = new double[y0.length];
            y1Diag[k] = new double[y0.length];
        }
        double[][][] fk = new double[this.sequence.length][][];
        for (int k = 0; k < this.sequence.length; ++k) {
            fk[k] = new double[this.sequence[k] + 1][];
            fk[k][0] = yDot0;
            for (int l = 0; l < this.sequence[k]; ++l) {
                fk[k][l + 1] = new double[y0.length];
            }
        }
        if (y != y0) {
            System.arraycopy(y0, 0, y, 0, y0.length);
        }
        double[] yDot1 = null;
        Object yMidDots = null;
        if (this.denseOutput) {
            yDot1 = new double[y0.length];
            yMidDots = new double[1 + 2 * this.sequence.length][];
            for (int j = 0; j < ((double[][])yMidDots).length; ++j) {
                yMidDots[j] = new double[y0.length];
            }
        } else {
            yMidDots = new double[1][];
            yMidDots[0] = new double[y0.length];
        }
        double[] scale = new double[y0.length];
        this.rescale(y, y, scale);
        double log10R = Math.log(Math.max(1.0E-10, this.vecRelativeTolerance == null ? this.scalRelativeTolerance : this.vecRelativeTolerance[0])) / Math.log(10.0);
        int targetIter = Math.max(1, Math.min(this.sequence.length - 2, (int)Math.floor(0.5 - 0.6 * log10R)));
        AbstractStepInterpolator interpolator = null;
        interpolator = this.denseOutput || !this.switchesHandler.isEmpty() ? new GraggBulirschStoerStepInterpolator(y, yDot0, y1, yDot1, (double[][])yMidDots, forward) : new DummyStepInterpolator(y, forward);
        interpolator.storeTime(t0);
        this.stepStart = t0;
        double hNew = 0.0;
        double maxError = Double.MAX_VALUE;
        boolean previousRejected = false;
        boolean firstTime = true;
        boolean newStep = true;
        boolean lastStep = false;
        boolean firstStepAlreadyComputed = false;
        this.handler.reset();
        this.costPerTimeUnit[0] = 0.0;
        while (!lastStep) {
            boolean reject = false;
            if (newStep) {
                interpolator.shift();
                if (!firstStepAlreadyComputed) {
                    equations.computeDerivatives(this.stepStart, y, yDot0);
                }
                if (firstTime) {
                    hNew = this.initializeStep(equations, forward, 2 * targetIter + 1, scale, this.stepStart, y, yDot0, yTmp, yTmpDot);
                    if (!forward) {
                        hNew = -hNew;
                    }
                }
                newStep = false;
            }
            this.stepSize = hNew;
            if (forward && this.stepStart + this.stepSize > t || !forward && this.stepStart + this.stepSize < t) {
                this.stepSize = t - this.stepStart;
            }
            double nextT = this.stepStart + this.stepSize;
            lastStep = forward ? nextT >= t : nextT <= t;
            int k = -1;
            boolean loop = true;
            block10: while (loop) {
                if (!this.tryStep(equations, this.stepStart, y, this.stepSize, k, scale, fk[++k], k == 0 ? yMidDots[0] : diagonal[k - 1], k == 0 ? y1 : y1Diag[k - 1], yTmp)) {
                    hNew = Math.abs(this.filterStep(this.stepSize * this.stabilityReduction, false));
                    reject = true;
                    loop = false;
                    continue;
                }
                if (k <= 0) continue;
                this.extrapolate(0, k, y1Diag, y1);
                this.rescale(y, y1, scale);
                double error = 0.0;
                for (int j = 0; j < y0.length; ++j) {
                    double e = Math.abs(y1[j] - y1Diag[0][j]) / scale[j];
                    error += e * e;
                }
                if ((error = Math.sqrt(error / (double)y0.length)) > 1.0E15 || k > 1 && error > maxError) {
                    hNew = Math.abs(this.filterStep(this.stepSize * this.stabilityReduction, false));
                    reject = true;
                    loop = false;
                    continue;
                }
                maxError = Math.max(4.0 * error, 1.0);
                double exp = 1.0 / (double)(2 * k + 1);
                double fac = this.stepControl2 / Math.pow(error / this.stepControl1, exp);
                double pow = Math.pow(this.stepControl3, exp);
                fac = Math.max(pow / this.stepControl4, Math.min(1.0 / pow, fac));
                this.optimalStep[k] = Math.abs(this.filterStep(this.stepSize * fac, true));
                this.costPerTimeUnit[k] = (double)this.costPerStep[k] / this.optimalStep[k];
                switch (k - targetIter) {
                    case -1: {
                        if (targetIter <= 1 || previousRejected) continue block10;
                        if (error <= 1.0) {
                            loop = false;
                            break;
                        }
                        double ratio = (double)this.sequence[k] * (double)this.sequence[k + 1] / (double)(this.sequence[0] * this.sequence[0]);
                        if (!(error > ratio * ratio)) continue block10;
                        reject = true;
                        loop = false;
                        targetIter = k;
                        if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                            --targetIter;
                        }
                        hNew = this.optimalStep[targetIter];
                        break;
                    }
                    case 0: {
                        if (error <= 1.0) {
                            loop = false;
                            break;
                        }
                        double ratio = (double)this.sequence[k + 1] / (double)this.sequence[0];
                        if (!(error > ratio * ratio)) continue block10;
                        reject = true;
                        loop = false;
                        if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                            --targetIter;
                        }
                        hNew = this.optimalStep[targetIter];
                        break;
                    }
                    case 1: {
                        if (error > 1.0) {
                            reject = true;
                            if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                                --targetIter;
                            }
                            hNew = this.optimalStep[targetIter];
                        }
                        loop = false;
                        break;
                    }
                    default: {
                        if (!firstTime && !lastStep || !(error <= 1.0)) continue block10;
                        loop = false;
                    }
                }
            }
            double hInt = this.getMaxStep();
            if (this.denseOutput && !reject) {
                for (int j = 1; j <= k; ++j) {
                    this.extrapolate(0, j, diagonal, yMidDots[0]);
                }
                equations.computeDerivatives(this.stepStart + this.stepSize, y1, yDot1);
                int mu = 2 * k - this.mudif + 3;
                for (int l = 0; l < mu; ++l) {
                    int j;
                    int i;
                    int l2 = l / 2;
                    double factor = Math.pow(0.5 * (double)this.sequence[l2], l);
                    int middleIndex = fk[l2].length / 2;
                    for (i = 0; i < y0.length; ++i) {
                        yMidDots[l + 1][i] = factor * fk[l2][middleIndex + l][i];
                    }
                    for (j = 1; j <= k - l2; ++j) {
                        factor = Math.pow(0.5 * (double)this.sequence[j + l2], l);
                        middleIndex = fk[l2 + j].length / 2;
                        for (int i2 = 0; i2 < y0.length; ++i2) {
                            diagonal[j - 1][i2] = factor * fk[l2 + j][middleIndex + l][i2];
                        }
                        this.extrapolate(l2, j, diagonal, yMidDots[l + 1]);
                    }
                    i = 0;
                    while (i < y0.length) {
                        double[] dArray = yMidDots[l + 1];
                        int n = i++;
                        dArray[n] = dArray[n] * this.stepSize;
                    }
                    for (j = (l + 1) / 2; j <= k; ++j) {
                        for (int m = fk[j].length - 1; m >= 2 * (l + 1); --m) {
                            for (int i3 = 0; i3 < y0.length; ++i3) {
                                double[] dArray = fk[j][m];
                                int n = i3;
                                dArray[n] = dArray[n] - fk[j][m - 2][i3];
                            }
                        }
                    }
                }
                if (mu >= 0) {
                    GraggBulirschStoerStepInterpolator gbsInterpolator = (GraggBulirschStoerStepInterpolator)interpolator;
                    gbsInterpolator.computeCoefficients(mu, this.stepSize);
                    if (this.useInterpolationError) {
                        double interpError = gbsInterpolator.estimateError(scale);
                        hInt = Math.abs(this.stepSize / Math.max(Math.pow(interpError, 1.0 / (double)(mu + 4)), 0.01));
                        if (interpError > 10.0) {
                            hNew = hInt;
                            reject = true;
                        }
                    }
                    if (!reject) {
                        interpolator.storeTime(this.stepStart + this.stepSize);
                        if (this.switchesHandler.evaluateStep(interpolator)) {
                            reject = true;
                            hNew = Math.abs(this.switchesHandler.getEventTime() - this.stepStart);
                        }
                    }
                }
                if (!reject) {
                    firstStepAlreadyComputed = true;
                    System.arraycopy(yDot1, 0, yDot0, 0, y0.length);
                }
            }
            if (!reject) {
                int optimalIter;
                this.stepStart += this.stepSize;
                System.arraycopy(y1, 0, y, 0, y0.length);
                this.switchesHandler.stepAccepted(this.stepStart, y);
                if (this.switchesHandler.stop()) {
                    lastStep = true;
                }
                interpolator.storeTime(this.stepStart);
                this.handler.handleStep(interpolator, lastStep);
                if (this.switchesHandler.reset(this.stepStart, y) && !lastStep) {
                    firstStepAlreadyComputed = false;
                }
                if (k == 1) {
                    optimalIter = 2;
                    if (previousRejected) {
                        optimalIter = 1;
                    }
                } else if (k <= targetIter) {
                    optimalIter = k;
                    if (this.costPerTimeUnit[k - 1] < this.orderControl1 * this.costPerTimeUnit[k]) {
                        optimalIter = k - 1;
                    } else if (this.costPerTimeUnit[k] < this.orderControl2 * this.costPerTimeUnit[k - 1]) {
                        optimalIter = Math.min(k + 1, this.sequence.length - 2);
                    }
                } else {
                    optimalIter = k - 1;
                    if (k > 2 && this.costPerTimeUnit[k - 2] < this.orderControl1 * this.costPerTimeUnit[k - 1]) {
                        optimalIter = k - 2;
                    }
                    if (this.costPerTimeUnit[k] < this.orderControl2 * this.costPerTimeUnit[optimalIter]) {
                        optimalIter = Math.min(k, this.sequence.length - 2);
                    }
                }
                if (previousRejected) {
                    targetIter = Math.min(optimalIter, k);
                    hNew = Math.min(Math.abs(this.stepSize), this.optimalStep[targetIter]);
                } else {
                    hNew = optimalIter <= k ? this.optimalStep[optimalIter] : (k < targetIter && this.costPerTimeUnit[k] < this.orderControl2 * this.costPerTimeUnit[k - 1] ? this.filterStep(this.optimalStep[k] * (double)this.costPerStep[optimalIter + 1] / (double)this.costPerStep[k], false) : this.filterStep(this.optimalStep[k] * (double)this.costPerStep[optimalIter] / (double)this.costPerStep[k], false));
                    targetIter = optimalIter;
                }
                newStep = true;
            }
            hNew = Math.min(hNew, hInt);
            if (!forward) {
                hNew = -hNew;
            }
            firstTime = false;
            if (reject) {
                lastStep = false;
                previousRejected = true;
                continue;
            }
            previousRejected = false;
        }
    }
}

