/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.linalg;

import org.spaceroots.mantissa.linalg.LowerTriangularMatrix;
import org.spaceroots.mantissa.linalg.Matrix;
import org.spaceroots.mantissa.linalg.MatrixFactory;
import org.spaceroots.mantissa.linalg.NonNullRange;
import org.spaceroots.mantissa.linalg.SingularMatrixException;
import org.spaceroots.mantissa.linalg.SquareMatrix;
import org.spaceroots.mantissa.linalg.UpperTriangularMatrix;

public class GeneralSquareMatrix
extends SquareMatrix {
    private int[] permutations;
    private boolean evenPermutations;
    private LowerTriangularMatrix lower;
    private UpperTriangularMatrix upper;
    private static final long serialVersionUID = -506293526695298279L;

    public GeneralSquareMatrix(int order) {
        super(order);
        this.permutations = null;
        this.evenPermutations = true;
        this.lower = null;
        this.upper = null;
    }

    public GeneralSquareMatrix(int order, double[] data) {
        super(order, data);
        this.permutations = null;
        this.evenPermutations = true;
        this.lower = null;
        this.upper = null;
    }

    public GeneralSquareMatrix(GeneralSquareMatrix s) {
        super(s);
        if (s.permutations != null) {
            this.permutations = (int[])s.permutations.clone();
            this.evenPermutations = s.evenPermutations;
            this.lower = new LowerTriangularMatrix(s.lower);
            this.upper = new UpperTriangularMatrix(s.upper);
        } else {
            this.permutations = null;
            this.evenPermutations = true;
            this.lower = null;
            this.upper = null;
        }
    }

    @Override
    public Matrix duplicate() {
        return new GeneralSquareMatrix(this);
    }

    @Override
    public void setElement(int i, int j, double value) {
        super.setElement(i, j, value);
        this.permutations = null;
        this.evenPermutations = true;
        this.lower = null;
        this.upper = null;
    }

    public void selfAdd(SquareMatrix s) {
        if (this.rows != s.rows || this.columns != s.columns) {
            throw new IllegalArgumentException("cannot add a " + s.rows + 'x' + s.columns + " matrix to a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int index = 0; index < this.rows * this.columns; ++index) {
            int n = index;
            this.data[n] = this.data[n] + s.data[index];
        }
    }

    public void selfSub(SquareMatrix s) {
        if (this.rows != s.rows || this.columns != s.columns) {
            throw new IllegalArgumentException("cannot substract a " + s.rows + 'x' + s.columns + " matrix from a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int index = 0; index < this.rows * this.columns; ++index) {
            int n = index;
            this.data[n] = this.data[n] - s.data[index];
        }
    }

    @Override
    public double getDeterminant(double epsilon) {
        try {
            if (this.permutations == null) {
                this.computeLUFactorization(epsilon);
            }
            double d = this.upper.getDeterminant(epsilon);
            return this.evenPermutations ? d : -d;
        }
        catch (SingularMatrixException e) {
            return 0.0;
        }
    }

    @Override
    public Matrix solve(Matrix b, double epsilon) throws SingularMatrixException {
        if (b.getRows() != this.rows) {
            throw new IllegalArgumentException("dimension mismatch");
        }
        if (this.permutations == null) {
            this.computeLUFactorization(epsilon);
        }
        double[] permData = new double[b.data.length];
        int bCols = b.getColumns();
        for (int i = 0; i < this.rows; ++i) {
            NonNullRange range = b.getRangeForRow(this.permutations[i]);
            for (int j = range.begin; j < range.end; ++j) {
                permData[i * bCols + j] = b.data[this.permutations[i] * bCols + j];
            }
        }
        Matrix permB = MatrixFactory.buildMatrix(b.getRows(), bCols, permData);
        return this.upper.solve(this.lower.solve(permB, epsilon), epsilon);
    }

    @Override
    protected NonNullRange getRangeForRow(int i) {
        return new NonNullRange(0, this.columns);
    }

    @Override
    protected NonNullRange getRangeForColumn(int j) {
        return new NonNullRange(0, this.rows);
    }

    private void computeLUFactorization(double epsilon) throws SingularMatrixException {
        double[] work = new double[this.rows * this.columns];
        for (int index = 0; index < work.length; ++index) {
            work[index] = this.data[index];
        }
        this.permutations = new int[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.permutations[i] = i;
        }
        this.evenPermutations = true;
        for (int k = 0; k < this.rows; ++k) {
            double maxElt = Math.abs(work[this.permutations[k] * this.columns + k]);
            int jMax = k;
            for (int i = k + 1; i < this.rows; ++i) {
                double curElt = Math.abs(work[this.permutations[i] * this.columns + k]);
                if (!(curElt > maxElt)) continue;
                maxElt = curElt;
                jMax = i;
            }
            if (maxElt < epsilon) {
                throw new SingularMatrixException();
            }
            if (k != jMax) {
                int tmp = this.permutations[k];
                this.permutations[k] = this.permutations[jMax];
                this.permutations[jMax] = tmp;
                this.evenPermutations = !this.evenPermutations;
            }
            double inv = 1.0 / work[this.permutations[k] * this.columns + k];
            for (int i = k + 1; i < this.rows; ++i) {
                double factor;
                work[this.permutations[i] * this.columns + k] = factor = inv * work[this.permutations[i] * this.columns + k];
                int index1 = this.permutations[i] * this.columns + k;
                int index2 = this.permutations[k] * this.columns + k;
                for (int j = k + 1; j < this.columns; ++j) {
                    int n = ++index1;
                    work[n] = work[n] - factor * work[++index2];
                }
            }
        }
        double[] lowerData = new double[this.rows * this.columns];
        double[] upperData = new double[this.rows * this.columns];
        int index = 0;
        for (int i = 0; i < this.rows; ++i) {
            int workIndex = this.permutations[i] * this.columns;
            int j = 0;
            while (j++ < i) {
                lowerData[index] = work[workIndex++];
                upperData[index++] = 0.0;
            }
            lowerData[index] = 1.0;
            upperData[index++] = work[workIndex++];
            while (j++ < this.columns) {
                lowerData[index] = 0.0;
                upperData[index++] = work[workIndex++];
            }
        }
        this.lower = new LowerTriangularMatrix(this.rows, lowerData);
        this.upper = new UpperTriangularMatrix(this.rows, upperData);
    }
}

