/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.linalg;

import org.spaceroots.mantissa.linalg.Matrix;
import org.spaceroots.mantissa.linalg.NonNullRange;
import org.spaceroots.mantissa.linalg.SingularMatrixException;
import org.spaceroots.mantissa.linalg.SquareMatrix;

public class DiagonalMatrix
extends SquareMatrix {
    private static final long serialVersionUID = -2965166085913895323L;

    public DiagonalMatrix(int order) {
        this(order, 1.0);
    }

    public DiagonalMatrix(int order, double value) {
        super(order);
        for (int index = 0; index < order * order; index += order + 1) {
            this.data[index] = value;
        }
    }

    public DiagonalMatrix(int order, double[] data) {
        super(order, data);
    }

    public DiagonalMatrix(DiagonalMatrix d) {
        super(d);
    }

    @Override
    public Matrix duplicate() {
        return new DiagonalMatrix(this);
    }

    @Override
    public void setElement(int i, int j, double value) {
        if (i != j) {
            throw new ArrayIndexOutOfBoundsException("cannot set elements out of diagonal in a diagonal matrix");
        }
        super.setElement(i, j, value);
    }

    @Override
    public double getDeterminant(double epsilon) {
        double determinant = this.data[0];
        for (int index = this.columns + 1; index < this.columns * this.columns; index += this.columns + 1) {
            determinant *= this.data[index];
        }
        return determinant;
    }

    @Override
    public SquareMatrix getInverse(double epsilon) throws SingularMatrixException {
        DiagonalMatrix inv = new DiagonalMatrix(this.columns);
        for (int index = 0; index < this.columns * this.columns; index += this.columns + 1) {
            if (Math.abs(this.data[index]) < epsilon) {
                throw new SingularMatrixException();
            }
            inv.data[index] = 1.0 / this.data[index];
        }
        return inv;
    }

    @Override
    public Matrix solve(Matrix b, double epsilon) throws SingularMatrixException {
        Matrix result = b.duplicate();
        for (int i = 0; i < this.columns; ++i) {
            double diag = this.data[i * (this.columns + 1)];
            if (Math.abs(diag) < epsilon) {
                throw new SingularMatrixException();
            }
            double inv = 1.0 / diag;
            NonNullRange range = result.getRangeForRow(i);
            for (int index = i * b.columns + range.begin; index < i * b.columns + range.end; ++index) {
                result.data[index] = inv * b.data[index];
            }
        }
        return result;
    }

    @Override
    public NonNullRange getRangeForRow(int i) {
        return new NonNullRange(i, i + 1);
    }

    @Override
    public NonNullRange getRangeForColumn(int j) {
        return new NonNullRange(j, j + 1);
    }
}

