/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.tree;

import java.util.ArrayList;
import java.util.List;
import org.jlab.groot.tree.DatasetDescriptor;
import org.jlab.groot.tree.DynamicTree;
import org.jlab.groot.tree.ITree;

public class TreeAnalyzer {
    List<DatasetDescriptor> datasets = new ArrayList<DatasetDescriptor>();
    DynamicTree tree = new DynamicTree("Dataset Descriptors");

    public DynamicTree getTree() {
        return this.tree;
    }

    public void setTree(DynamicTree tree) {
        this.tree = tree;
    }

    public void addDescriptor(DatasetDescriptor desc) {
        this.datasets.add(desc);
        this.tree.addObject(desc.getDescName());
        System.out.println("Adding Descriptor" + desc.getDescName());
        this.tree.repaint();
        this.tree.revalidate();
    }

    public void process(ITree tree) {
        this.process(tree, -1);
    }

    public void process(ITree tree, int limit) {
        tree.reset();
        for (DatasetDescriptor desc : this.datasets) {
            desc.getDataSet().reset();
        }
        int nentries = tree.getEntries();
        for (int i = 0; i < nentries; ++i) {
            tree.readEntry(i);
            if (i > limit && limit > 0) break;
            for (DatasetDescriptor desc : this.datasets) {
                desc.fill(tree);
            }
        }
    }

    public List<DatasetDescriptor> getDescriptors() {
        return this.datasets;
    }

    public void updateDescriptor(DatasetDescriptor descriptor) {
        List<DatasetDescriptor> desc = this.getDescriptors();
        for (int i = 0; i < desc.size(); ++i) {
            if (!desc.get(i).getDescName().equals(descriptor.getDescName())) continue;
            desc.remove(i);
            desc.add(i, descriptor);
            System.out.println("Updating descriptor" + descriptor.getDescName());
        }
        System.out.println("Printing datasets:" + desc.size());
        for (DatasetDescriptor d1 : desc) {
            System.out.println(d1.getDescName());
        }
        this.datasets = desc;
    }
}

