/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.studio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.data.DataVector;
import org.jlab.groot.data.DatasetOperations;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.H2F;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.graphics.EmbeddedCanvasTabbed;
import org.jlab.groot.studio.StudioToolBar;
import org.jlab.groot.tree.DatasetDescriptor;
import org.jlab.groot.tree.DynamicTree;
import org.jlab.groot.tree.TreeAnalyzer;
import org.jlab.groot.tree.TreeCut;
import org.jlab.groot.tree.TreeFile;
import org.jlab.groot.tree.TreeProvider;
import org.jlab.groot.tree.TreeTextFile;
import org.jlab.groot.ui.CutPanel;
import org.jlab.groot.ui.DescriptorPanel;
import org.jlab.groot.ui.TreeEditor;

public class StudioUI
implements MouseListener,
ActionListener {
    JSplitPane splitPane = null;
    JPanel navigationPane = null;
    EmbeddedCanvas drawCanvas = null;
    EmbeddedCanvasTabbed drawCanvasTabbed = null;
    JFrame frame = null;
    TreeProvider studioTree = null;
    JTree jtree = null;
    JTree jtreeAnalyzer = null;
    JPanel studioPane = null;
    JPanel statusPane = null;
    JMenuBar menuBar = null;
    StudioToolBar toolBar = null;
    TreeAnalyzer analyzer = new TreeAnalyzer();
    Boolean previewMode = true;
    int previewEvents = 1000;
    JSplitPane secondSplitPane = null;
    JSplitPane thirdSplitPane = null;
    JScrollPane scrollPane = null;
    JCheckBoxMenuItem menuPreviewMode;
    TreePath lastLeaf = null;
    JLabel statusLabel = new JLabel("Status:");
    JLabel processedLabel = new JLabel("Processed:");
    ArrayList<JMenuItem> importMenuPlugins = new ArrayList();

    public void addImportMenuItem(JMenuItem item) {
        this.importMenuPlugins.add(item);
    }

    public StudioUI() {
    }

    public void init(TreeProvider tree) {
        this.frame = new JFrame("GROOT Studio");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (JOptionPane.showConfirmDialog(StudioUI.this.frame, "Are you sure to close this window?", "Really Closing?", 0, 3) == 0) {
                    StudioUI.this.frame.setVisible(false);
                }
            }
        });
        this.studioTree = tree;
        this.frame.setMinimumSize(new Dimension(300, 300));
        this.initUI();
        this.frame.pack();
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setSize((int)(screensize.getHeight() * 0.75 * 1.618), (int)(screensize.getHeight() * 0.75));
        this.splitPane.setDividerLocation(0.4);
        this.secondSplitPane.setDividerLocation(0.4);
        this.thirdSplitPane.setDividerLocation(0.2);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public StudioUI(TreeProvider tree) {
        this.init(tree);
    }

    private void initUI() {
        this.studioPane = new JPanel();
        this.studioPane.setLayout(new BorderLayout());
        this.initMenu();
        this.splitPane = new JSplitPane();
        this.navigationPane = new JPanel();
        JPanel canvasPane = new JPanel();
        canvasPane.setLayout(new BorderLayout());
        canvasPane.setBorder(BorderFactory.createBevelBorder(1));
        this.drawCanvas = new EmbeddedCanvas();
        this.drawCanvasTabbed = new EmbeddedCanvasTabbed();
        canvasPane.add((Component)this.drawCanvasTabbed, "Center");
        this.splitPane.setRightComponent(canvasPane);
        DynamicTree top = this.studioTree.tree().getDynamicTree();
        top.getTree().addMouseListener(this);
        this.scrollPane = new JScrollPane(top);
        this.secondSplitPane = new JSplitPane(0);
        this.thirdSplitPane = new JSplitPane(0);
        this.secondSplitPane.setTopComponent(this.scrollPane);
        this.thirdSplitPane.setTopComponent(this.studioTree.tree().getSelector().getTree());
        this.studioTree.tree().getSelector().getTree().getTree().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                System.out.println("Mouse clicked!");
                if (e.getClickCount() == 2 && (path = StudioUI.this.studioTree.tree().getSelector().getTree().getTree().getPathForLocation(e.getX(), e.getY())) != null) {
                    System.out.println(path.getLastPathComponent().toString());
                    if (StudioUI.this.studioTree.tree().getSelector().getSelectorCuts().containsKey(path.getLastPathComponent().toString()) && (e.getModifiers() & 2) != 0) {
                        StudioUI.this.editCut(StudioUI.this.studioTree.tree().getSelector().getSelectorCuts().get(path.getLastPathComponent().toString()));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.thirdSplitPane.setBottomComponent(this.analyzer.getTree());
        this.analyzer.getTree().getTree().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                System.out.println("Mouse clicked!");
                if (e.getClickCount() == 2 && (path = StudioUI.this.analyzer.getTree().getTree().getPathForLocation(e.getX(), e.getY())) != null) {
                    System.out.println(path.getLastPathComponent().toString());
                    for (int i = 0; i < StudioUI.this.analyzer.getDescriptors().size(); ++i) {
                        System.out.println(StudioUI.this.analyzer.getDescriptors().get(i).getDescName() + " " + path.getLastPathComponent().toString());
                        if (!StudioUI.this.analyzer.getDescriptors().get(i).getDescName().equals(path.getLastPathComponent().toString())) continue;
                        System.out.println(e.getModifiers());
                        if ((e.getModifiers() & 2) != 0) {
                            StudioUI.this.editDescriptor(StudioUI.this.analyzer.getDescriptors().get(i));
                            continue;
                        }
                        if ((e.getModifiers() & 1) != 0) {
                            System.out.println("Drawing same");
                            StudioUI.this.drawCanvasTabbed.getCanvas().draw(StudioUI.this.analyzer.getDescriptors().get(i).getDataSet(), "same");
                            StudioUI.this.drawCanvasTabbed.getCanvas().update();
                            continue;
                        }
                        StudioUI.this.drawCanvasTabbed.getCanvas().drawNext(StudioUI.this.analyzer.getDescriptors().get(i).getDataSet());
                        StudioUI.this.drawCanvasTabbed.getCanvas().update();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.secondSplitPane.setBottomComponent(this.thirdSplitPane);
        this.splitPane.setLeftComponent(this.secondSplitPane);
        this.splitPane.setDividerLocation(0.5);
        this.studioPane.add((Component)this.splitPane, "Center");
        this.frame.add(this.studioPane);
    }

    private void initMenu() {
        this.statusPane = new JPanel();
        this.statusPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel statusPane1 = new JPanel();
        JPanel statusPane2 = new JPanel();
        JPanel statusPane3 = new JPanel();
        statusPane1.setBorder(BorderFactory.createBevelBorder(1));
        statusPane2.setBorder(BorderFactory.createBevelBorder(1));
        statusPane3.setBorder(BorderFactory.createBevelBorder(1));
        statusPane1.add(this.statusLabel);
        statusPane2.add(this.processedLabel);
        statusPane3.add(new JLabel("Memory:"));
        this.statusPane.add((Component)statusPane1, c);
        this.statusPane.add((Component)statusPane2, c);
        this.statusPane.add((Component)statusPane3, c);
        this.studioPane.add((Component)this.statusPane, "Last");
        this.toolBar = new StudioToolBar(this);
        this.toolBar.fastButton.setSelected(this.previewMode);
        this.menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        JMenuItem newStudioWindow = new JMenuItem("New Window");
        JMenuItem menuFileOpen = new JMenuItem("Import ASCII File...");
        JMenuItem menuFileOpenHipo = new JMenuItem("Open HIPO File...");
        JMenuItem newHistogram = new JMenuItem("New Histogram...");
        JMenuItem newHistogram2D = new JMenuItem("New 2D Histogram...");
        JMenuItem newGraphErrors = new JMenuItem("New GraphErrors...");
        JMenuItem exit = new JMenuItem("Exit");
        JMenuItem closeWindow = new JMenuItem("Close Window");
        JMenu menuEdit = new JMenu("Edit");
        this.menuPreviewMode = new JCheckBoxMenuItem("Preview Mode");
        JMenuItem menuOperations = new JMenuItem("Operations");
        menuOperations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StudioUI.this.datasetOperationDialog();
            }
        });
        JMenu menuRun = new JMenu("Run");
        JMenuItem menuItemPlay = new JMenuItem("Play");
        menuItemPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StudioUI.this.processPlay();
            }
        });
        menuRun.add(menuItemPlay);
        menuEdit.add(this.menuPreviewMode);
        menuEdit.add(menuOperations);
        this.menuPreviewMode.setSelected(this.previewMode);
        this.menuPreviewMode.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.menuPreviewMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StudioUI.this.previewMode = StudioUI.this.menuPreviewMode.isSelected();
                StudioUI.this.toolBar.fastButton.setSelected(StudioUI.this.previewMode);
            }
        });
        JMenu menuHelp = new JMenu("Help");
        JMenuItem about = new JMenuItem("About...");
        menuHelp.add(about);
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(null, "GROOT Documentation\n https://github.com/gavalian/groot/wiki\n  Bug Reporting:\n https://github.com/gavalian/groot/issues\n Gagik Gavalian and Will Phelps\n gavalian@jlab.org , wphelps@jlab.org", "About", 1);
            }
        });
        closeWindow.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        closeWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StudioUI.this.frame.dispose();
            }
        });
        newStudioWindow.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        newStudioWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new StudioUI(StudioUI.this.studioTree);
            }
        });
        menuFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuFileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String file = StudioUI.this.chooseFile("Select ASCII File to Open", true);
                StudioUI.this.openASCIIFile(file);
            }
        });
        menuFileOpenHipo.setAccelerator(KeyStroke.getKeyStroke(79, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuFileOpenHipo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String file = StudioUI.this.chooseFile("Select HIPO File to Open", true);
                StudioUI.this.openHipoFile(file);
            }
        });
        exit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        newHistogram.setAccelerator(KeyStroke.getKeyStroke(78, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        newHistogram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StudioUI.this.addDescriptor(1);
            }
        });
        newHistogram2D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StudioUI.this.addDescriptor(2);
            }
        });
        newGraphErrors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StudioUI.this.addDescriptor(3);
            }
        });
        menuFile.add(newStudioWindow);
        menuFile.add(new JSeparator());
        menuFile.add(menuFileOpen);
        menuFile.add(menuFileOpenHipo);
        for (JMenuItem item : this.importMenuPlugins) {
            menuFile.add(item);
        }
        menuFile.add(new JSeparator());
        menuFile.add(newHistogram);
        menuFile.add(newHistogram2D);
        menuFile.add(newGraphErrors);
        menuFile.add(new JSeparator());
        menuFile.add(closeWindow);
        menuFile.add(exit);
        this.menuBar.add(menuFile);
        this.menuBar.add(menuEdit);
        this.menuBar.add(menuRun);
        this.menuBar.add(menuHelp);
        this.studioPane.add((Component)this.toolBar.getToolBar(), "First");
        this.frame.setJMenuBar(this.menuBar);
    }

    public void openHipoFile(String file) {
        if (file != null) {
            System.out.println("Open new hipo File:" + file);
            TreeFile tree = new TreeFile("HipoTree");
            tree.openFile(file);
        }
    }

    public void openASCIIFile(String file) {
        if (file != null) {
            System.out.println("Open new ASCII File:" + file);
            TreeTextFile tree = new TreeTextFile("TextTree");
            tree.readFile(file);
            new StudioUI(tree);
        }
    }

    public void createNewGraphErrors() {
        System.out.println("Create new graph errors");
    }

    public void createNewHistogram() {
        System.out.println("Create new Histogram");
    }

    public void createNewHistogram2D() {
        System.out.println("Create new Histogram 2D");
    }

    public void datasetOperationDialog() {
        JDialog dialog = DatasetOperations.createOperations(this.frame, this.drawCanvasTabbed.getCanvas().getObjectMap());
        dialog.setLocationRelativeTo(this.frame);
        dialog.setVisible(true);
        List<IDataSet> results = ((DatasetOperations)dialog.getContentPane()).getResults();
        System.out.println("Finished operation result size = " + results.size());
        for (int i = 0; i < results.size(); ++i) {
            this.drawCanvasTabbed.getCanvas().drawNext(results.get(i));
        }
    }

    public String chooseFile(String name, boolean open) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(chooser.getCurrentDirectory());
        chooser.setDialogTitle(name);
        chooser.setAcceptAllFileFilterUsed(true);
        if (open) {
            if (chooser.showOpenDialog(new JFrame()) == 0) {
                return chooser.getSelectedFile().toString();
            }
            return null;
        }
        if (chooser.showSaveDialog(new JFrame()) == 0) {
            return chooser.getSelectedFile().toString();
        }
        return null;
    }

    public H1F scanTreeItem(TreePath item) {
        TreePath[] paths = new TreePath[]{item};
        System.out.println("getting vector for item = " + item);
        List<DataVector> vec = this.previewMode != false ? this.studioTree.actionTreeNode(paths, this.previewEvents) : this.studioTree.actionTreeNode(paths, -1);
        if (vec.size() >= 1) {
            System.out.println("result = " + vec.get(0).size());
            H1F h1d = H1F.create(item.getLastPathComponent().toString(), vec.get(0).getBinSuggestion(), vec.get(0));
            h1d.setTitle(item.getLastPathComponent().toString());
            h1d.setTitleX(item.getLastPathComponent().toString());
            h1d.setTitleY("Entries");
            return h1d;
        }
        return null;
    }

    public H2F scanTreeItemH2F(TreePath item) {
        TreePath[] paths = new TreePath[]{this.lastLeaf, item};
        System.out.println("getting vector for item = " + item);
        List<DataVector> vec = this.previewMode != false ? this.studioTree.actionTreeNode(paths, this.previewEvents) : this.studioTree.actionTreeNode(paths, -1);
        System.out.println("Vector size" + vec.size());
        if (vec.size() == 2) {
            H2F h2d = H2F.create(item.getLastPathComponent().toString() + "_vs_" + this.lastLeaf.getLastPathComponent().toString(), vec.get(0).getBinSuggestion(), vec.get(1).getBinSuggestion(), vec.get(0), vec.get(1));
            h2d.setTitle(item.getLastPathComponent().toString() + ":" + this.lastLeaf.toString());
            h2d.setTitleX(item.getLastPathComponent().toString());
            h2d.setTitleY(this.lastLeaf.getLastPathComponent().toString());
            return h2d;
        }
        return null;
    }

    public void processPlay() {
        this.statusLabel.setText("Status:Running");
        this.processedLabel.setText("Processed: 0 events");
        System.out.println("---> Replaying all the descriptors from the tree");
        if (this.previewMode.booleanValue()) {
            this.analyzer.process(this.studioTree.tree(), this.previewEvents);
            this.processedLabel.setText("Processed: " + this.previewEvents + " events");
        } else {
            this.analyzer.process(this.studioTree.tree());
            this.processedLabel.setText("Processed: " + this.studioTree.tree().getEntries() + " events");
        }
        System.out.println("---> done replaying");
        this.statusLabel.setText("Status: Finished Running");
    }

    public boolean isTree(String item) {
        return this.studioTree.tree().getName() == item;
    }

    public void addCut() {
        System.out.println("doing some stuff...");
        CutPanel cutPane = new CutPanel(this.studioTree.tree());
        JFrame frame = new JFrame("Cut Editor");
        frame.add(cutPane);
        frame.pack();
        frame.setLocationRelativeTo(this.frame);
        frame.setMinimumSize(frame.getSize());
        frame.setVisible(true);
    }

    private void editCut(TreeCut treeCut) {
        System.out.println("Editing cut");
        CutPanel cutPane = new CutPanel(this.studioTree.tree(), treeCut);
        JFrame frame = new JFrame("Cut Editor");
        frame.add(cutPane);
        frame.pack();
        frame.setLocationRelativeTo(this.frame);
        frame.setMinimumSize(frame.getSize());
        frame.setVisible(true);
    }

    public void addDescriptor(int dim) {
        JFrame frame = new JFrame("Edit Histogram");
        DescriptorPanel panel = new DescriptorPanel(this.studioTree.tree(), this.analyzer, dim);
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(this.frame);
        frame.setVisible(true);
    }

    public void editDescriptor(DatasetDescriptor desc) {
        JFrame frame = new JFrame("Edit Descriptor");
        DescriptorPanel panel = new DescriptorPanel(this.studioTree.tree(), this.analyzer, desc);
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(this.frame);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        GStyle.getGraphErrorsAttributes().setMarkerStyle(0);
        GStyle.getGraphErrorsAttributes().setMarkerColor(3);
        GStyle.getGraphErrorsAttributes().setMarkerSize(7);
        GStyle.getGraphErrorsAttributes().setLineColor(3);
        GStyle.getGraphErrorsAttributes().setLineWidth(2);
        GStyle.getFunctionAttributes().setLineWidth(6);
        GStyle.getAxisAttributesX().setTitleFontSize(14);
        GStyle.getAxisAttributesX().setLabelFontSize(12);
        GStyle.getAxisAttributesY().setTitleFontSize(14);
        GStyle.getAxisAttributesY().setLabelFontSize(12);
        GStyle.getH1FAttributes().setFillColor(43);
        GStyle.getH1FAttributes().setOptStat("1110");
        TreeTextFile tree = new TreeTextFile("TextTree");
        tree.readFile("src/main/resources/sample_data/studio_data/pp_10k_wlab.txt");
        new StudioUI(tree);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path;
        if (e.getClickCount() == 2 && (path = this.studioTree.tree().getDynamicTree().getTree().getPathForLocation(e.getX(), e.getY())) != null) {
            System.out.println(path.getLastPathComponent().toString());
            H1F histogram = this.scanTreeItem(path);
            if (histogram != null) {
                if ((e.getModifiers() & 2) != 0) {
                    System.out.println("Control mask");
                    H2F h2d = this.scanTreeItemH2F(path);
                    this.drawCanvasTabbed.getCanvas().drawNext(h2d);
                    this.drawCanvasTabbed.getCanvas().update();
                } else if ((e.getModifiers() & 1) != 0) {
                    System.out.println("Drawing same");
                    this.drawCanvasTabbed.getCanvas().draw(histogram, "same");
                    this.drawCanvasTabbed.getCanvas().update();
                } else {
                    this.drawCanvasTabbed.getCanvas().drawNext(histogram);
                    this.drawCanvasTabbed.getCanvas().update();
                }
            }
            if (this.isTree(path.getLastPathComponent().toString())) {
                JFrame editorFrame = new JFrame("Tree Editor:" + path.getLastPathComponent().toString());
                TreeEditor editor = new TreeEditor(this.studioTree.tree());
                editorFrame.add(editor);
                editorFrame.pack();
                editorFrame.setLocationRelativeTo(this.frame);
                editorFrame.setVisible(true);
            }
            if (this.lastLeaf != path) {
                this.lastLeaf = path;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JDialog dialog;
        System.out.println("Action appeared = " + e.getActionCommand());
        if (e.getActionCommand().compareTo("Add Descriptor") == 0) {
            this.addDescriptor(1);
        }
        if (e.getActionCommand().compareTo("Add Cut") == 0) {
            this.addCut();
        }
        if (e.getActionCommand().compareTo("Add GraphErrors") == 0) {
            this.addDescriptor(3);
        }
        if (e.getActionCommand().compareTo("Play") == 0) {
            this.processPlay();
        }
        if (e.getActionCommand().compareTo("Preview Mode") == 0) {
            this.previewMode = this.toolBar.fastButton.isSelected();
            this.menuPreviewMode.setSelected(this.previewMode);
        }
        if (e.getActionCommand().compareTo("Import ASCII") == 0) {
            this.openASCIIFile(this.chooseFile("Import ASCII File", true));
        }
        if (e.getActionCommand().compareTo("Action Jack") == 0) {
            this.datasetOperationDialog();
        }
        if (e.getActionCommand().compareTo("Edit Tree") == 0 && (dialog = this.studioTree.treeConfigure()) != null) {
            dialog.setLocationRelativeTo(this.frame);
            dialog.setVisible(true);
            if (dialog.getComponentCount() == 1) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }
}

