/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.matrix;

import org.jlab.hipo.io.HipoByteUtils;

public class SparseIndex {
    int[] binsPerAxis;
    int[] bitsPerAxis;
    int[] offset;
    int rank;

    public SparseIndex(int[] binsPerAxis) {
        this.binsPerAxis = binsPerAxis;
        this.rank = binsPerAxis.length;
        this.bitsPerAxis = new int[this.rank];
        this.offset = new int[this.rank];
        this.calculateBitsPerAxis();
        this.calculateOffset();
    }

    private void calculateBitsPerAxis() {
        for (int axis = 0; axis < this.rank; ++axis) {
            this.bitsPerAxis[axis] = 32 - Integer.numberOfLeadingZeros(this.binsPerAxis[axis]);
        }
    }

    private void calculateOffset() {
        int totalOffset = 0;
        for (int iaxis = 0; iaxis < this.rank; ++iaxis) {
            this.offset[iaxis] = totalOffset;
            totalOffset += this.bitsPerAxis[iaxis];
        }
    }

    public long getKey(int[] bin) {
        if (bin.length != this.rank) {
            throw new ArrayStoreException();
        }
        long key = 0L;
        for (int iaxis = 0; iaxis < this.rank; ++iaxis) {
            key = HipoByteUtils.writeLong(key, bin[iaxis], this.offset[iaxis], this.offset[iaxis] + this.bitsPerAxis[iaxis]);
        }
        return key;
    }

    public boolean isCompatible(SparseIndex sindex) {
        if (this.getRank() != sindex.getRank()) {
            return false;
        }
        int[] bins = sindex.getBinsPerAxis();
        for (int i = 0; i < bins.length; ++i) {
            if (bins[i] == this.binsPerAxis[i]) continue;
            return false;
        }
        return true;
    }

    public long getKeyFast(int[] bin) {
        long key = 0L;
        for (int axis = 0; axis < this.rank; ++axis) {
            key = HipoByteUtils.writeLong(key, bin[axis], this.offset[axis], this.offset[axis] + this.bitsPerAxis[axis]);
        }
        return key;
    }

    public void getIndex(long key, int[] bin) {
        int index = 0;
        for (int iaxis = 0; iaxis < this.rank; ++iaxis) {
            bin[iaxis] = HipoByteUtils.readLong(key, index, index + this.bitsPerAxis[iaxis] - 1);
            index += this.bitsPerAxis[iaxis];
        }
    }

    public int getOffset(int axis) {
        return this.offset[axis];
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getBinsPerAxis() {
        return this.binsPerAxis;
    }

    public int[] getBinsPerAxisCopy() {
        int[] bins = new int[this.binsPerAxis.length];
        for (int i = 0; i < bins.length; ++i) {
            bins[i] = this.binsPerAxis[i];
        }
        return bins;
    }

    public int[] getBitsPerAxis() {
        return this.bitsPerAxis;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{binsPerAxis, bitsPerAxis} = ");
        for (int iAxis = 0; iAxis < this.rank; ++iAxis) {
            builder.append(String.format("{%d,%d} ", this.binsPerAxis[iAxis], this.bitsPerAxis[iAxis]));
        }
        return builder.toString();
    }
}

