/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.matrix;

import java.util.Map;
import org.jlab.groot.data.DataVector;
import org.jlab.groot.matrix.SparseVectorGrid;

public class GridOperations {
    public static SparseVectorGrid divideGrid(SparseVectorGrid gridNom, SparseVectorGrid gridDenom, int orderNom, int orderDenom, boolean extend) {
        if (gridDenom.getIndexer().isCompatible(gridNom.getIndexer())) {
            SparseVectorGrid grid = new SparseVectorGrid(gridNom.getIndexer().getBinsPerAxisCopy());
            for (Map.Entry<Long, DataVector> entry : gridNom.getGrid().entrySet()) {
                double valueDenom;
                double valueNom = entry.getValue().getValue(orderNom);
                if (!gridDenom.getGrid().containsKey(entry.getKey()) || (valueDenom = gridDenom.getGrid().get(entry.getKey()).getValue(orderDenom)) == 0.0) continue;
                double result = valueNom / valueDenom;
                DataVector vec = new DataVector(1);
                vec.set(0, result);
                grid.getGrid().put(entry.getKey(), vec);
            }
        }
        return new SparseVectorGrid();
    }
}

