/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

public class UserParameter {
    String pName;
    double pValue;
    double pMin;
    double pMax;
    double pError;
    double pStep = 1.0E-4;
    boolean isRangeLimited = false;

    public UserParameter() {
        this.pName = "p0";
        this.pValue = 0.0;
        this.pMin = -1.0E10;
        this.pMax = 1.0E10;
        this.pError = 0.0;
    }

    public UserParameter(String name, double value) {
        this.pName = name;
        this.pValue = value;
        this.pMin = -1.0E10;
        this.pMax = 1.0E10;
        this.pError = 0.0;
    }

    public UserParameter(String name, double value, double min, double max) {
        this.pName = name;
        this.pValue = value;
        this.pMin = min;
        this.pMax = max;
        this.pError = 0.0;
    }

    public void setStep(double step) {
        this.pStep = step;
    }

    public void setError(double error) {
        this.pError = error;
    }

    public void setName(String name) {
        this.pName = name;
    }

    public void setLimits(double min, double max) {
        this.pMin = min;
        this.pMax = max;
        this.isRangeLimited = true;
    }

    public boolean isLimited() {
        return this.isRangeLimited;
    }

    public void setFree() {
        this.isRangeLimited = false;
        this.pMin = -1.0E10;
        this.pMax = 1.0E10;
    }

    public void multLimits(double factor) {
        double range = Math.abs(this.pMax - this.pMin);
        double median = this.pMin + Math.abs(this.pMax - this.pMin) / 2.0;
        double pMin = median - range * factor;
        double pMax = median + range * factor;
    }

    public void set(double value, double min, double max) {
        this.setValue(value);
        this.setLimits(min, max);
    }

    public void setValue(double value) {
        this.pValue = value;
    }

    public double value() {
        return this.pValue;
    }

    public String name() {
        return this.pName;
    }

    public double min() {
        return this.pMin;
    }

    public double max() {
        return this.pMax;
    }

    public double error() {
        return this.pError;
    }

    public void setRandom() {
        this.pValue = this.pMin + Math.random() * Math.abs(this.pMax - this.pMin);
    }

    public double getStep() {
        return this.pStep;
    }

    public double getRandom() {
        return this.pMin + Math.random() * Math.abs(this.pMax - this.pMin);
    }

    public UserParameter getCopy() {
        UserParameter par = new UserParameter(this.name(), this.value());
        if (this.isRangeLimited) {
            par.setLimits(this.pMin, this.pMax);
        }
        return par;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(String.format("%18s : %18e %18e %18e %18e", this.name(), this.value(), this.error(), this.min(), this.max()));
        return str.toString();
    }
}

