/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import org.jlab.groot.math.ErrorFunction;
import org.jlab.groot.math.Func1D;
import org.jlab.groot.math.FunctionFactory;
import org.jlab.groot.math.UserParameter;

public class F1D
extends Func1D {
    Expression expr = null;
    private String expressionString = "";
    private List<String> expressionVariables = new ArrayList<String>();
    Function funcLogb = new Function("logb", 2){

        @Override
        public double apply(double ... args) {
            return Math.log(args[0]) / Math.log(args[1]);
        }
    };
    Function funcGaus = new Function("gaus", 3){

        @Override
        public double apply(double ... args) {
            return FunctionFactory.gauss(args[0], args[1], args[2]);
        }
    };
    Function funcLandau = new Function("landau", 3){

        @Override
        public double apply(double ... args) {
            return FunctionFactory.landau(args[0], args[1], args[2]);
        }
    };
    Function funcExp = new Function("exp", 1){

        @Override
        public double apply(double ... args) {
            return Math.exp(args[0]);
        }
    };
    Function funcErrf = new Function("erf", 3){

        @Override
        public double apply(double ... args) {
            return ErrorFunction.erf(0.0, 1.0, args[1], args[2], args[0]);
        }
    };

    public F1D(String name) {
        super(name);
    }

    public F1D(String name, String expression, double min, double max) {
        super(name, min, max);
        this.parse(expression);
    }

    public final void parse(String str) {
        String funcString;
        this.expressionString = str;
        int pos_o = str.indexOf("[");
        LinkedHashSet<String> params = new LinkedHashSet<String>();
        while (pos_o >= 0) {
            int pos_c = str.indexOf("]", pos_o);
            String param = str.substring(pos_o + 1, pos_c);
            params.add(param);
            pos_o = str.indexOf("[", pos_c);
        }
        String newString = funcString = str;
        this.expressionVariables.clear();
        for (String par : params) {
            String item = "[" + par + "]";
            this.expressionVariables.add(par);
            newString = newString.replace(item, par);
        }
        int npars = this.expressionVariables.size();
        String[] expvar = new String[npars + 1];
        expvar[0] = "x";
        for (int i = 0; i < npars; ++i) {
            expvar[i + 1] = this.expressionVariables.get(i);
            this.addParameter(this.expressionVariables.get(i));
        }
        ExpressionBuilder builder = new ExpressionBuilder(newString).function(this.funcGaus).function(this.funcLandau).function(this.funcLogb).function(this.funcErrf).function(this.funcExp);
        builder.variables(expvar);
        this.expr = builder.build();
    }

    @Override
    public String getExpression() {
        return this.expressionString;
    }

    @Override
    public double evaluate(double x) {
        this.expr.setVariable("x", x);
        for (int i = 0; i < this.getNPars(); ++i) {
            UserParameter par = this.parameter(i);
            this.expr.setVariable(par.name(), par.value());
        }
        return this.expr.evaluate();
    }

    public static void main(String[] args) {
        System.out.println("---> starting program");
        F1D func = new F1D("f1d", "[amp]*gaus(x,[mean],[sigma])", 0.1, 0.8);
        F1D func2 = new F1D("f1d", "[a]*gaus(x,[m],[s])+[h]*exp([f])", 0.1, 0.8);
        func2.setParameter(0, 10.0);
        func2.setParameter(1, 0.5);
        func2.setParameter(2, 0.2);
        func2.setParameter(3, 10.0);
        func2.setParameter(4, -2.0);
        System.out.println(func2.toString());
        for (double x = func.getMin(); x < func.getMax(); x += 0.05) {
            double value = func2.evaluate(x);
            System.out.println("x = " + x + "  value = " + value);
        }
    }
}

