/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

import java.io.Serializable;

public class Axis
implements Serializable {
    public double[] axisMargins;
    private int numBins;
    private String axisTitle = "x";
    private double minVal;
    private double maxVal;
    private boolean isUniform = true;

    public Axis() {
        this.set(1, 0.0, 1.0);
    }

    public Axis(double[] limits) {
        this.set(limits);
        this.isUniform = false;
    }

    public Axis(int bins, double min, double max) {
        this.set(bins, min, max);
    }

    public void setTitle(String title) {
        this.axisTitle = title;
    }

    public String getTitle() {
        return this.axisTitle;
    }

    public final void set(double[] limits) {
        this.axisMargins = new double[limits.length];
        for (int i = 0; i < limits.length; ++i) {
            this.axisMargins[i] = limits[i];
        }
        this.numBins = this.axisMargins.length - 1;
        this.minVal = this.axisMargins[0];
        this.maxVal = this.axisMargins[this.numBins];
    }

    public final void set(int bins, double min, double max) {
        this.numBins = bins;
        if (min <= max) {
            this.minVal = min;
            this.maxVal = max;
        } else {
            this.minVal = max;
            this.maxVal = min;
        }
        double binWidth = (this.maxVal - this.minVal) / (double)bins;
        this.axisMargins = new double[bins + 1];
        for (int i = 0; i <= bins; ++i) {
            this.axisMargins[i] = this.minVal + (double)i * binWidth;
        }
    }

    public double[] getLimits() {
        return this.axisMargins;
    }

    public int getNBins() {
        return this.numBins;
    }

    public double max() {
        return this.maxVal;
    }

    public double[] getBinCenters() {
        double[] centers = new double[this.getNBins()];
        for (int loop = 0; loop < this.getNBins(); ++loop) {
            centers[loop] = this.getBinCenter(loop);
        }
        return centers;
    }

    public double min() {
        return this.minVal;
    }

    public double getBinCenter(int bin) {
        if (bin >= 0 && bin < this.axisMargins.length - 1) {
            return this.axisMargins[bin] + (this.axisMargins[bin + 1] - this.axisMargins[bin]) * 0.5;
        }
        return 0.0;
    }

    public double getBinWidth(int bin) {
        if (bin >= 0 && bin < this.numBins) {
            return Math.abs(this.axisMargins[bin + 1] - this.axisMargins[bin]);
        }
        return 0.0;
    }

    public int getBin(double xVal) {
        if (xVal < this.axisMargins[0]) {
            return -1;
        }
        for (int i = 0; i < this.numBins; ++i) {
            if (!(xVal >= this.axisMargins[i]) || !(xVal < this.axisMargins[i + 1])) continue;
            return i;
        }
        return this.numBins;
    }

    public double convertFromUnit(double xUnit) {
        double value = (this.maxVal - this.minVal) * xUnit;
        return this.minVal + value;
    }
}

