/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jlab.groot.graphics.GraphicsAxis;

public class GraphicsAxisTests
extends JPanel {
    GraphicsAxis axis = new GraphicsAxis(GraphicsAxis.AXISTYPE_HORIZONTAL);

    public GraphicsAxisTests() {
        this.setPreferredSize(new Dimension(500, 500));
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int w = this.getWidth();
        int h = this.getHeight();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, w, h);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(20, 200, w - 40, 100);
        this.axis.getDimension().setMinMax(20.0, w - 20);
        this.axis.getRange().setMinMax(0.0, 1.0);
        this.axis.drawAxis(g2d, 20, 300);
        this.axis.drawAxisMirror(g2d, 20, 300, 100);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        GraphicsAxisTests canvas = new GraphicsAxisTests();
        frame.add(canvas);
        frame.pack();
        frame.setVisible(true);
    }
}

