/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;

public class Directory<T> {
    String directoryName = "/";
    Directory parentDirectory = null;
    Directory currentDirectory = null;
    Map<String, Directory> directoryMap = new LinkedHashMap<String, Directory>();
    Map<String, T> directoryObjects = new HashMap<String, T>();

    public Directory() {
    }

    public Directory(Directory parent, String name) {
        this.parentDirectory = parent;
        this.directoryName = name;
    }

    public String stringDirectoryFromPath(String path) {
        int index = path.lastIndexOf("/");
        return path.substring(0, index);
    }

    public String stringObjectFromPath(String path) {
        int index = path.lastIndexOf("/");
        return path.substring(index + 1, path.length());
    }

    private void mkdir_s(String name) {
        if (this.currentDirectory == null) {
            if (!this.directoryMap.containsKey(name)) {
                Directory<T> dir = new Directory<T>(this, name);
                this.directoryMap.put(name, dir);
            }
        } else if (!this.currentDirectory.getDirectoryMap().containsKey(name)) {
            Directory<T> dir = new Directory<T>(this.currentDirectory, name);
            this.currentDirectory.getDirectoryMap().put(name, dir);
        }
    }

    public synchronized void mkdir(String name) {
        if (!name.contains("/")) {
            this.mkdir_s(name);
            return;
        }
        String path = null;
        boolean rootRef = false;
        if (!name.startsWith("/")) {
            path = name;
        } else {
            path = name.substring(1, name.length());
            rootRef = true;
        }
        Directory saveDir = this.currentDirectory;
        String[] tokens = path.split("/");
        if (rootRef) {
            this.cd();
        }
        for (String token : tokens) {
            this.mkdir_s(token);
            this.cd(token);
        }
        this.currentDirectory = saveDir;
    }

    public Map<String, Directory> getDirectoryMap() {
        return this.directoryMap;
    }

    public Map<String, T> getObjectMap() {
        return this.directoryObjects;
    }

    public void cd() {
        this.currentDirectory = null;
    }

    public Directory getRoot() {
        if (this.getParent() == null) {
            return this;
        }
        Directory parent = this.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public Directory getDirectoryByPath(String path) {
        String[] tokens = path.split("/");
        Directory root = this.getRoot();
        for (String item : tokens) {
            if (root.cd(item)) continue;
            return null;
        }
        return root.getDir();
    }

    public boolean cd(String name) {
        Directory saveDir = this.currentDirectory;
        Directory startDir = this.currentDirectory;
        String relativePath = name;
        if (this.currentDirectory == null) {
            startDir = this;
        }
        if (name.startsWith("/")) {
            startDir = this;
            relativePath = name.substring(1, name.length());
        }
        boolean success = true;
        if (!name.contains("/")) {
            if (startDir.getDirectoryMap().containsKey(name)) {
                this.currentDirectory = startDir.getDirectoryMap().get(name);
            } else {
                System.out.println("[Directory::cd] error -> directory " + name + " is not found in : " + startDir.getDirectoryPath(startDir));
                success = false;
            }
            return success;
        }
        String[] tokens = relativePath.split("/");
        for (int index = 0; success && index < tokens.length; ++index) {
            if (startDir.getDirectoryMap().containsKey(tokens[index])) {
                startDir = startDir.getDirectoryMap().get(tokens[index]);
                continue;
            }
            System.out.println("[Directory::cd] error -> directory " + tokens[index] + " is not found in : " + startDir.getDirectoryPath());
            success = false;
        }
        this.currentDirectory = !success ? saveDir : startDir;
        return success;
    }

    public Directory getParent() {
        return this.parentDirectory;
    }

    public String getName() {
        return this.directoryName;
    }

    public List<String> getDirectoryPath(Directory dir) {
        ArrayList<String> pathElements = new ArrayList<String>();
        if (dir.getParent() == null) {
            pathElements.add("/");
            return pathElements;
        }
        String lastName = dir.getName();
        pathElements.add(lastName);
        for (Directory parent = dir.getParent(); parent != null; parent = parent.getParent()) {
            pathElements.add(0, parent.getName());
        }
        return pathElements;
    }

    public String getDirectoryPath() {
        if (this.currentDirectory == null && this.parentDirectory == null) {
            return "/";
        }
        List<String> path = this.getDirectoryPath(this);
        StringBuilder str = new StringBuilder();
        for (String element : path) {
            str.append(element);
            str.append("/");
        }
        str.deleteCharAt(str.length() - 1);
        str.deleteCharAt(0);
        return str.toString();
    }

    public void add(String name, T object) {
        Directory dir = this.getDir();
        if (dir.getObjectMap().containsKey(name)) {
            System.out.println("[TDirectory] [" + dir.getDirectoryPath() + "]---> replacing object " + name);
        }
        dir.getObjectMap().put(name, object);
    }

    public void pwd() {
        System.out.println("pwd : " + this.getDir().getDirectoryPath());
    }

    private String getDirectoryList(Directory dir) {
        StringBuilder str = new StringBuilder();
        Iterator<Map.Entry<String, Directory>> iterator = dir.getDirectoryMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Directory> entry;
            Map.Entry<String, Directory> object = entry = iterator.next();
            str.append("\t <dir> ");
            str.append(object.getKey());
            str.append("\n");
        }
        return str.toString();
    }

    public void ls() {
        System.out.println("dir (ls) :  " + this.getDirectoryPath());
        Directory dir = this.getDir();
        System.out.println(this.getDirectoryList(dir));
    }

    public void tree() {
        Directory dir = this.getDir();
        List<String> objectList = dir.getCompositeObjectList(dir);
        int counter = 0;
        for (String item : objectList) {
            System.out.println(counter + " : " + item);
            ++counter;
        }
    }

    public T getObject(String directory, String name) {
        String[] path = directory.split("/");
        this.cd();
        for (String element : path) {
            System.out.println("debug : trying " + element);
            if (this.cd(element)) continue;
            return null;
        }
        if (!this.getDir().getObjectMap().containsKey(name)) {
            return null;
        }
        return this.getDir().getObjectMap().get(name);
    }

    public void clear() {
        this.directoryMap.clear();
        this.directoryObjects.clear();
        this.currentDirectory = null;
    }

    public T getObject(String fullPath) {
        int index = fullPath.lastIndexOf("/");
        String path = fullPath.substring(0, index);
        String object = fullPath.substring(index + 1, fullPath.length());
        Directory saveDir = this.currentDirectory;
        boolean status = this.cd(path);
        if (status) {
            T item = this.getDir().getObjectMap().get(object);
            this.currentDirectory = saveDir;
            return item;
        }
        return null;
    }

    public Directory getDir() {
        if (this.currentDirectory == null) {
            return this;
        }
        return this.currentDirectory;
    }

    public Directory getDir(String dirName) {
        return this.directoryMap.get(dirName);
    }

    public List<String> getDirectoryList() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.directoryMap.keySet());
        return keys;
    }

    public List<T> getObjectList() {
        ArrayList<T> dsList = new ArrayList<T>();
        dsList.addAll(this.directoryObjects.values());
        return dsList;
    }

    public List<String> getCompositeObjectList(Directory dir) {
        ArrayList<String> objects = new ArrayList<String>();
        List<String> dirList = dir.getDirectoryList();
        Iterator<Object> iterator = dir.getObjectMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, T> entry;
            Map.Entry<String, T> item = entry = iterator.next();
            objects.add(dir.getDirectoryPath() + "/" + item.getKey());
        }
        for (String list : dirList) {
            Directory subDir = dir.getDir(list);
            List<String> dir_o = this.getCompositeObjectList(subDir);
            objects.addAll(dir_o);
        }
        return objects;
    }

    public boolean exists(String name) {
        Directory saveDir = this.currentDirectory;
        boolean status = this.cd(name);
        this.currentDirectory = saveDir;
        return status;
    }

    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        List<String> objects = this.getCompositeObjectList(this);
        System.out.println("Get Tree Nodes : Size = " + objects.size());
        DefaultMutableTreeNode node = this.getNodes(root, objects, 1);
        return node;
    }

    public DefaultMutableTreeNode getNodes(DefaultMutableTreeNode node, List<String> objects, int depth) {
        String name = node.toString();
        System.out.println(" level = " + depth);
        Set<String> keys = this.getChildrenList(name, objects, depth);
        for (String key : keys) {
            System.out.println("---> adding : " + key);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(key);
            node.add(child);
            this.getNodes(child, objects, depth + 1);
        }
        return node;
    }

    public Set<String> getChildrenList(String parent, List<String> list, int depth) {
        HashSet<String> children = new HashSet<String>();
        if (depth < 1) {
            return children;
        }
        for (String object : list) {
            String[] tokens = object.split("/");
            if (depth == 1) {
                if (tokens.length <= 0) continue;
                children.add(tokens[1]);
                continue;
            }
            if (tokens.length <= depth || tokens[depth - 1].compareTo(parent) != 0) continue;
            children.add(tokens[depth]);
        }
        return children;
    }

    public static void main(String[] args) {
        Directory dir = new Directory();
        dir.mkdir("/a/b/c/d/e/f");
        dir.cd("/a/b/c/d/e");
        dir.pwd();
    }
}

