/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.base;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.data.GraphErrors;
import org.jlab.groot.ui.JComboCheckBox;

public class DatasetAttributes
implements Cloneable {
    private int lineColor = 1;
    private int lineWidth = 3;
    private int lineStyle = 1;
    private int markerColor = 1;
    private int markerSize = 1;
    private int markerStyle = 0;
    private int fillColor = 0;
    private int fillStyle = 1;
    private int datasetType = 0;
    public static final int HISTOGRAM = 0;
    public static final int HISTOGRAM2D = 1;
    public static final int GRAPHERRORS = 2;
    public static final int FUNCTION = 3;
    private boolean drawAxis = false;
    public String optStat = "0";
    private String stringTitleX = "";
    private String stringTitleY = "";
    private String stringTitle = "";
    private String drawOptions = "";

    public DatasetAttributes(int datasetType) {
        this.datasetType = datasetType;
        this.init(datasetType);
    }

    public void setAttributes(DatasetAttributes attr) {
        this.datasetType = attr.getDatasetType();
        this.lineColor = attr.getLineColor();
        this.lineWidth = attr.getLineWidth();
        this.lineStyle = attr.getLineStyle();
        this.markerColor = attr.getMarkerColor();
        this.markerStyle = attr.getMarkerStyle();
        this.markerSize = attr.getMarkerSize();
        this.fillColor = attr.getFillColor();
        this.fillStyle = attr.getFillStyle();
        this.optStat = attr.getOptStat();
        this.drawAxis = attr.isDrawAxis();
        this.stringTitleX = attr.getTitleX();
        this.stringTitleY = attr.getTitleY();
        this.stringTitle = attr.getTitle();
    }

    private void init(int datasetType2) {
        if (datasetType2 == 0) {
            this.setLineWidth(1);
            this.setLineColor(1);
            this.setLineStyle(1);
            this.setFillColor(-1);
            this.setFillStyle(0);
        }
        if (datasetType2 == 1) {
            this.setLineWidth(1);
            this.setLineColor(1);
            this.setLineStyle(1);
            this.setFillColor(-1);
            this.setFillStyle(0);
        }
        if (datasetType2 == 3) {
            this.setLineWidth(1);
            this.setLineColor(1);
            this.setLineStyle(1);
            this.setFillColor(-1);
            this.setFillStyle(0);
        }
        if (datasetType2 == 2) {
            this.setLineColor(1);
            this.setLineWidth(2);
            this.setLineStyle(1);
            this.setMarkerColor(1);
            this.setMarkerSize(6);
            this.setMarkerStyle(0);
        }
    }

    public DatasetAttributes() {
    }

    public void setTitleX(String title) {
        this.stringTitleX = title;
    }

    public void setTitleY(String title) {
        this.stringTitleY = title;
    }

    public void setTitle(String title) {
        this.stringTitle = title;
    }

    public void setLineColor(int color) {
        this.lineColor = color;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public void setLineStyle(int style) {
        this.lineStyle = style;
    }

    public void setMarkerColor(int color) {
        this.markerColor = color;
    }

    public void setMarkerSize(int size) {
        this.markerSize = size;
    }

    public void setMarkerStyle(int style) {
        this.markerStyle = style;
    }

    public void setFillColor(int color) {
        this.fillColor = color;
    }

    public void setFillStyle(int style) {
        this.fillStyle = style;
    }

    public boolean isDrawAxis() {
        return this.drawAxis;
    }

    public void setDrawAxis(boolean drawAxis) {
        this.drawAxis = drawAxis;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getMarkerColor() {
        return this.markerColor;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public int getMarkerStyle() {
        return this.markerStyle;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public String getTitle() {
        return this.stringTitle;
    }

    public String getTitleX() {
        return this.stringTitleX;
    }

    public String getTitleY() {
        return this.stringTitleY;
    }

    public String getDrawOptions() {
        return this.drawOptions;
    }

    public void setDrawOptions(String drawOptions) {
        this.drawOptions = drawOptions;
    }

    public DatasetAttributes clone() throws CloneNotSupportedException {
        return (DatasetAttributes)super.clone();
    }

    public JPanel getPane() {
        DatasetAttributesPane pane = new DatasetAttributesPane(this);
        return pane;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        DatasetAttributes attr = new DatasetAttributes();
        frame.add(attr.getPane());
        frame.pack();
        frame.setVisible(true);
    }

    public int getDatasetType() {
        return this.datasetType;
    }

    private static int returnIndex(int[] array, int number) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return 0;
    }

    public void setDatasetType(int datasetType) {
        this.datasetType = datasetType;
    }

    public void setOptStat(String optStat) {
        this.optStat = optStat;
    }

    public String getOptStat() {
        return this.optStat;
    }

    public void setDefault() {
        if (this.datasetType == 3) {
            this.setAttributes(GStyle.getFunctionAttributes());
        } else if (this.datasetType == 0) {
            this.setAttributes(GStyle.getH1FAttributes());
        } else if (this.datasetType == 1) {
            this.setAttributes(GStyle.getH2FAttributes());
        } else if (this.datasetType == 2) {
            this.setAttributes(GStyle.getGraphErrorsAttributes());
        }
    }

    public static class DatasetAttributesPane
    extends JPanel
    implements ActionListener,
    KeyListener {
        public JButton buttonDefault;
        public JButton buttonSetDefault;
        public JButton buttonRemove;
        private static final long serialVersionUID = -8413019611235714087L;
        private DatasetAttributes attr = null;
        private String[] colorChoices = new String[50];
        private int[] colorChoicesInts = new int[50];
        private String[] sizeChoices = new String[10];
        private int[] sizeChoicesInts = new int[10];
        private String[] markerChoices = new String[4];
        private int[] markerChoicesInts = new int[4];
        private String[] lineStyleChoices = new String[5];
        private int[] lineStyleChoicesInts = new int[5];
        private JComboBox boxLineColor = null;
        private JComboBox boxLineWidth = null;
        private JComboBox boxLineStyle = null;
        private JComboBox boxMarkerColor = null;
        private JComboBox boxMarkerSize = null;
        private JComboBox boxMarkerStyle = null;
        private JComboBox boxFillColor = null;
        private JTextField optStatTextField = null;
        private JTextField drawOptionsTextField = null;
        private JComboCheckBox optStatCheckBox = null;
        private List<ActionListener> listeners = new ArrayList<ActionListener>();

        public DatasetAttributesPane(DatasetAttributes da) {
            this.attr = da;
            this.setBorder(BorderFactory.createTitledBorder("Dataset Attributes"));
            this.setLayout((LayoutManager)new MigLayout());
            this.initUI();
        }

        private void initUI() {
            for (int i = 0; i < this.colorChoices.length; ++i) {
                this.colorChoices[i] = "" + i;
                this.colorChoicesInts[i] = i;
                if (i < this.sizeChoices.length) {
                    this.sizeChoices[i] = "" + i;
                    this.sizeChoicesInts[i] = i;
                }
                if (i < this.markerChoices.length) {
                    this.markerChoices[i] = this.attr.getDatasetType() == 2 ? GraphErrors.MARKERNAME[i] : "" + i;
                    this.markerChoicesInts[i] = i;
                }
                if (i >= this.lineStyleChoices.length) continue;
                this.lineStyleChoices[i] = "" + (i + 1);
                this.lineStyleChoicesInts[i] = i + 1;
            }
            JLabel labelLineColor = new JLabel("Line Color:");
            JLabel labelLineWidth = new JLabel("Line Width:");
            JLabel labelLineStyle = new JLabel("Line Style:");
            this.boxLineColor = new JComboBox<String>(this.colorChoices);
            this.boxLineWidth = new JComboBox<String>(this.sizeChoices);
            this.boxLineStyle = new JComboBox<String>(this.lineStyleChoices);
            this.boxLineColor.setSelectedIndex(DatasetAttributes.returnIndex(this.colorChoicesInts, this.attr.getLineColor()));
            this.boxLineWidth.setSelectedIndex(DatasetAttributes.returnIndex(this.sizeChoicesInts, this.attr.getLineWidth()));
            this.boxLineStyle.setSelectedIndex(DatasetAttributes.returnIndex(this.lineStyleChoicesInts, this.attr.getLineStyle()));
            this.boxLineColor.addActionListener(this);
            this.boxLineWidth.addActionListener(this);
            this.boxLineStyle.addActionListener(this);
            this.boxMarkerColor = new JComboBox<String>(this.colorChoices);
            this.boxMarkerSize = new JComboBox<String>(this.sizeChoices);
            this.boxMarkerStyle = new JComboBox<String>(this.markerChoices);
            this.boxMarkerColor.setSelectedIndex(DatasetAttributes.returnIndex(this.colorChoicesInts, this.attr.getMarkerColor()));
            this.boxMarkerSize.setSelectedIndex(DatasetAttributes.returnIndex(this.sizeChoicesInts, this.attr.getMarkerSize()));
            this.boxMarkerStyle.setSelectedIndex(DatasetAttributes.returnIndex(this.markerChoicesInts, this.attr.getMarkerStyle()));
            this.boxMarkerColor.addActionListener(this);
            this.boxMarkerSize.addActionListener(this);
            this.boxMarkerStyle.addActionListener(this);
            this.boxFillColor = new JComboBox<String>(this.colorChoices);
            this.boxFillColor.addActionListener(this);
            this.boxFillColor.setSelectedIndex(DatasetAttributes.returnIndex(this.colorChoicesInts, this.attr.getFillColor()));
            JLabel optStatLabel = new JLabel("StatBox Options:");
            this.optStatTextField = new JTextField(10);
            this.optStatTextField.setText("" + this.attr.getOptStat());
            this.drawOptionsTextField = new JTextField(10);
            this.drawOptionsTextField.setText("" + this.attr.getDrawOptions());
            if (this.attr.getDatasetType() == 0 || this.attr.getDatasetType() == 3) {
                this.add(labelLineColor);
                this.add((Component)this.boxLineColor, "wrap, pushx, growx");
                this.add(labelLineWidth);
                this.add((Component)this.boxLineWidth, "wrap, growx");
                this.add(labelLineStyle);
                this.add((Component)this.boxLineStyle, "wrap, growx");
            }
            if (this.attr.getDatasetType() == 2) {
                this.add((Component)new JSeparator(0), "skip, wrap, pushx, growx");
                this.add(new JLabel("Marker Color:"));
                this.add((Component)this.boxMarkerColor, "wrap, growx");
                this.add(new JLabel("Marker Size:"));
                this.add((Component)this.boxMarkerSize, "wrap, growx");
                this.add(new JLabel("Marker Style:"));
                this.add((Component)this.boxMarkerStyle, "wrap, growx");
                this.add(labelLineColor);
                this.add((Component)this.boxLineColor, "wrap, pushx, growx");
                this.add(labelLineWidth);
                this.add((Component)this.boxLineWidth, "wrap, growx");
            }
            if (this.attr.getDatasetType() == 0) {
                this.add((Component)new JSeparator(0), "skip, wrap, pushx, growx");
                this.add(new JLabel("Fill Color:"));
                this.add((Component)this.boxFillColor, "wrap, pushx, growx");
            }
            this.add(optStatLabel);
            this.add((Component)this.optStatTextField, "wrap, pushx, growx");
            this.add(new JLabel("Draw Options:"));
            this.add((Component)this.drawOptionsTextField, "wrap, pushx, growx");
            this.optStatTextField.addActionListener(this);
            this.drawOptionsTextField.addActionListener(this);
            this.optStatTextField.addKeyListener(this);
            this.drawOptionsTextField.addKeyListener(this);
            this.buttonDefault = new JButton("Default");
            this.buttonRemove = new JButton("Delete");
            this.buttonSetDefault = new JButton("Set Default");
            this.buttonSetDefault.addActionListener(e -> {
                if (this.attr.datasetType == 3) {
                    GStyle.getFunctionAttributes().setAttributes(this.attr);
                }
                if (this.attr.datasetType == 0) {
                    GStyle.getH1FAttributes().setAttributes(this.attr);
                }
                if (this.attr.datasetType == 1) {
                    GStyle.getH2FAttributes().setAttributes(this.attr);
                }
                if (this.attr.datasetType == 2) {
                    GStyle.getGraphErrorsAttributes().setAttributes(this.attr);
                }
            });
            this.add((Component)this.buttonSetDefault, "skip,pushx,split3");
            this.add((Component)this.buttonDefault, "pushx");
            this.add((Component)this.buttonRemove, "pushx");
        }

        public void addAttributeListener(ActionListener al) {
            this.listeners.add(al);
        }

        public void updateCanvas() {
            for (ActionListener actionListener : this.listeners) {
                actionListener.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.boxLineColor) {
                this.attr.setLineColor(Integer.parseInt(this.colorChoices[this.boxLineColor.getSelectedIndex()]));
            } else if (e.getSource() == this.boxLineWidth) {
                this.attr.setLineWidth(Integer.parseInt(this.sizeChoices[this.boxLineWidth.getSelectedIndex()]));
            } else if (e.getSource() == this.boxLineStyle) {
                this.attr.setLineStyle(Integer.parseInt(this.lineStyleChoices[this.boxLineStyle.getSelectedIndex()]));
            } else if (e.getSource() == this.boxMarkerColor) {
                this.attr.setMarkerColor(Integer.parseInt(this.colorChoices[this.boxMarkerColor.getSelectedIndex()]));
            } else if (e.getSource() == this.boxMarkerSize) {
                this.attr.setMarkerSize(Integer.parseInt(this.sizeChoices[this.boxMarkerSize.getSelectedIndex()]));
            } else if (e.getSource() == this.boxMarkerStyle) {
                this.attr.setMarkerStyle(this.boxMarkerStyle.getSelectedIndex());
            } else if (e.getSource() == this.boxFillColor) {
                this.attr.setFillColor(Integer.parseInt(this.colorChoices[this.boxFillColor.getSelectedIndex()]));
            } else if (e.getSource() == this.optStatTextField) {
                this.attr.setOptStat(this.optStatTextField.getText());
            } else if (e.getSource() == this.drawOptionsTextField) {
                this.attr.setDrawOptions(this.drawOptionsTextField.getText());
            }
            this.updateCanvas();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == this.optStatTextField) {
                this.attr.setOptStat(this.optStatTextField.getText());
                this.updateCanvas();
            } else if (e.getSource() == this.drawOptionsTextField) {
                this.attr.setDrawOptions(this.drawOptionsTextField.getText());
                this.updateCanvas();
            }
        }
    }
}

