/*
 * Decompiled with CFR 0.152.
 */
package com.aptech.gaussApi5_0;

import com.aptech.gaussApi5_0.Gauss;
import java.nio.ByteBuffer;

public class GaussStringArray {
    private byte[] gaussNativeBytes = null;
    private int[] offsets = null;
    private int[] lengths = null;
    private ByteBuffer byteBuffer = null;
    private int rows = 0;
    private int cols = 0;

    public GaussStringArray(String[][] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("String[][]");
        }
        this.rows = stringArray.length;
        if (this.rows == 0) {
            this.cols = 0;
        } else {
            if (stringArray[0] == null) {
                throw new NullPointerException("String[0][]");
            }
            this.cols = stringArray[0].length;
            for (int i = 0; i < this.rows; ++i) {
                if (stringArray[i] == null) {
                    throw new NullPointerException("String Array[" + i + "][]");
                }
                if (stringArray[i].length == this.cols) continue;
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            if ((long)this.rows * (long)this.cols > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Rows x Cols (" + (long)this.rows * (long)this.cols + " exceeds maximum allowed by Java (" + Integer.MAX_VALUE + ")");
            }
        }
        if (this.cols == 0) {
            this.rows = 0;
        }
        if (this.rows == 0) {
            throw new IllegalArgumentException("String array cannot be completely empty as you cannot set it in the GAUSS workspace.  Use an empty GaussMatrix instead in any GAUSS statements where you want to use an empty GaussStringArray.");
        }
        this.translateJavaToGauss(stringArray);
    }

    GaussStringArray() {
    }

    private GaussStringArray(int n, int n2, int[] nArray, int[] nArray2, byte[] byArray) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of Rows, " + n + " is negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Number of Columns, " + n2 + " is negative");
        }
        if (byArray == null) {
            throw new NullPointerException("nativeBytes array");
        }
        if (nArray == null) {
            throw new NullPointerException("offsets array");
        }
        if (nArray2 == null) {
            throw new NullPointerException("lengths array");
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Number of offsets (" + this.offsets.length + ") does not" + " equal number of lengths (" + this.lengths.length + ")");
        }
        if (nArray.length != n * n2) {
            throw new IllegalArgumentException("Number of offsets (" + this.offsets.length + ") does not" + " equal rows x cols (" + n * n2 + ")");
        }
        this.rows = n;
        this.cols = n2;
        this.offsets = nArray;
        this.lengths = nArray2;
        this.gaussNativeBytes = byArray;
        this.byteBuffer = ByteBuffer.wrap(byArray);
    }

    public void setString(int n, int n2, String string) {
        if (n >= this.rows || n2 >= this.cols) {
            throw new ArrayIndexOutOfBoundsException("[" + n + "," + n2 + "] exceeds max index for " + this.rows + "x" + this.cols + " matrix.");
        }
        if (string == null) {
            throw new NullPointerException(" Tried to set GaussStringArray[" + n + "," + n2 + "] to null");
        }
        String[][] stringArray = this.getStrings();
        stringArray[n][n2] = string;
        this.translateJavaToGauss(stringArray);
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public String[][] getStrings() {
        String[][] stringArray = new String[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                stringArray[i][j] = this.getString(i, j);
            }
        }
        return stringArray;
    }

    public String getString(int n, int n2) {
        String string;
        if (n >= this.rows || n2 >= this.cols) {
            throw new ArrayIndexOutOfBoundsException("[" + n + "," + n2 + "] exceeds max index for " + this.rows + "x" + this.cols + " matrix.");
        }
        int n3 = this.offsets[n * this.cols + n2];
        int n4 = this.lengths[n * this.cols + n2];
        if (n4 > 1) {
            byte[] byArray = new byte[n4 - 1];
            this.byteBuffer.position(n3);
            this.byteBuffer.get(byArray, 0, n4 - 1);
            string = new String(byArray);
        } else {
            string = "";
        }
        return string;
    }

    public String toString() {
        String string = Gauss.nl;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                string = string + this.getString(i, j) + " ";
            }
            string = string + Gauss.nl;
        }
        return string;
    }

    private byte[] getGaussNativeBytes() {
        return this.gaussNativeBytes;
    }

    private int[] getLengths() {
        return this.lengths;
    }

    private int[] getOffsets() {
        return this.offsets;
    }

    private void translateJavaToGauss(String[][] stringArray) {
        int n;
        int n2;
        if (stringArray == null) {
            throw new IllegalStateException("String[][]");
        }
        int n3 = this.rows * this.cols;
        byte[][] byArrayArray = new byte[this.rows * this.cols][];
        this.offsets = new int[this.rows * this.cols];
        this.lengths = new int[this.rows * this.cols];
        StringBuffer stringBuffer = new StringBuffer(100);
        long l = 0L;
        int n4 = 0;
        for (n2 = 0; n2 < this.rows; ++n2) {
            for (n = 0; n < this.cols; ++n) {
                stringBuffer.delete(0, stringBuffer.length());
                if (stringArray[n2][n] == null) {
                    throw new NullPointerException(" String[" + n2 + "][" + n + "]");
                }
                stringBuffer.append(stringArray[n2][n]);
                stringBuffer.append(Gauss.STRING_TERMINATION);
                byArrayArray[n2 * this.cols + n] = stringBuffer.toString().getBytes();
                n4 = byArrayArray[n2 * this.cols + n].length;
                this.offsets[n2 * this.cols + n] = (int)l;
                this.lengths[n2 * this.cols + n] = n4;
                if ((l += (long)n4) <= Integer.MAX_VALUE) continue;
                throw new IllegalArgumentException("Total bytes exceeds 2147483647");
            }
        }
        this.gaussNativeBytes = new byte[(int)l];
        this.byteBuffer = ByteBuffer.wrap(this.gaussNativeBytes);
        for (n2 = 0; n2 < this.rows; ++n2) {
            for (n = 0; n < this.cols; ++n) {
                this.byteBuffer.put(byArrayArray[n2 * this.cols + n], 0, this.lengths[n2 * this.cols + n]);
            }
        }
    }
}

