/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.construction.Construction;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.MoveableObject;
import carmetal.objects.TextObject;
import carmetal.objects.UserFunctionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class ZoomerTool
extends ObjectConstructor {
    boolean Dragging = false;
    boolean Zoom = false;
    double X;
    double Y;
    double W;
    double X0;
    double Y0;
    ObjectConstructor OC;

    public static void initNonDraggableObjects(Construction c2) {
        Enumeration en = c2.elements();
        while (en.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)en.nextElement();
            if (!(o instanceof TextObject) && !(o instanceof ExpressionObject) && !(o instanceof UserFunctionObject)) continue;
            MoveableObject mo = (MoveableObject)((Object)o);
            mo.startDrag(0.0, 0.0);
        }
    }

    public static void shiftNonDraggableObjectsBy(Construction c2, double dx, double dy) {
        Enumeration en = c2.elements();
        while (en.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)en.nextElement();
            if (!(o instanceof TextObject) && !(o instanceof ExpressionObject) && !(o instanceof UserFunctionObject)) continue;
            MoveableObject mo = (MoveableObject)((Object)o);
            mo.dragTo(dx, dy);
        }
    }

    public static void zoomNonDraggableObjectsBy(Construction c2, double f2) {
        Enumeration en = c2.elements();
        while (en.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)en.nextElement();
            if (!(o instanceof TextObject) && !(o instanceof ExpressionObject) && !(o instanceof UserFunctionObject)) continue;
            MoveableObject mo = (MoveableObject)((Object)o);
            mo.move(c2.getX() + (mo.getOldX() - c2.getX()) * f2, c2.getY() + (mo.getOldY() - c2.getY()) * f2);
        }
    }

    public ZoomerTool() {
    }

    public ZoomerTool(ObjectConstructor oc, MouseEvent e2, ZirkelCanvas zc) {
        this.OC = oc;
        this.X0 = zc.x(e2.getX());
        this.Y0 = zc.y(e2.getY());
        Construction c2 = zc.getConstruction();
        this.X = c2.getX();
        this.Y = c2.getY();
        this.W = c2.getW();
        this.Zoom = false;
        zc.setCursor(Cursor.getPredefinedCursor(13));
        this.Dragging = true;
        ZoomerTool.initNonDraggableObjects(c2);
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        this.X0 = zc.x(e2.getX());
        this.Y0 = zc.y(e2.getY());
        Construction c2 = zc.getConstruction();
        this.X = c2.getX();
        this.Y = c2.getY();
        this.W = c2.getW();
        boolean bl = this.Zoom = Math.abs(this.X - this.X0) > this.W / 4.0 || Math.abs(this.Y - this.Y0) > this.W / 4.0;
        if (!this.Zoom) {
            zc.setCursor(Cursor.getPredefinedCursor(13));
        }
        this.Dragging = true;
        this.OC = null;
        ZoomerTool.initNonDraggableObjects(c2);
    }

    @Override
    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        Construction c2 = zc.getConstruction();
        c2.setXYW(this.X, this.Y, this.W);
        zc.recompute();
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        if (this.Zoom) {
            double f2 = Math.sqrt((this.X0 - this.X) * (this.X0 - this.X) + (this.Y0 - this.Y) * (this.Y0 - this.Y)) / Math.sqrt((x - this.X) * (x - this.X) + (y - this.Y) * (y - this.Y));
            c2.setXYW(this.X, this.Y, f2 * this.W);
            ZoomerTool.zoomNonDraggableObjectsBy(c2, f2);
        } else {
            c2.setXYW(this.X - (x - this.X0), this.Y - (y - this.Y0), this.W);
            ZoomerTool.shiftNonDraggableObjectsBy(c2, this.X0 - x, this.Y0 - y);
        }
        zc.recompute();
        zc.validate();
        zc.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        this.Zoom = false;
        this.Dragging = false;
        zc.setCursor(Cursor.getDefaultCursor());
        zc.recompute();
        zc.validate();
        zc.repaint();
        if (this.OC != null) {
            zc.setTool(this.OC);
        }
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.zoom"));
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        zc.clearSelected();
        zc.setCursor(new Cursor(0));
        this.Dragging = false;
        this.Zoom = false;
    }

    @Override
    public void invalidate(ZirkelCanvas zc) {
        zc.setCursor(new Cursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean flag) {
        this.X0 = zc.x(e2.getX());
        this.Y0 = zc.y(e2.getY());
        Construction c2 = zc.getConstruction();
        this.X = c2.getX();
        this.Y = c2.getY();
        this.W = c2.getW();
        boolean bl = this.Zoom = Math.abs(this.X - this.X0) > this.W / 4.0 || Math.abs(this.Y - this.Y0) > this.W / 4.0;
        if (!this.Zoom) {
            zc.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            zc.setCursor(new Cursor(0));
        }
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

