/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.constructors.ObjectConstructor;
import carmetal.eric.macros.CreateMacroPanel;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class SetTargetsTool
extends ObjectConstructor {
    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        zc.y(e2.getY());
        ConstructionObject o = zc.selectConstructableObject(e2.getX(), e2.getY());
        if (o == null || !o.isFlag()) {
            return;
        }
        if (o.isTarget()) {
            o.setTarget(false);
            o.setSelected(false);
            zc.getConstruction().removeTarget(o);
        } else {
            o.setTarget(true);
            o.setSelected(true);
            zc.getConstruction().addTarget(o);
        }
        zc.repaint();
        CreateMacroPanel.setTargetsComments();
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateConstructableObjects(e2.getX(), e2.getY());
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.clearSelected();
        zc.getConstruction().clearTargets();
        zc.getConstruction().determineConstructables();
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.targets", "Macro Targets: Select the Targets!"));
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

