/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.eric.macros.CreateMacroPanel;
import carmetal.objects.AngleObject;
import carmetal.objects.AreaObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.UserFunctionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class SetParameterTool
extends ObjectConstructor
implements Selector {
    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        zc.y(e2.getY());
        ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null) {
            return;
        }
        if (o.isMainParameter()) {
            o.setMainParameter(false);
            o.setSelected(false);
            zc.getConstruction().removeParameter(o);
            zc.repaint();
        } else {
            o.setMainParameter(true);
            o.setSelected(true);
            zc.getConstruction().addParameter(o);
            zc.repaint();
            if (e2.isShiftDown()) {
                o.setSpecialParameter(true);
            }
        }
        CreateMacroPanel.setParametersComments();
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return o instanceof PointObject || o instanceof PrimitiveLineObject || o instanceof PrimitiveCircleObject || o instanceof ExpressionObject || o instanceof AngleObject || o instanceof AreaObject || o instanceof FunctionObject || o instanceof UserFunctionObject;
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.clearSelected();
        zc.getConstruction().clearParameters();
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.name("message.parameters", "Macro Parameters: Select the Parameters!"));
    }
}

