/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.constructors.ObjectConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.objects.IntersectionObject;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class SetAwayTool
extends ObjectConstructor {
    ObjectConstructor OC;
    IntersectionObject P;
    boolean Away;

    public SetAwayTool(ZirkelCanvas zc, IntersectionObject p, boolean away, ObjectConstructor oc) {
        this.P = p;
        this.OC = oc;
        this.P.setSelected(true);
        this.Away = away;
        zc.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        PointObject o = zc.selectPoint(e2.getX(), e2.getY());
        if (o == null) {
            return;
        }
        if (zc.getConstruction().dependsOn(o, this.P)) {
            zc.warning(ConstructionObject.text1(Global.name("error.depends"), this.P.getText()));
            return;
        }
        this.P.setAway(o.getName(), this.Away);
        this.P.setUseAlpha(e2.isShiftDown());
        zc.validate();
        this.reset(zc);
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.Away) {
            zc.showStatus(Global.name("message.setaway.away"));
        } else {
            zc.showStatus(Global.name("message.setaway.close"));
        }
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

