/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.eric.bar.JPropertiesBar;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.structures.MagnetObj;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class MagnetTool
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    PointObject P;

    public MagnetTool(ZirkelCanvas zc, PointObject p, ObjectConstructor oc) {
        this.P = p;
        this.OC = oc;
        this.P.setStrongSelected(true);
        Enumeration e2 = this.P.getMagnetObjects().elements();
        while (e2.hasMoreElements()) {
            MagnetObj mo = (MagnetObj)e2.nextElement();
            mo.setSelected(true);
        }
        zc.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null) {
            this.reset(zc);
            return;
        }
        if (o == this.P) {
            return;
        }
        if (o.selected()) {
            this.P.removeMagnetObject(o.getName());
            o.setSelected(false);
            JPropertiesBar.RefreshBar();
        } else {
            this.P.addMagnetObject(o.getName());
            this.P.selectMagnetObjects(true);
            JPropertiesBar.RefreshBar();
        }
        zc.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return true;
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Global.Loc("props.magnetmessage"));
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        JPropertiesBar.RefreshBar();
        zc.repaint();
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

