/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.constructors.ObjectConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class LabelMover
extends ObjectConstructor {
    ConstructionObject P;
    ObjectConstructor OC;
    int X;
    int Y;
    double OX;
    double OY;

    public LabelMover(ObjectConstructor oc, ZirkelCanvas zc, int x, int y, ConstructionObject p, boolean shift) {
        this.OC = oc;
        this.P = p;
        if (shift || !this.P.canKeepClose()) {
            this.X = x;
            this.Y = y;
            this.P.setKeepClose(false);
            this.OX = this.P.xcOffset();
            this.OY = this.P.ycOffset();
        } else {
            this.P.setKeepClose(zc.x(x), zc.y(y));
        }
        if (this.P != null) {
            this.P.setLabelSelected(true);
            zc.repaint();
            this.showStatus(zc);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
    }

    @Override
    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P == null) {
            return;
        }
        if (this.P.isKeepClose()) {
            this.P.setKeepClose(zc.x(e2.getX()), zc.y(e2.getY()));
        } else {
            this.P.setcOffset(this.OX + zc.dx(e2.getX() - this.X), this.OY + zc.dy(this.Y - e2.getY()));
        }
        zc.validate();
        zc.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P == null) {
            return;
        }
        this.P.setLabelSelected(false);
        zc.repaint();
        this.P = null;
        this.showStatus(zc);
        zc.setTool(this.OC);
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        zc.clearSelected();
        this.P.setLabelSelected(false);
        zc.repaint();
    }

    public void resetPoint() {
        if (this.P != null) {
            this.P.setKeepClose(false);
            this.P.setcOffset(0.0, 0.0);
        }
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.P == null) {
            zc.showStatus(Global.name("message.label.select", "Move Label: Select a label"));
        } else {
            zc.showStatus(Global.name("message.label.move", "Move Label: Move the label"));
        }
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }
}

