/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.macro;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.construction.DepList;
import carmetal.construction.Selector;
import carmetal.constructors.ObjectConstructor;
import carmetal.eric.JMacroPrompt;
import carmetal.objects.AngleObject;
import carmetal.objects.AreaObject;
import carmetal.objects.CircleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.FixedAngleObject;
import carmetal.objects.FixedCircleObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.JLocusTrackObject;
import carmetal.objects.LineObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.QuadricObject;
import carmetal.objects.RayObject;
import carmetal.objects.SegmentObject;
import carmetal.objects.TwoPointLineObject;
import carmetal.objects.UserFunctionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.macro.Macro;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MacroRunner
extends ObjectConstructor
implements Selector {
    String[] S;
    int Param;
    Macro M;
    ArrayList OCs = new ArrayList();
    ArrayList PROMPTs = new ArrayList();
    ZirkelCanvas ZC;
    ConstructionObject[] Params;
    boolean[] NewPoint;
    boolean[] Fixed;
    double LastX = 0.0;
    double LastY = 0.0;
    static ConstructionObject previewPoint = null;
    static boolean keepLine = true;
    static boolean keepCircle = true;
    static DepList DL = new DepList();

    public void setMacro(Macro m, ZirkelCanvas zc) {
        this.S = m.getPrompts();
        this.Param = 0;
        this.M = m;
        this.Params = new ConstructionObject[this.S.length];
        this.Fixed = new boolean[this.S.length];
        this.NewPoint = new boolean[this.S.length];
        for (int i = 0; i < this.S.length; ++i) {
            this.Fixed[i] = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        ConstructionObject o;
        if (!zc.Visual) {
            return;
        }
        if (!e2.isAltDown() && this.isMultipleFinalAccepted() && (o = zc.selectMultipleFinal(e2.getX(), e2.getY(), false)) != null) {
            this.LaunchMultipleFinalMacro(e2, zc);
            this.reset(zc);
            return;
        }
        o = null;
        ConstructionObject[] p = this.M.getParams();
        o = p[this.Param] instanceof PointObject ? zc.selectCreatePoint(e2.getX(), e2.getY(), e2.isAltDown()) : zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null) {
            return;
        }
        int ip = this.Param;
        if (!this.setNextParameter(o, zc, e2.isShiftDown())) {
            return;
        }
        boolean bl = this.NewPoint[ip] = o instanceof PointObject && zc.isNewPoint();
        if (this.Param >= this.S.length) {
            this.doMacro(zc);
            this.reset(zc);
        } else {
            this.getFixed(zc);
        }
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        ConstructionObject[] p = this.M.getParams();
        if (p[this.Param] instanceof PointObject) {
            return o instanceof PointObject;
        }
        if (p[this.Param] instanceof FixedAngleObject) {
            return o instanceof FixedAngleObject;
        }
        if (p[this.Param] instanceof SegmentObject) {
            return o instanceof SegmentObject;
        }
        if (p[this.Param] instanceof RayObject) {
            return o instanceof RayObject;
        }
        if (p[this.Param] instanceof TwoPointLineObject) {
            return o instanceof TwoPointLineObject;
        }
        if (p[this.Param] instanceof PrimitiveLineObject) {
            return o instanceof PrimitiveLineObject;
        }
        if (p[this.Param] instanceof PrimitiveCircleObject) {
            return o instanceof PrimitiveCircleObject;
        }
        if (p[this.Param] instanceof FunctionObject) {
            return o instanceof FunctionObject;
        }
        if (p[this.Param] instanceof UserFunctionObject) {
            return o instanceof UserFunctionObject;
        }
        if (p[this.Param] instanceof AngleObject) {
            return o instanceof AngleObject;
        }
        if (p[this.Param] instanceof QuadricObject) {
            return o instanceof QuadricObject;
        }
        if (p[this.Param] instanceof ExpressionObject) {
            return o instanceof ExpressionObject || o instanceof AngleObject || o instanceof FixedAngleObject || o instanceof AreaObject;
        }
        if (p[this.Param] instanceof AreaObject) {
            return o instanceof AreaObject;
        }
        return false;
    }

    private void checkIfKeepLine(ZirkelCanvas zc) {
        Construction c2 = zc.getConstruction();
        PointObject P1org = new PointObject(c2, -3.0, 4.0);
        PointObject P2org = new PointObject(c2, -1.0, 1.0);
        PointObject P3org = new PointObject(c2, 1.0, -2.0);
        P1org.setSuperHidden(true);
        P2org.setSuperHidden(true);
        P3org.setSuperHidden(true);
        this.Params[this.Params.length - 1] = P1org;
        c2.add(P1org);
        this.runMacroPreview(zc, false);
        PointObject p1 = (PointObject)previewPoint;
        this.Params[this.Params.length - 1] = P2org;
        c2.add(P2org);
        this.runMacroPreview(zc, false);
        PointObject p2 = (PointObject)previewPoint;
        this.Params[this.Params.length - 1] = P3org;
        c2.add(P3org);
        this.runMacroPreview(zc, false);
        PointObject p3 = (PointObject)previewPoint;
        double x1 = p2.getX() - p1.getX();
        double y1 = p2.getY() - p1.getY();
        double x2 = p3.getX() - p1.getX();
        double y2 = p3.getY() - p1.getY();
        keepLine = Math.abs(x1 * y2 - x2 * y1) < 1.0E-11;
    }

    private void checkIfKeepCircle(ZirkelCanvas zc) {
        Construction c2 = zc.getConstruction();
        PointObject P0org = new PointObject(c2, 1.0, 1.0);
        PointObject P1org = new PointObject(c2, 2.0, -1.0);
        PointObject P2org = new PointObject(c2, 3.0, 2.0);
        PointObject P3org = new PointObject(c2, 0.0, 3.0);
        PointObject P4org = new PointObject(c2, -1.0, 2.0);
        P0org.setSuperHidden(true);
        P1org.setSuperHidden(true);
        P2org.setSuperHidden(true);
        P3org.setSuperHidden(true);
        P4org.setSuperHidden(true);
        this.Params[this.Params.length - 1] = P0org;
        c2.add(P0org);
        this.runMacroPreview(zc, false);
        PointObject p0 = (PointObject)previewPoint;
        this.Params[this.Params.length - 1] = P1org;
        c2.add(P1org);
        this.runMacroPreview(zc, false);
        PointObject p1 = (PointObject)previewPoint;
        this.Params[this.Params.length - 1] = P2org;
        c2.add(P2org);
        this.runMacroPreview(zc, false);
        PointObject p2 = (PointObject)previewPoint;
        this.Params[this.Params.length - 1] = P3org;
        c2.add(P3org);
        this.runMacroPreview(zc, false);
        PointObject p3 = (PointObject)previewPoint;
        this.Params[this.Params.length - 1] = P4org;
        c2.add(P4org);
        this.runMacroPreview(zc, false);
        PointObject p4 = (PointObject)previewPoint;
        double x1 = Math.sqrt((p1.getX() - p0.getX()) * (p1.getX() - p0.getX()) + (p1.getY() - p0.getY()) * (p1.getY() - p0.getY()));
        double x2 = Math.sqrt((p2.getX() - p0.getX()) * (p2.getX() - p0.getX()) + (p2.getY() - p0.getY()) * (p2.getY() - p0.getY()));
        double x3 = Math.sqrt((p3.getX() - p0.getX()) * (p3.getX() - p0.getX()) + (p3.getY() - p0.getY()) * (p3.getY() - p0.getY()));
        double x4 = Math.sqrt((p4.getX() - p0.getX()) * (p4.getX() - p0.getX()) + (p4.getY() - p0.getY()) * (p4.getY() - p0.getY()));
        boolean b2 = Math.abs(x1 - x2) < 1.0E-11;
        b2 = b2 && Math.abs(x1 - x3) < 1.0E-11;
        keepCircle = b2 = b2 && Math.abs(x1 - x4) < 1.0E-11;
    }

    public boolean isMultipleFinalAccepted() {
        ConstructionObject[] p = this.M.getParams();
        if (this.Param < p.length - 1) {
            return false;
        }
        if (!(p[p.length - 1] instanceof PointObject)) {
            return false;
        }
        Vector t = this.M.getTargets();
        if (t.size() != 1) {
            return false;
        }
        ConstructionObject o = (ConstructionObject)t.get(0);
        return o instanceof PointObject;
    }

    public void LaunchLocus(ZirkelCanvas zc, Construction c2, ConstructionObject o) {
        ConstructionObject[] po = new ConstructionObject[]{};
        boolean pn = false;
        PointObject pm = new PointObject(c2, 0.0, 0.0);
        pm.setKeep(false);
        pm.setTarget(false);
        pm.setBound(o);
        pm.setSuperHidden(true);
        c2.add(pm);
        o.setTranslation(pm);
        pm.validate();
        c2.added(pm);
        this.Params[this.Params.length - 1] = pm;
        this.doMacro(zc);
        PointObject p = (PointObject)previewPoint;
        p.setKeep(false);
        p.setTarget(false);
        p.setSuperHidden(true);
        o.setTranslation(p);
        p.validate();
        c2.added(p);
        JLocusTrackObject jl = new JLocusTrackObject(c2, p, po, 0, o, pm);
        jl.setKeep(false);
        jl.setTarget(false);
        jl.setDefaults();
        c2.addNoCheck(jl);
        o.setTranslation(jl);
        jl.validate();
        c2.added(jl);
    }

    public void LaunchLocusPreview(ZirkelCanvas zc, Construction c2, ConstructionObject o) {
        ConstructionObject[] po = new ConstructionObject[]{};
        boolean pn = false;
        PointObject pm = new PointObject(c2, 0.0, 0.0);
        c2.add(pm);
        pm.setSuperHidden(true);
        this.Params[this.Params.length - 1] = pm;
        this.runMacroPreview(zc, false);
        PointObject p = (PointObject)previewPoint;
        p.setSuperHidden(true);
        JLocusTrackObject jl = new JLocusTrackObject(c2, p, po, 0, o, pm);
        jl.setKeep(false);
        jl.setTarget(false);
        jl.setSelectable(false);
        jl.setIndicated(true);
        c2.addNoCheck(jl);
        o.setTranslation(jl);
        jl.validate();
        c2.added(jl);
    }

    public boolean isLineObject(ConstructionObject o) {
        boolean b2 = o instanceof PrimitiveLineObject;
        b2 = b2 || o instanceof AreaObject;
        return b2;
    }

    public boolean isCircleObject(ConstructionObject o) {
        boolean b2 = o instanceof PrimitiveCircleObject;
        return b2;
    }

    public boolean isArcObject(ConstructionObject c2) {
        if (c2 instanceof PrimitiveCircleObject) {
            PrimitiveCircleObject cc = (PrimitiveCircleObject)c2;
            return cc.hasRange();
        }
        return false;
    }

    public void LaunchMultipleFinalMacro(MouseEvent e2, ZirkelCanvas zc) {
        ConstructionObject o = zc.selectMultipleFinal(e2.getX(), e2.getY(), false);
        Construction c2 = zc.getConstruction();
        if (o != null) {
            int myX = e2.getX();
            int myY = e2.getY();
            this.LastX = zc.x(myX);
            this.LastY = zc.y(myY);
            if (!keepLine && this.isLineObject(o)) {
                this.LaunchLocus(zc, c2, o);
                return;
            }
            if (!keepCircle && this.isCircleObject(o)) {
                this.LaunchLocus(zc, c2, o);
                return;
            }
            if (this.isArcObject(o)) {
                this.LaunchLocus(zc, c2, o);
                return;
            }
            if (o instanceof TwoPointLineObject) {
                TwoPointLineObject tplo = (TwoPointLineObject)o;
                TwoPointLineObject oc = (TwoPointLineObject)tplo.copy(this.LastX, this.LastY);
                this.Params[this.Params.length - 1] = tplo.getP1();
                this.doMacro(zc);
                PointObject p1 = (PointObject)previewPoint;
                this.Params[this.Params.length - 1] = tplo.getP2();
                this.doMacro(zc);
                PointObject p2 = (PointObject)previewPoint;
                oc.setP1P2(p1, p2);
                this.finaliseMacro(c2, o, oc);
            } else if (o instanceof PrimitiveLineObject) {
                PrimitiveLineObject tplo = (PrimitiveLineObject)o;
                this.Params[this.Params.length - 1] = tplo.getP1();
                this.doMacro(zc);
                PointObject p1 = (PointObject)previewPoint;
                PointObject p3 = tplo.getP1();
                String Pnm = p3.getName();
                String Lnm = tplo.getName();
                PointObject p4 = new PointObject(c2, p3.getX() + tplo.getDX(), p3.getY() + tplo.getDY());
                p4.setFixed("x(" + Pnm + ")+x(" + Lnm + ")", "y(" + Pnm + ")+y(" + Lnm + ")");
                p4.setSuperHidden(true);
                zc.addObject(p4);
                this.Params[this.Params.length - 1] = p4;
                this.doMacro(zc);
                PointObject p2 = (PointObject)previewPoint;
                p1.setSuperHidden(true);
                p2.setSuperHidden(true);
                LineObject oc = new LineObject(c2, p1, p2);
                this.finaliseMacro(c2, o, oc);
            } else if (o instanceof CircleObject) {
                CircleObject tplo = (CircleObject)o;
                CircleObject oc = (CircleObject)tplo.copy(this.LastX, this.LastY);
                this.Params[this.Params.length - 1] = tplo.getP1();
                this.doMacro(zc);
                PointObject p1 = (PointObject)previewPoint;
                this.Params[this.Params.length - 1] = tplo.getP2();
                this.doMacro(zc);
                PointObject p2 = (PointObject)previewPoint;
                p2.setSuperHidden(true);
                oc.setP1P2(p1, p2);
                this.finaliseMacro(c2, o, oc);
            } else if (o instanceof PrimitiveCircleObject) {
                PrimitiveCircleObject tplo = (PrimitiveCircleObject)o;
                this.Params[this.Params.length - 1] = tplo.getP1();
                this.doMacro(zc);
                PointObject p1 = (PointObject)previewPoint;
                PointObject p4 = new PointObject(c2, 0.0, 0.0);
                p4.setBound(tplo);
                p4.setSuperHidden(true);
                zc.addObject(p4);
                this.Params[this.Params.length - 1] = p4;
                this.doMacro(zc);
                PointObject p2 = (PointObject)previewPoint;
                p2.setSuperHidden(true);
                CircleObject oc = new CircleObject(c2, p1, p2);
                this.finaliseMacro(c2, o, oc);
            } else if (o instanceof AreaObject) {
                AreaObject ao = (AreaObject)o;
                AreaObject oc = (AreaObject)ao.copy(this.LastX, this.LastY);
                oc.V.removeAllElements();
                Enumeration<PointObject> en = ao.V.elements();
                while (en.hasMoreElements()) {
                    PointObject pt = en.nextElement();
                    this.Params[this.Param] = pt;
                    this.doMacro(zc);
                    oc.V.add((PointObject)previewPoint);
                }
                this.finaliseMacro(c2, o, oc);
            } else {
                this.LaunchLocus(zc, c2, o);
            }
        }
    }

    public void finaliseMacro(Construction c2, ConstructionObject o, ConstructionObject oc) {
        oc.setKeep(false);
        oc.setTarget(false);
        oc.setDefaults();
        c2.addNoCheck(oc);
        o.setTranslation(oc);
        oc.validate();
        c2.added(oc);
    }

    public void LaunchMultipleFinalMacroPreview(MouseEvent e2, ZirkelCanvas zc) {
        ConstructionObject o = zc.selectMultipleFinal(e2.getX(), e2.getY(), false);
        Construction c2 = zc.getConstruction();
        if (o != null) {
            int myX = e2.getX();
            int myY = e2.getY();
            zc.prepareForPreview(e2);
            this.checkIfKeepLine(zc);
            this.checkIfKeepCircle(zc);
            this.LastX = zc.x(myX);
            this.LastY = zc.y(myY);
            if (!keepLine && this.isLineObject(o)) {
                this.LaunchLocusPreview(zc, c2, o);
                return;
            }
            if (!keepCircle && this.isCircleObject(o)) {
                this.LaunchLocusPreview(zc, c2, o);
                return;
            }
            if (this.isArcObject(o)) {
                this.LaunchLocusPreview(zc, c2, o);
                return;
            }
            if (o instanceof TwoPointLineObject) {
                TwoPointLineObject tplo = (TwoPointLineObject)o;
                TwoPointLineObject oc = (TwoPointLineObject)tplo.copy(this.LastX, this.LastY);
                this.Params[this.Params.length - 1] = tplo.getP1();
                this.runMacroPreview(zc, true);
                PointObject p1 = (PointObject)previewPoint;
                this.Params[this.Params.length - 1] = tplo.getP2();
                this.runMacroPreview(zc, true);
                PointObject p2 = (PointObject)previewPoint;
                oc.setP1P2(p1, p2);
                this.finaliseMacroPreview(c2, o, oc);
            } else if (o instanceof PrimitiveLineObject) {
                PrimitiveLineObject tplo = (PrimitiveLineObject)o;
                this.Params[this.Params.length - 1] = tplo.getP1();
                this.runMacroPreview(zc, false);
                PointObject p1 = (PointObject)previewPoint;
                PointObject p0 = tplo.getP1();
                this.Params[this.Params.length - 1] = new PointObject(c2, p0.getX() + tplo.getDX(), p0.getY() + tplo.getDY());
                this.runMacroPreview(zc, false);
                PointObject p2 = (PointObject)previewPoint;
                LineObject oc = new LineObject(c2, p1, p2);
                this.finaliseMacroPreview(c2, o, oc);
            } else if (o instanceof CircleObject) {
                CircleObject tplo = (CircleObject)o;
                CircleObject oc = (CircleObject)tplo.copy(this.LastX, this.LastY);
                this.Params[this.Params.length - 1] = tplo.getP1();
                this.runMacroPreview(zc, true);
                PointObject p1 = (PointObject)previewPoint;
                this.Params[this.Params.length - 1] = tplo.getP2();
                this.runMacroPreview(zc, false);
                PointObject p2 = (PointObject)previewPoint;
                oc.setP1P2(p1, p2);
                this.finaliseMacroPreview(c2, o, oc);
            } else if (o instanceof PrimitiveCircleObject) {
                PrimitiveCircleObject tplo = (PrimitiveCircleObject)o;
                this.Params[this.Params.length - 1] = tplo.getP1();
                this.runMacroPreview(zc, true);
                PointObject p1 = (PointObject)previewPoint;
                PointObject p4 = new PointObject(c2, tplo.getP1().getX() + tplo.getR(), tplo.getP1().getY());
                p4.setSuperHidden(true);
                c2.add(p4);
                this.Params[this.Params.length - 1] = p4;
                this.runMacroPreview(zc, false);
                PointObject p2 = (PointObject)previewPoint;
                CircleObject oc = new CircleObject(c2, p1, p2);
                this.finaliseMacroPreview(c2, o, oc);
            } else if (o instanceof AreaObject) {
                AreaObject ao = (AreaObject)o;
                AreaObject oc = (AreaObject)ao.copy(this.LastX, this.LastY);
                oc.V.removeAllElements();
                Enumeration<PointObject> en = ao.V.elements();
                while (en.hasMoreElements()) {
                    PointObject pt = en.nextElement();
                    this.Params[this.Params.length - 1] = pt;
                    this.runMacroPreview(zc, true);
                    oc.V.add((PointObject)previewPoint);
                }
                this.finaliseMacroPreview(c2, o, oc);
            } else {
                this.LaunchLocusPreview(zc, c2, o);
            }
        }
    }

    public void finaliseMacroPreview(Construction c2, ConstructionObject o, ConstructionObject oc) {
        oc.setKeep(false);
        oc.setTarget(false);
        oc.setSelectable(false);
        oc.setIndicated(true);
        c2.addNoCheck(oc);
        o.setTranslation(oc);
        oc.validate();
        c2.added(oc);
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        ConstructionObject o;
        ConstructionObject[] p = this.M.getParams();
        zc.clearIndicated();
        zc.clearPreview();
        zc.repaint();
        if (!e2.isAltDown() && this.isMultipleFinalAccepted() && (o = zc.selectMultipleFinal(e2.getX(), e2.getY(), false)) != null) {
            int myX = e2.getX();
            int myY = e2.getY();
            zc.prepareForPreview(e2);
            this.LastX = zc.x(myX);
            this.LastY = zc.y(myY);
            this.LaunchMultipleFinalMacroPreview(e2, zc);
            zc.indicateMultipleFinal(e2.getX(), e2.getY());
            return;
        }
        if (!(p[this.Param] instanceof PointObject) && this.Param == p.length - 1 && (o = zc.selectWithSelector(e2.getX(), e2.getY(), (Selector)this, false)) != null) {
            int myX = e2.getX();
            int myY = e2.getY();
            zc.prepareForPreview(e2);
            this.Params[this.Param] = o;
            this.LastX = zc.x(myX);
            this.LastY = zc.y(myY);
            this.runMacroPreview(zc, true);
            zc.indicateWithSelector(myX, myY, this);
            return;
        }
        if (p[this.Param] instanceof PointObject) {
            zc.indicateCreatePoint(e2.getX(), e2.getY(), true);
        } else {
            zc.indicateWithSelector(e2.getX(), e2.getY(), this);
        }
        if (!simple && this.waitForLastPoint()) {
            if (zc.isPreview()) {
                zc.movePreview(e2);
            } else {
                zc.prepareForPreview(e2);
                this.finishConstruction(e2, zc);
                return;
            }
        }
    }

    @Override
    public boolean waitForLastPoint() {
        if (this.M.countPrompts() > 0) {
            return false;
        }
        ConstructionObject[] p = this.M.getParams();
        return p[this.Param] instanceof PointObject && this.Param == p.length - 1;
    }

    @Override
    public void finishConstruction(MouseEvent e2, ZirkelCanvas zc) {
        ConstructionObject[] p = this.M.getParams();
        if (!(p[this.Param] instanceof PointObject)) {
            return;
        }
        PointObject o = zc.selectCreatePoint(e2.getX(), e2.getY(), e2.isAltDown());
        this.NewPoint[this.Param] = true;
        this.Params[this.Param] = o;
        this.runMacroPreview(zc, true);
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        if (zc.Visual) {
            super.reset(zc);
            this.Param = 0;
            if (this.M != null && this.M.hasFixed()) {
                this.getFixed(zc);
            }
            this.showStatus(zc);
        } else if (this.M != null) {
            StringBuffer b2 = new StringBuffer();
            b2.append('=');
            String name = this.M.getName();
            if (name.indexOf("(") > 0) {
                b2.append("\"" + this.M.getName() + "\"");
            } else {
                b2.append(this.M.getName());
            }
            b2.append('(');
            for (int i = 0; i < this.M.getParams().length - 1; ++i) {
                b2.append(',');
            }
            b2.append(')');
            zc.setPrompt(b2.toString());
        }
    }

    public void getFixed(ZirkelCanvas zc) {
        boolean start;
        if (this.M == null || !zc.Visual) {
            return;
        }
        boolean bl = start = this.Param == 0;
        while ((this.M.isFixed(this.Param) || this.M.getPrompts()[this.Param].startsWith("=")) && this.Param < (start ? this.S.length - 1 : this.S.length)) {
            String name = this.M.isFixed(this.Param) ? this.M.getLast(this.Param) : this.M.getPrompts()[this.Param].substring(1);
            if (name.equals("")) {
                this.M.setFixed(this.Param, false);
                break;
            }
            ConstructionObject o = zc.getConstruction().find(name);
            if (o == null) {
                this.M.setFixed(this.Param, false);
                break;
            }
            if (!this.setNextParameter(o, zc, false)) {
                return;
            }
            if (this.Param < this.S.length) continue;
            this.doMacro(zc);
            this.reset(zc);
            break;
        }
        this.showStatus(zc);
    }

    public void returnPressed(ZirkelCanvas zc) {
        if (this.M == null || !zc.Visual) {
            return;
        }
        String name = this.M.getLast(this.Param);
        if (name.equals("")) {
            return;
        }
        ConstructionObject o = zc.getConstruction().find(name);
        if (!this.setNextParameter(o, zc, false)) {
            return;
        }
        if (this.Param >= this.S.length) {
            this.doMacro(zc);
            this.reset(zc);
        } else {
            this.getFixed(zc);
        }
    }

    public boolean setNextParameter(ConstructionObject o, ZirkelCanvas zc, boolean fix) {
        if (!this.isAdmissible(zc, o)) {
            return false;
        }
        this.Params[this.Param] = o;
        o.setSelected(true);
        if (fix) {
            this.Fixed[this.Param] = true;
        }
        zc.getConstruction().addParameter(o);
        zc.repaint();
        ++this.Param;
        return true;
    }

    public void doMacro(ZirkelCanvas zc) {
        String[] value = new String[]{};
        this.runMacro(zc, value);
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.M != null) {
            ConstructionObject[] p = this.M.getParams();
            String type = "???";
            if (p[this.Param] instanceof PointObject) {
                type = Global.name("name.Point");
            } else if (p[this.Param] instanceof FixedAngleObject) {
                type = Global.name("name.FixedAngle");
            } else if (p[this.Param] instanceof SegmentObject) {
                type = Global.name("name.Segment");
            } else if (p[this.Param] instanceof LineObject) {
                type = Global.name("name.TwoPointLine");
            } else if (p[this.Param] instanceof RayObject) {
                type = Global.name("name.Ray");
            } else if (p[this.Param] instanceof PrimitiveLineObject) {
                type = Global.name("name.Line");
            } else if (p[this.Param] instanceof PrimitiveCircleObject) {
                type = Global.name("name.Circle");
            } else if (p[this.Param] instanceof ExpressionObject) {
                type = Global.name("name.Expression");
            } else if (p[this.Param] instanceof AreaObject) {
                type = Global.name("name.Polygon");
            } else if (p[this.Param] instanceof AngleObject) {
                type = Global.name("name.Angle");
            }
            String s = this.M.getLast(this.Param);
            String prompt = s.equals("") ? ConstructionObject.text4(Global.name("message.runmacro"), this.M.getName(), "" + (this.Param + 1), type, this.S[this.Param]) : ConstructionObject.text4(Global.name("message.runmacro"), this.M.getName(), "" + (this.Param + 1), type, this.S[this.Param]) + " " + ConstructionObject.text1(Global.name("message.runmacro.return"), this.M.getLast(this.Param));
            zc.showStatus(prompt);
        }
    }

    public void runMacro(ZirkelCanvas zc, Construction c2, String[] value) {
        this.OCs.clear();
        this.PROMPTs.clear();
        this.M.setTranslation(c2);
        ConstructionObject LastBefore = c2.last();
        int N = this.Params.length;
        Enumeration e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.clearParameter();
            o.setTranslation(null);
        }
        this.M.clearTranslations();
        c2.clearTranslators();
        ConstructionObject[] p = this.M.getParams();
        this.M.initLast();
        for (int i = 0; i < N; ++i) {
            PointObject P;
            this.M.setLast(this.Params[i].getName(), i);
            p[i].setTranslation(this.Params[i]);
            p[i].setMainParameter(true);
            if (this.NewPoint[i] && p[i].isHidden()) {
                this.Params[i].setHidden(true);
            }
            if (this.Params[i] instanceof PointObject && p[i] instanceof PointObject && this.NewPoint[i]) {
                PointObject pa = (PointObject)this.Params[i];
                PointObject pp = (PointObject)p[i];
                pa.setIncrement(pp.getIncrement());
                if (pp.getBound() != null) {
                    pa.setBound(pp.getBound());
                    pa.setInside(pp.isInside());
                    pa.translate();
                }
            }
            if (this.Params[i] instanceof PointObject && p[i] instanceof PointObject && ((PointObject)p[i]).dependsOnItselfOnly() && !(P = (PointObject)this.Params[i]).depending().hasMoreElements()) {
                P.setConstruction(this.M);
                P.setFixed(((PointObject)p[i]).getEX(), ((PointObject)p[i]).getEY());
                P.translateConditionals();
                P.translate();
                P.setConstruction(c2);
            }
            if (!p[i].isMainParameter()) continue;
            e2 = p[i].secondaryParams();
            DL.reset();
            while (e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                DL.add(o);
                o.setParameter(true);
            }
            e2 = DL.elements();
            Enumeration ep = this.Params[i].secondaryParams();
            while (ep.hasMoreElements() && e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                ConstructionObject op = (ConstructionObject)ep.nextElement();
                if (o.getTranslation() != op && o.getTranslation() != null) {
                    zc.warning(Global.name("macro.usage"));
                    return;
                }
                o.setTranslation(op);
            }
        }
        e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) continue;
            ConstructionObject oc = o.copy(this.LastX, this.LastY);
            previewPoint = oc;
            oc.setKeep(false);
            oc.setTarget(false);
            c2.addNoCheck(oc);
            o.setTranslation(oc);
            oc.validate();
            c2.added(oc);
            if (o.isTarget()) {
                oc.setTargetDefaults();
            }
            if (!(oc instanceof FixedCircleObject) && !(oc instanceof FixedAngleObject) && !(oc instanceof ExpressionObject) || !this.M.promptFor(o.getName())) continue;
            c2.updateCircleDep();
            c2.dovalidate();
            zc.repaint();
            int index = this.M.getPromptFor(o.getName());
            if (index < value.length && !value[index].equals("")) continue;
            this.OCs.add(oc);
            this.PROMPTs.add(this.M.getPromptName(o.getName()));
        }
        e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) continue;
            o.laterTranslate(this.M);
        }
        c2.updateCircleDep();
        c2.runTranslators(this.M);
        c2.dovalidate();
        zc.repaint();
        int fixed = 0;
        for (Object element : (ConstructionObject)this.Fixed) {
            if (element == false) continue;
            ++fixed;
        }
        if (fixed > 0 && fixed < this.Fixed.length && !this.M.hasFixed()) {
            int i;
            String name = this.M.getName() + " -";
            for (i = 0; i < this.Fixed.length; ++i) {
                if (!this.Fixed[i]) continue;
                name = name + " " + this.M.LastParams[i];
            }
            this.M = zc.copyMacro(this.M, name, this.Fixed);
            for (i = 0; i < this.Fixed.length; ++i) {
                this.Fixed[i] = false;
            }
            this.reset(zc);
        }
        if (LastBefore != null && this.M.hideDuplicates()) {
            zc.hideDuplicates(LastBefore);
        }
        this.ZC = zc;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < MacroRunner.this.OCs.size(); ++i) {
                    String myName = (String)MacroRunner.this.PROMPTs.get(i);
                    ConstructionObject myCO = (ConstructionObject)MacroRunner.this.OCs.get(i);
                    new JMacroPrompt(MacroRunner.this.ZC.getFrame(), MacroRunner.this.ZC, myName, myCO);
                }
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    public void runMacro(ZirkelCanvas zc, String[] value) {
        this.runMacro(zc, zc.getConstruction(), value);
    }

    public void runMacroPreview(ZirkelCanvas zc, boolean visible) {
        Construction c2 = zc.getConstruction();
        this.M.setTranslation(c2);
        int N = this.Params.length;
        Enumeration e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.clearParameter();
            o.setTranslation(null);
        }
        this.M.clearTranslations();
        c2.clearTranslators();
        ConstructionObject[] p = this.M.getParams();
        for (int i = 0; i < N; ++i) {
            this.M.setLast(this.Params[i].getName(), i);
            p[i].setTranslation(this.Params[i]);
            p[i].setMainParameter(true);
            if (this.NewPoint[i] && p[i].isHidden()) {
                this.Params[i].setHidden(true);
            }
            if (!p[i].isMainParameter()) continue;
            e2 = p[i].secondaryParams();
            DL.reset();
            while (e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                DL.add(o);
                o.setParameter(true);
            }
            e2 = DL.elements();
            Enumeration ep = this.Params[i].secondaryParams();
            while (ep.hasMoreElements() && e2.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e2.nextElement();
                ConstructionObject op = (ConstructionObject)ep.nextElement();
                if (o.getTranslation() != op && o.getTranslation() != null) {
                    return;
                }
                if (o == null) continue;
                o.setTranslation(op);
            }
        }
        e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject oc;
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) continue;
            previewPoint = oc = o.copy(this.LastX, this.LastY);
            oc.setKeep(false);
            oc.setTarget(false);
            oc.setSelectable(false);
            if (visible) {
                oc.setIndicated(true);
            } else {
                oc.setSuperHidden(true);
            }
            c2.addNoCheck(oc);
            o.setTranslation(oc);
            oc.validate();
            c2.added(oc);
            if (o.isTarget()) {
                oc.setTargetDefaults();
            }
            if (o.isHidden()) {
                oc.setHidden(true);
            }
            if (oc.getColorIndex() != 0) continue;
            oc.setColor(c2.DefaultColor);
        }
        e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) continue;
            o.laterTranslate(this.M);
        }
        c2.updateCircleDep();
        c2.runTranslators(this.M);
        c2.dovalidate();
        zc.repaint();
    }

    public void run(ZirkelCanvas zc, Construction c2) throws ConstructionException {
        int i;
        ConstructionObject[] p = this.M.getParams();
        String[] value = new String[this.M.countPrompts()];
        for (i = 0; i < this.M.countPrompts(); ++i) {
            value[i] = "";
        }
        for (i = 0; i < p.length; ++i) {
            ConstructionObject o = this.M.getParams()[i];
            if (o == null) {
                throw new ConstructionException(Global.name("exception.notfound"));
            }
            this.Params[i] = o;
        }
        this.runMacro(zc, c2, value);
        zc.repaint();
    }

    public void run(ZirkelCanvas zc, Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        int i;
        ConstructionObject[] p = this.M.getParams();
        if (nparams != p.length + this.M.countPrompts()) {
            throw new ConstructionException(Global.name("exception.nparams"));
        }
        String[] value = new String[this.M.countPrompts()];
        for (i = 0; i < this.M.countPrompts(); ++i) {
            value[i] = params[p.length + i];
        }
        for (i = 0; i < p.length; ++i) {
            ConstructionObject o = c2.find(params[i]);
            if (o == null) {
                throw new ConstructionException(Global.name("exception.notfound"));
            }
            if (p[this.Param] instanceof PointObject) {
                if (!(o instanceof PointObject)) {
                    throw new ConstructionException(Global.name("exception.type"));
                }
                if (p[this.Param] instanceof SegmentObject) {
                    if (!(o instanceof SegmentObject)) {
                        throw new ConstructionException(Global.name("exception.type"));
                    }
                    if (p[this.Param] instanceof LineObject) {
                        if (!(o instanceof LineObject)) {
                            throw new ConstructionException(Global.name("exception.type"));
                        }
                        if (p[this.Param] instanceof RayObject) {
                            if (!(o instanceof RayObject)) {
                                throw new ConstructionException(Global.name("exception.type"));
                            }
                            if (p[this.Param] instanceof PrimitiveLineObject) {
                                if (!(o instanceof PrimitiveLineObject)) {
                                    throw new ConstructionException(Global.name("exception.type"));
                                }
                                if (p[this.Param] instanceof PrimitiveCircleObject) {
                                    if (!(o instanceof PrimitiveCircleObject)) {
                                        throw new ConstructionException(Global.name("exception.type"));
                                    }
                                    throw new ConstructionException(Global.name("exception.type"));
                                }
                            }
                        }
                    }
                }
            }
            this.Params[i] = o;
        }
        this.runMacro(zc, c2, value);
        StringTokenizer t = new StringTokenizer(name, ",");
        Enumeration e2 = this.M.getTargets().elements();
        while (e2.hasMoreElements() && t.hasMoreTokens()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.getTranslation().setName(t.nextToken().trim());
        }
        zc.repaint();
    }
}

