/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.UserFunctionObject;
import carmetal.rene.zirkel.expression.BasicExpression;

class UserFunctionExpression
extends BasicExpression {
    ConstructionObject F;
    BasicExpression[] E;
    double[] X;

    public UserFunctionExpression(ConstructionObject f2, BasicExpression[] e2) {
        this.F = f2;
        this.E = e2;
        this.X = new double[this.E.length];
    }

    @Override
    public double getValue() throws ConstructionException {
        for (int i = 0; i < this.E.length; ++i) {
            this.X[i] = this.E[i].getValue();
        }
        if (this.F instanceof FunctionObject) {
            return ((FunctionObject)this.F).evaluateF(this.X);
        }
        return ((UserFunctionObject)this.F).evaluateF(this.X);
    }

    @Override
    public void translate() {
        for (BasicExpression element : this.E) {
            element.translate();
        }
        this.F = this.F instanceof FunctionObject ? (FunctionObject)this.F.getTranslation() : (UserFunctionObject)this.F.getTranslation();
    }

    @Override
    public void reset() {
        for (BasicExpression element : this.E) {
            element.reset();
        }
    }

    public String toString() {
        String ex = this.E[0].toString();
        for (int i = 1; i < this.E.length; ++i) {
            ex = ex + "," + this.E[i].toString();
        }
        return this.F.getName() + "(" + ex + ")";
    }
}

