/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.ConstructionException;
import carmetal.rene.zirkel.expression.BasicExpression;
import carmetal.rene.zirkel.expression.ExpressionText;
import carmetal.rene.zirkel.expression.MinusExpression;
import carmetal.rene.zirkel.expression.ProductExpression;

class QuotientExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;

    public QuotientExpression(BasicExpression e1, BasicExpression e2) {
        this.E1 = e1;
        this.E2 = e2;
    }

    public static BasicExpression scan(ExpressionText t, BasicExpression E) throws ConstructionException {
        BasicExpression E1 = MinusExpression.scan(t);
        if (t.next() == '/') {
            t.advance();
            return QuotientExpression.scan(t, new QuotientExpression(E, E1));
        }
        if (t.next() == '*' && t.nextnext() != '*') {
            t.advance();
            return ProductExpression.scan(t, new QuotientExpression(E, E1));
        }
        return new QuotientExpression(E, E1);
    }

    @Override
    public double getValue() throws ConstructionException {
        return this.E1.getValue() / this.E2.getValue();
    }

    @Override
    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        return this.E1 + "/" + this.E2;
    }

    @Override
    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }
}

