/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.objects.EquationXYObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.UserFunctionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.expression.BasicExpression;
import carmetal.rene.zirkel.expression.ConstantExpression;
import carmetal.rene.zirkel.expression.ConstructionExpression;
import carmetal.rene.zirkel.expression.ExpressionText;
import carmetal.rene.zirkel.expression.FindObjectExpression;
import carmetal.rene.zirkel.expression.FunctionExpression;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.expression.ValidExpression;

class ObjectExpression
extends BasicExpression {
    ConstructionObject O;
    String Var = null;

    public ObjectExpression(ConstructionObject o) {
        this.O = o;
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.O.valid()) {
            throw new InvalidException("");
        }
        if (this.Var != null && this.O instanceof FunctionObject) {
            return ((FunctionObject)this.O).getValue(this.Var);
        }
        if (this.Var != null && this.O instanceof UserFunctionObject) {
            return ((UserFunctionObject)this.O).getValue(this.Var);
        }
        if (this.Var != null && this.O instanceof EquationXYObject) {
            return ((EquationXYObject)this.O).getValue(this.Var);
        }
        return this.O.getValue();
    }

    public ConstructionObject getObject() {
        return this.O;
    }

    public static BasicExpression scan(ExpressionText t, boolean quotes) throws ConstructionException {
        char c2;
        if (!quotes && t.next() == '\"') {
            t.advance();
            BasicExpression E = ObjectExpression.scan(t, true);
            if (t.next() != '\"') {
                throw new ConstructionException(Global.name("exception.quotes"));
            }
            t.advance();
            return E;
        }
        StringBuffer b2 = new StringBuffer();
        while (Character.isLetterOrDigit(c2 = t.next(quotes)) || c2 == '\\' || c2 == '\'' || quotes && c2 != '\"' && c2 != '\u0000' || quotes && c2 == ' ') {
            b2.append(c2);
            t.advance(quotes);
        }
        if (!quotes && t.next() == '(') {
            return FunctionExpression.scan(t, b2.toString());
        }
        String s = b2.toString();
        if (s.equals("pi")) {
            return new ConstantExpression("pi", Math.PI);
        }
        if (s.equals("valid")) {
            return new ValidExpression(true);
        }
        if (s.equals("invalid")) {
            return new ValidExpression(false);
        }
        if (s.equals("this")) {
            t.getDepList().add(t.getObject());
            return new ObjectExpression(t.getObject());
        }
        if (s.equals("windoww")) {
            return new ConstructionExpression(t.getConstruction(), 2);
        }
        if (s.equals("windowh")) {
            return new ConstructionExpression(t.getConstruction(), 3);
        }
        if (s.equals("windowcx")) {
            return new ConstructionExpression(t.getConstruction(), 0);
        }
        if (s.equals("windowcy")) {
            return new ConstructionExpression(t.getConstruction(), 1);
        }
        if (s.equals("pixel")) {
            return new ConstructionExpression(t.getConstruction(), 4);
        }
        if (t.isVar(s)) {
            ObjectExpression oe = new ObjectExpression(t.getObject());
            oe.Var = s;
            return oe;
        }
        ConstructionObject o = t.getConstruction().findInclusive(s, t.getObject());
        if (o == null) {
            o = t.getConstruction().find(s);
            if (o == null) {
                if (t.getConstruction().loading()) {
                    return new FindObjectExpression(s, t.getConstruction());
                }
                throw new ConstructionException(Global.name("exception.notfound") + " (" + s + ")");
            }
            if (t.getConstruction().dependsOn(o, t.getObject())) {
                if (t.nocircles()) {
                    throw new ConstructionException(ConstructionObject.text1(Global.name("exception.depends"), s));
                }
                return new FindObjectExpression(s, t.getConstruction());
            }
            t.getConstruction().needsOrdering();
        }
        t.getDepList().add(o);
        return new ObjectExpression(o);
    }

    public static BasicExpression scan(ExpressionText t) throws ConstructionException {
        if (t.next() == '@') {
            t.advance();
            return FindObjectExpression.scan(t);
        }
        return ObjectExpression.scan(t, false);
    }

    @Override
    public void translate() {
        this.O = this.O.getTranslation();
    }

    public String toString() {
        if (this.Var != null) {
            return this.Var;
        }
        return ObjectExpression.quote(this.O.getName());
    }

    public static String quote(String name) {
        boolean quotes = false;
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i))) continue;
            quotes = true;
            break;
        }
        if (quotes) {
            return "\"" + name + "\"";
        }
        return name;
    }
}

