/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.ConstructionException;
import carmetal.rene.zirkel.expression.BasicExpression;
import carmetal.rene.zirkel.expression.ElementaryExpression;
import carmetal.rene.zirkel.expression.ExpressionText;
import carmetal.rene.zirkel.expression.PotenzExpression;

class MinusExpression
extends ElementaryExpression {
    BasicExpression E;

    public MinusExpression(BasicExpression e2) {
        this.E = e2;
    }

    @Override
    public double getValue() throws ConstructionException {
        return -this.E.getValue();
    }

    public static BasicExpression scan(ExpressionText t) throws ConstructionException {
        if (t.next() != '-') {
            return PotenzExpression.scan(t);
        }
        t.advance();
        BasicExpression E1 = PotenzExpression.scan(t);
        return new MinusExpression(E1);
    }

    @Override
    public void translate() {
        this.E.translate();
    }

    public String toString() {
        return "-" + this.E.toString();
    }

    @Override
    public boolean isNumber() {
        return this.E.isNumber();
    }

    @Override
    public void reset() {
        this.E.reset();
    }
}

