/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.util.sort;

import carmetal.rene.util.sort.SortObject;
import carmetal.rene.util.sort.SortString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;

public class Sorter {
    public static void sort(SortObject[] v) {
        Sorter.QuickSort(v, 0, v.length - 1);
    }

    public static void sort(SortObject[] v, int n) {
        Sorter.QuickSort(v, 0, n - 1);
    }

    public static void sort(Vector v) {
        Object[] o = new SortObject[v.size()];
        v.copyInto(o);
        Sorter.sort((SortObject[])o);
        for (int i = 0; i < o.length; ++i) {
            v.setElementAt(o[i], i);
        }
    }

    public static void QuickSort(SortObject[] a2, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            SortObject mid = a2[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a2[lo].compare(mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && a2[hi].compare(mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Sorter.swap(a2, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Sorter.QuickSort(a2, lo0, hi);
            }
            if (lo < hi0) {
                Sorter.QuickSort(a2, lo, hi0);
            }
        }
    }

    private static void swap(SortObject[] a2, int i, int j) {
        SortObject T = a2[i];
        a2[i] = a2[j];
        a2[j] = T;
    }

    public static void QuickSort(Object[] a2, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            SortObject mid = (SortObject)a2[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && ((SortObject)a2[lo]).compare(mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && ((SortObject)a2[hi]).compare(mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Sorter.swap(a2, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Sorter.QuickSort(a2, lo0, hi);
            }
            if (lo < hi0) {
                Sorter.QuickSort(a2, lo, hi0);
            }
        }
    }

    private static void swap(Object[] a2, int i, int j) {
        Object T = a2[i];
        a2[i] = a2[j];
        a2[j] = T;
    }

    public static void main(String[] args) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Vector<SortString> v = new Vector<SortString>();
        while ((line = in.readLine()) != null) {
            v.addElement(new SortString(line));
        }
        in.close();
        Sorter.sort(v);
        Enumeration e2 = v.elements();
        String last = null;
        while (e2.hasMoreElements()) {
            String s = ((SortString)e2.nextElement()).toString();
            if (last != null && s.equals(last)) continue;
            System.out.println(s);
            last = s;
        }
    }
}

