/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.gui;

import carmetal.construction.Construction;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.window.MenuBar;
import carmetal.eric.JBrowserLauncher;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.OS;
import carmetal.eric.controls.SliderSnap;
import carmetal.objects.ConstructionObject;
import carmetal.objects.DriverObject;
import carmetal.objects.UserFunctionObject;
import carmetal.rene.dialogs.Warning;
import carmetal.rene.util.FileName;
import carmetal.rene.util.parser.StringParser;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;

public class Global {
    public static Font NormalFont = null;
    public static Font FixedFont = null;
    public static Font BoldFont = null;
    public static final String CONFIG = ".carmetal_config";
    public static String GlobalFont = "Dialog";
    private static ResourceBundle ericBundle;
    private static ResourceBundle reneBundle;
    public static String FontURL;
    public static String ChineseFontURL;
    private static Vector ObjectsToClearList;
    public static Properties P;
    static String ConfigName;
    static Frame F;
    public static Object ExitBlock;
    public static ArrayList<String> StartupFiles;
    public static boolean isNewVersion;
    static double[] VARS;
    private static ConstructionObject JSO;
    private static boolean JSquit;
    private static Rectangle SCREEN;

    public static void makeFonts() {
        NormalFont = Global.createfont("normalfont", "SansSerif", 12, false);
        FixedFont = Global.createfont("fixedfont", "Monospaced", 12, false);
        BoldFont = Global.createfont("fixedfont", "Monospaced", 12, true);
        isNewVersion = true;
    }

    public static Font createfont(String name, String def, int defsize, boolean bold) {
        String fontname = Global.getParameter(name + ".name", def);
        String mode = Global.getParameter(name + ".mode", "plain");
        if (bold || mode.equals("bold")) {
            return new Font(fontname, 1, Global.getParameter(name + ".size", defsize));
        }
        if (mode.equals("italic")) {
            return new Font(fontname, 2, Global.getParameter(name + ".size", defsize));
        }
        return new Font(fontname, 0, Global.getParameter(name + ".size", defsize));
    }

    public static void doClearList() {
        Enumeration e2 = ObjectsToClearList.elements();
        while (e2.hasMoreElements()) {
            DriverObject dobj = (DriverObject)e2.nextElement();
            if (!dobj.somethingChanged()) continue;
            dobj.clearChanges();
        }
        ObjectsToClearList.clear();
    }

    public static void addClearList(DriverObject oc) {
        ObjectsToClearList.add(oc);
    }

    public static Enumeration names() {
        if (reneBundle != null) {
            return reneBundle.getKeys();
        }
        return null;
    }

    public static String name(String tag, String def) {
        String s;
        if (reneBundle == null) {
            return def;
        }
        try {
            s = reneBundle.getString(tag);
        }
        catch (Exception e2) {
            s = def;
        }
        return s;
    }

    public static String name(String tag) {
        return Global.name(tag, tag.substring(tag.lastIndexOf(".") + 1));
    }

    public static String Loc(String s) {
        String rep = null;
        try {
            rep = ericBundle.getString(s);
        }
        catch (Exception e1) {
            try {
                rep = reneBundle.getString(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rep;
    }

    public static void initBundles() {
        String lang = Global.getParameter("language", "");
        String country = Global.getParameter("country", "");
        if (!lang.equals("")) {
            try {
                Locale.setDefault(new Locale(lang, country));
            }
            catch (Exception ex) {
                Locale.setDefault(new Locale("en", ""));
                Global.setParameter("language", "en");
                Global.setParameter("country", "");
            }
        }
        ericBundle = ResourceBundle.getBundle("carmetal/eric/docs/JZirkelProperties");
        reneBundle = ResourceBundle.getBundle("carmetal/rene/zirkel/docs/ZirkelProperties");
    }

    public static synchronized Enumeration properties() {
        return P.keys();
    }

    public static synchronized void loadProperties(InputStream in) {
        try {
            P = new Properties();
            P.load(in);
            in.close();
        }
        catch (Exception e2) {
            P = new Properties();
        }
    }

    public static synchronized boolean loadPropertiesFromResource(String filename) {
        try {
            Object G = new Object();
            InputStream in = G.getClass().getResourceAsStream(filename);
            P = new Properties();
            P.load(in);
            in.close();
        }
        catch (Exception e2) {
            P = new Properties();
            return false;
        }
        ConfigName = filename;
        return true;
    }

    public static synchronized boolean loadProperties(String filename) {
        ConfigName = filename;
        try {
            FileInputStream in = new FileInputStream(filename);
            P = new Properties();
            P.load(in);
            in.close();
        }
        catch (Exception e2) {
            P = new Properties();
            return false;
        }
        return true;
    }

    public static synchronized void loadProperties(String dir, String filename) {
        try {
            Properties p = System.getProperties();
            ConfigName = dir + p.getProperty("file.separator") + filename;
            Global.loadProperties(ConfigName);
        }
        catch (Exception e2) {
            P = new Properties();
        }
    }

    public static synchronized void loadPropertiesInHome(String filename) {
        try {
            Properties p = System.getProperties();
            Global.loadProperties(p.getProperty("user.home"), filename);
        }
        catch (Exception e2) {
            P = new Properties();
        }
    }

    public static synchronized void clearProperties() {
        P = new Properties();
    }

    public static synchronized void saveProperties(String text) {
        try {
            FileOutputStream out = new FileOutputStream(ConfigName);
            P.store(out, text);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveProperties(String text, String filename) {
        ConfigName = filename;
        Global.saveProperties(text);
    }

    public static synchronized void setParameter(String key, boolean value) {
        if (P == null) {
            return;
        }
        if (value) {
            P.put(key, "true");
        } else {
            P.put(key, "false");
        }
    }

    public static synchronized boolean getParameter(String key, boolean def) {
        try {
            String s = P.getProperty(key);
            if (s.equals("true")) {
                return true;
            }
            if (s.equals("false")) {
                return false;
            }
            return def;
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static synchronized String getParameter(String key, String def) {
        String res = def;
        try {
            res = P.getProperty(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (res != null) {
            if (res.startsWith("$")) {
                res = res.substring(1);
            }
            return res;
        }
        return def;
    }

    public static synchronized void setParameter(String key, String value) {
        if (P == null) {
            return;
        }
        if (value.length() > 0 && Character.isSpaceChar(value.charAt(0))) {
            value = "$" + value;
        }
        P.put(key, value);
    }

    public static synchronized int getParameter(String key, int def) {
        try {
            return Integer.parseInt(Global.getParameter(key, ""));
        }
        catch (Exception e2) {
            try {
                double x = new Double(Global.getParameter(key, ""));
                return (int)x;
            }
            catch (Exception exception) {
                return def;
            }
        }
    }

    public static synchronized void setParameter(String key, int value) {
        Global.setParameter(key, "" + value);
    }

    public static synchronized double getParameter(String key, double def) {
        try {
            return new Double(Global.getParameter(key, ""));
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static synchronized void setParameter(String key, double value) {
        Global.setParameter(key, "" + value);
    }

    public static synchronized Color getParameter(String key, Color c2) {
        String s = Global.getParameter(key, "");
        if (s.equals("")) {
            return c2;
        }
        StringParser p = new StringParser(s);
        p.replace(',', ' ');
        int red = p.parseint();
        int green = p.parseint();
        int blue = p.parseint();
        try {
            return new Color(red, green, blue);
        }
        catch (RuntimeException e2) {
            return c2;
        }
    }

    public static synchronized Color getParameter(String key, int red, int green, int blue) {
        String s = Global.getParameter(key, "");
        if (s.equals("")) {
            return new Color(red, green, blue);
        }
        StringParser p = new StringParser(s);
        p.replace(',', ' ');
        red = p.parseint();
        green = p.parseint();
        blue = p.parseint();
        try {
            return new Color(red, green, blue);
        }
        catch (RuntimeException e2) {
            return Color.black;
        }
    }

    public static synchronized void setParameter(String key, Color c2) {
        if (c2 != null) {
            Global.setParameter(key, "" + c2.getRed() + "," + c2.getGreen() + "," + c2.getBlue());
        } else {
            P.remove(key);
        }
    }

    public static synchronized void removeParameter(String key) {
        P.remove(key);
    }

    public static synchronized void removeAllParameters(String start) {
        Enumeration<Object> e2 = P.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            if (!key.startsWith(start)) continue;
            P.remove(key);
        }
    }

    public static synchronized void resetDefaults(String defaults) {
        Enumeration<Object> e2 = P.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            if (!key.startsWith(defaults)) continue;
            Global.setParameter(key.substring(defaults.length()), Global.getParameter(key, ""));
        }
    }

    public static void resetDefaults() {
        Global.resetDefaults("default.");
    }

    public static synchronized boolean haveParameter(String key) {
        try {
            String res = P.getProperty(key);
            if (res == null) {
                return false;
            }
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    public static void warning(String s) {
        if (F == null) {
            F = new Frame();
        }
        Warning W = new Warning(F, s, Global.name("warning"), false);
        W.center();
        W.setVisible(true);
    }

    public static boolean isApplet() {
        return pipe_tools.isApplet();
    }

    public static double getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version == null) {
            return 0.0;
        }
        double v = 0.0;
        StringTokenizer t = new StringTokenizer(version, ".");
        if (!t.hasMoreTokens()) {
            return v;
        }
        v = Global.convert(t.nextToken());
        if (t.hasMoreTokens()) {
            v += Global.convert(t.nextToken()) / 10.0;
        } else {
            return v;
        }
        if (t.hasMoreTokens()) {
            v += Global.convert(t.nextToken()) / 100.0;
        }
        return v;
    }

    public static double convert(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e2) {
            return 0.0;
        }
    }

    public static synchronized String getUserDir() {
        String dir = System.getProperty("user.dir");
        return FileName.canonical(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void exit(int i) {
        Object object = ExitBlock;
        synchronized (object) {
            System.exit(i);
        }
    }

    public static String getCDPLocaleNumber(double x, int prec) {
        String s = String.format("%1." + prec + "f", x);
        if (!s.startsWith("-")) {
            s = " " + s;
        }
        return s;
    }

    public static String getLocaleNumber(double x, int prec) {
        String s = String.format("%1." + prec + "f", x);
        s = s.replaceAll("(,+|\\.+)0+$", "");
        s = s.replaceAll("(,+|\\.+)([0-9]*[1-9]+)0+$", "$1$2");
        return s;
    }

    public static String getLocaleNumber(double x, String type) {
        return Global.getLocaleNumber(x, Global.getParameter("digits." + type, 5));
    }

    public static boolean isDecimalWithComma() {
        return String.format("%1.1f", 2.2).contains(",");
    }

    public static void openHomeDirectoryInDesktop() {
        try {
            Desktop.getDesktop().open(new File(Global.getHomeDirectory()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getHomeDirectory() {
        String SP = System.getProperty("file.separator");
        return FileSystemView.getFileSystemView().getDefaultDirectory() + SP + CONFIG + SP;
    }

    public static void deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Global.deleteDirectory(files[i]);
                    files[i].delete();
                    continue;
                }
                files[i].delete();
            }
            path.delete();
        }
    }

    public static void renameOldHomeDirectory() {
        String SP = System.getProperty("file.separator");
        String oldname = FileSystemView.getFileSystemView().getDefaultDirectory() + SP + "carmetal_config";
        String newname = FileSystemView.getFileSystemView().getDefaultDirectory() + SP + CONFIG;
        File newDir = new File(newname);
        File oldDir = new File(oldname);
        if (oldDir.exists()) {
            Global.deleteDirectory(newDir);
            oldDir.renameTo(new File(newname));
            Global.makeWindowConfigFolderInvisible();
        }
    }

    public static void makeWindowConfigFolderInvisible() {
        if (OS.isWindows()) {
            String SP = System.getProperty("file.separator");
            String newname = FileSystemView.getFileSystemView().getDefaultDirectory() + SP + CONFIG;
            String comand = "C:\\WINDOWS\\System32\\ATTRIB.EXE +H " + newname;
            try {
                Runtime.getRuntime().exec(comand);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isLanguage(String lang, String country) {
        String lng = Global.getParameter("language", Locale.getDefault().toString().substring(0, 2));
        String cnt = Global.getParameter("country", Locale.getDefault().getCountry().toString());
        boolean rep = lang.equals(lng);
        rep = rep && country.equals(cnt);
        return rep;
    }

    public static URL getPath(String s) {
        URL myPath = null;
        try {
            myPath = JZirkelCanvas.class.getResource("/" + s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return myPath;
    }

    public static void initObjectsProperties() {
        Global.setParameter("options.segment.color", Global.getParameter("options.segment.color", 1));
        Global.setParameter("options.segment.colortype", Global.getParameter("options.segment.colortype", 0));
        Global.setParameter("options.segment.shownames", Global.getParameter("options.segment.shownames", false));
        Global.setParameter("options.segment.showvalues", Global.getParameter("options.segment.showvalues", false));
        Global.setParameter("options.segment.large", Global.getParameter("options.segment.large", false));
        Global.setParameter("options.segment.bold", Global.getParameter("options.segment.bold", false));
        Global.setParameter("options.line.color", Global.getParameter("options.line.color", 3));
        Global.setParameter("options.line.colortype", Global.getParameter("options.line.colortype", 0));
        Global.setParameter("options.line.shownames", Global.getParameter("options.line.shownames", false));
        Global.setParameter("options.line.showvalues", false);
        Global.setParameter("options.line.large", Global.getParameter("options.line.large", false));
        Global.setParameter("options.line.bold", Global.getParameter("options.line.bold", false));
        Global.setParameter("options.point.color", Global.getParameter("options.point.color", 2));
        Global.setParameter("options.point.colortype", Global.getParameter("options.point.colortype", 0));
        Global.setParameter("options.point.shownames", Global.getParameter("options.point.shownames", false));
        Global.setParameter("options.point.large", Global.getParameter("options.point.large", false));
        Global.setParameter("options.point.bold", Global.getParameter("options.point.bold", false));
        Global.setParameter("options.point.showvalues", Global.getParameter("options.point.showvalues", false));
        Global.setParameter("options.circle.color", Global.getParameter("options.circle.color", 4));
        Global.setParameter("options.circle.colortype", Global.getParameter("options.circle.colortype", 0));
        Global.setParameter("options.circle.shownames", Global.getParameter("options.circle.shownames", false));
        Global.setParameter("options.circle.showvalues", Global.getParameter("options.circle.showvalues", false));
        Global.setParameter("options.circle.filled", Global.getParameter("options.circle.filled", false));
        Global.setParameter("options.circle.solid", Global.getParameter("options.circle.solid", false));
        Global.setParameter("options.circle.large", Global.getParameter("options.circle.large", false));
        Global.setParameter("options.circle.bold", Global.getParameter("options.circle.bold", false));
        Global.setParameter("options.angle.color", Global.getParameter("options.angle.color", 1));
        Global.setParameter("options.angle.colortype", Global.getParameter("options.angle.colortype", 0));
        Global.setParameter("options.angle.shownames", Global.getParameter("options.angle.shownames", false));
        Global.setParameter("options.angle.showvalues", Global.getParameter("options.angle.showvalues", true));
        Global.setParameter("options.angle.filled", Global.getParameter("options.angle.filled", true));
        Global.setParameter("options.angle.solid", Global.getParameter("options.angle.solid", false));
        Global.setParameter("options.angle.large", Global.getParameter("options.angle.large", false));
        Global.setParameter("options.angle.bold", Global.getParameter("options.angle.bold", false));
        Global.setParameter("options.angle.obtuse", Global.getParameter("options.angle.obtuse", false));
        Global.setParameter("options.area.color", Global.getParameter("options.area.color", 1));
        Global.setParameter("options.area.colortype", Global.getParameter("options.area.colortype", 2));
        Global.setParameter("options.area.shownames", Global.getParameter("options.area.shownames", false));
        Global.setParameter("options.area.showvalues", Global.getParameter("options.area.showvalues", false));
        Global.setParameter("options.area.filled", Global.getParameter("options.area.filled", true));
        Global.setParameter("options.area.solid", Global.getParameter("options.area.solid", false));
        Global.setParameter("options.text.color", Global.getParameter("options.text.color", 1));
        Global.setParameter("options.text.colortype", Global.getParameter("options.text.colortype", 1));
        Global.setParameter("options.text.shownames", Global.getParameter("options.text.shownames", true));
        Global.setParameter("options.text.showvalues", Global.getParameter("options.text.showvalues", true));
        Global.setParameter("options.locus.color", Global.getParameter("options.locus.color", 1));
        Global.setParameter("options.locus.colortype", Global.getParameter("options.locus.colortype", 0));
        Global.setParameter("options.locus.shownames", Global.getParameter("options.locus.shownames", false));
        Global.setParameter("options.locus.showvalues", Global.getParameter("options.locus.showvalues", false));
    }

    public static boolean isNewVersion() {
        return isNewVersion;
    }

    public static void initProperties() {
        if (!Global.getParameter("program.version", "").equals(Global.name("program.version"))) {
            Global.setParameter("program.newversion", true);
            Global.setParameter("program.version", Global.name("program.version"));
            Global.setParameter("icons", " new load save back undo delete color type thickness hidden showcolor macro grid comment replay point line segment ray circle fixedcircle parallel plumb circle3 midpoint angle fixedangle move tracker objecttracker hide expression area text quadric runmacro edit animate  info zoom draw function rename ");
            isNewVersion = true;
        }
        Global.setParameter("comment", Global.getParameter("comment", false));
        Global.setParameter("jsdumb", Global.getParameter("jsdumb", true));
        Global.setParameter("iconpath", "/carmetal/rene/zirkel/newicons/");
        Global.setParameter("icontype", "png");
        if (Global.getParameter("options.smallicons", false)) {
            Global.setParameter("iconsize", 24);
        } else {
            Global.setParameter("iconsize", 32);
        }
        Global.setParameter("save.includemacros", true);
        Global.setParameter("load.clearmacros", false);
        Global.setParameter("options.backups", false);
        Global.setParameter("options.visual", true);
        Global.setParameter("options.filedialog", false);
        Global.setParameter("options.restricted", true);
        Global.setParameter("options.smallicons", false);
        Global.setParameter("options.indicate", true);
        Global.setParameter("restricted", false);
        Global.setParameter("showgrid", false);
        Global.setParameter("simplegraphics", false);
        Global.setParameter("quality", true);
        Global.setParameter("export.jar", "CaRMetal.jar");
        Global.setParameter("iconpath", "/carmetal/eric/GUI/icons/palette/");
        Global.setParameter("background.tile", Global.getParameter("background.tile", false));
        if (!Global.haveParameter("options.germanpoints") && Locale.getDefault().getLanguage().equals("de")) {
            Global.setParameter("options.germanpoints", true);
        }
        Global.setPaletteZonePref(Global.Loc("palette.file"));
        Global.setPaletteZonePref(Global.Loc("palette.aspect"));
        Global.setPaletteZonePref(Global.Loc("palette.function"));
        Global.setPaletteZonePref(Global.Loc("palette.test"));
        Global.setPaletteZonePref(Global.Loc("palette.controls"));
        Global.setPaletteZonePref(Global.Loc("palette.grid"));
        Global.setPaletteZonePref(Global.Loc("palette.history"));
        Global.setPaletteZonePref(Global.Loc("palette.colors"));
        Global.setPaletteZonePref(Global.Loc("palette.sizes"));
        Global.setPaletteZonePref(Global.Loc("palette.prec"));
        SliderSnap.init();
        Global.initObjectsProperties();
    }

    private static void setPaletteZonePref(String name) {
        Global.setParameter("hidepalette." + name, Global.getParameter("hidepalette." + name, true));
    }

    public static String Comma_To_Point(String mynum, Construction C, boolean check) {
        if (C == null) {
            return mynum;
        }
        String s = mynum.replace(",", ".");
        s = s.replace(";", ",");
        if (check) {
            try {
                UserFunctionObject V_FONC = new UserFunctionObject(C);
                V_FONC.setExpressions("x y z t", s.replace("invalid", "1"));
                V_FONC.evaluateF(VARS);
            }
            catch (Exception ex) {
                return mynum;
            }
        }
        if (Global.isDecimalWithComma()) {
            return s;
        }
        return mynum;
    }

    public static Color getColor(String s) {
        StringParser p = new StringParser(s);
        p.replace(',', ' ');
        int red = p.parseint();
        int green = p.parseint();
        int blue = p.parseint();
        return new Color(red, green, blue);
    }

    public static synchronized void setJSO(ConstructionObject o) {
        JSO = o;
    }

    public static synchronized ConstructionObject getJSO() {
        return JSO;
    }

    public static synchronized void setJSquit(boolean b2) {
        JSquit = b2;
    }

    public static synchronized boolean getJSquit() {
        return JSquit;
    }

    public static String AppPath() {
        String mypath = System.getProperty("java.class.path");
        mypath = mypath.split(System.getProperty("path.separator"))[0];
        String sep = System.getProperty("file.separator");
        return mypath;
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("copyFiles: Can not find source: " + src.getAbsolutePath() + ".");
        }
        if (!src.canRead()) {
            throw new IOException("copyFiles: No right to source: " + src.getAbsolutePath() + ".");
        }
        if (src.isDirectory()) {
            String[] list;
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("copyFiles: Could not create direcotry: " + dest.getAbsolutePath() + ".");
            }
            for (String element : list = src.list()) {
                File dest1 = new File(dest, element);
                File src1 = new File(src, element);
                Global.copyFiles(src1, dest1);
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                int bytesRead;
                fin = new FileInputStream(src);
                fout = new FileOutputStream(dest);
                while ((bytesRead = fin.read(buffer)) >= 0) {
                    fout.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e2) {
                IOException wrapper = new IOException("copyFiles: Unable to copy file: " + src.getAbsolutePath() + "to" + dest.getAbsolutePath() + ".");
                wrapper.initCause(e2);
                wrapper.setStackTrace(e2.getStackTrace());
                throw wrapper;
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fin.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String inFile, String outFile) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(inFile).getChannel();
            out = new FileOutputStream(outFile).getChannel();
            in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getOpenSaveDirectory() {
        return Global.getParameter("opensavedirectory", "");
    }

    public static void setOpenSaveDirectory(String s) {
        Global.setParameter("opensavedirectory", s);
    }

    public static Rectangle getScreen() {
        return (Rectangle)SCREEN.clone();
    }

    public static int getScreenX() {
        return Global.SCREEN.x;
    }

    public static int getScreenY() {
        return Global.SCREEN.y;
    }

    public static int getScreenW() {
        return Global.SCREEN.width;
    }

    public static int getScreenH() {
        return Global.SCREEN.height;
    }

    public static void DetectDesktopSize() {
        SCREEN = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public static void setLanguage(String lang, String country) {
        block2: {
            try {
                Global.changeGlobalFont(lang);
                Global.setParameter("language", lang);
                Global.setParameter("country", country);
                Global.initBundles();
                pipe_tools.getContent().rebuiltRightPanel();
                MenuBar.reloadMenuBar();
            }
            catch (Exception ex) {
                int rep = JOptionPane.showConfirmDialog(null, "Sorry, but the requested font is not installed for this language.\nThis language will not be selected.\n\nDo you want to download the necessary font ?", "Font not installed", 0);
                if (rep != 0) break block2;
                JBrowserLauncher.openURL(FontURL);
            }
        }
    }

    public static void changeGlobalFont(String lang) throws Exception {
        GlobalFont = "Dialog";
        Font myfont = new Font(GlobalFont, 0, 12);
        if (lang.equals("zh")) {
            String chinesesample = "\u4e00";
            if (myfont.canDisplayUpTo("\u4e00") != -1) {
                if (Global.isFontInstalled("AR PL New Sung")) {
                    GlobalFont = "AR PL New Sung";
                } else {
                    FontURL = ChineseFontURL;
                    throw new Exception();
                }
            }
        }
    }

    public static boolean isFontInstalled(String myfont) {
        Font UF = new Font("this is a weird unknown font", 0, 12);
        Font CF = new Font(myfont, 0, 12);
        boolean notInstalled = UF.getFontName().equals(CF.getFontName());
        return !notInstalled;
    }

    static {
        FontURL = "";
        ChineseFontURL = "http://db-maths.nuxit.net/CaRMetal/fonts/fireflysung.zip";
        Global.makeFonts();
        ObjectsToClearList = new Vector();
        P = new Properties();
        F = null;
        ExitBlock = new Object();
        StartupFiles = new ArrayList();
        isNewVersion = false;
        VARS = new double[]{1.0, 2.0, 3.0, 4.0};
        JSO = null;
        JSquit = false;
        SCREEN = new Rectangle();
    }
}

