/*
 * Decompiled with CFR 0.152.
 */
package carmetal.org.mozilla.javascript;

import carmetal.org.mozilla.javascript.Kit;
import carmetal.org.mozilla.javascript.ObjToIntMap;
import carmetal.org.mozilla.javascript.Parser;
import carmetal.org.mozilla.javascript.ScriptRuntime;
import java.io.IOException;
import java.io.Reader;

class TokenStream {
    private static final int EOF_CHAR = -1;
    private boolean dirtyLine;
    String regExpFlags;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineno;
    private int lineEndChar = -1;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    private int sourceCursor;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;
    private int xmlOpenTagsCount;
    private Parser parser;

    TokenStream(Parser parser, Reader sourceReader, String sourceString, int lineno) {
        this.parser = parser;
        this.lineno = lineno;
        if (sourceReader != null) {
            if (sourceString != null) {
                Kit.codeBug();
            }
            this.sourceReader = sourceReader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (sourceString == null) {
                Kit.codeBug();
            }
            this.sourceString = sourceString;
            this.sourceEnd = sourceString.length();
        }
        this.sourceCursor = 0;
    }

    String tokenToString(int token) {
        return "";
    }

    static boolean isKeyword(String s) {
        return 0 != TokenStream.stringToKeyword(s);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int stringToKeyword(String name) {
        int Id_break = 119;
        int Id_case = 114;
        int Id_continue = 120;
        int Id_default = 115;
        int Id_delete = 31;
        int Id_do = 117;
        int Id_else = 112;
        int Id_export = 109;
        int Id_false = 44;
        int Id_for = 118;
        int Id_function = 108;
        int Id_if = 111;
        int Id_in = 52;
        int Id_let = 152;
        int Id_new = 30;
        int Id_null = 42;
        int Id_return = 4;
        int Id_switch = 113;
        int Id_this = 43;
        int Id_true = 45;
        int Id_typeof = 32;
        int Id_var = 121;
        int Id_void = 125;
        int Id_while = 116;
        int Id_with = 122;
        int Id_yield = 72;
        int Id_abstract = 126;
        int Id_boolean = 126;
        int Id_byte = 126;
        int Id_catch = 123;
        int Id_char = 126;
        int Id_class = 126;
        int Id_const = 153;
        int Id_debugger = 159;
        int Id_double = 126;
        int Id_enum = 126;
        int Id_extends = 126;
        int Id_final = 126;
        int Id_finally = 124;
        int Id_float = 126;
        int Id_goto = 126;
        int Id_implements = 126;
        int Id_import = 110;
        int Id_instanceof = 53;
        int Id_int = 126;
        int Id_interface = 126;
        int Id_long = 126;
        int Id_native = 126;
        int Id_package = 126;
        int Id_private = 126;
        int Id_protected = 126;
        int Id_public = 126;
        int Id_short = 126;
        int Id_static = 126;
        int Id_super = 126;
        int Id_synchronized = 126;
        int Id_throw = 50;
        int Id_throws = 126;
        int Id_transient = 126;
        int Id_try = 80;
        int Id_volatile = 126;
        String s = name;
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 2: {
                char c2 = s.charAt(1);
                if (c2 == 'f') {
                    if (s.charAt(0) != 'i') break;
                    return 111;
                }
                if (c2 == 'n') {
                    if (s.charAt(0) != 'i') break;
                    return 52;
                }
                if (c2 != 'o' || s.charAt(0) != 'd') break;
                return 117;
            }
            case 3: {
                switch (s.charAt(0)) {
                    case 'f': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'o') break;
                        return 118;
                    }
                    case 'i': {
                        if (s.charAt(2) != 't' || s.charAt(1) != 'n') break;
                        return 126;
                    }
                    case 'l': {
                        if (s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                        return 152;
                    }
                    case 'n': {
                        if (s.charAt(2) != 'w' || s.charAt(1) != 'e') break;
                        return 30;
                    }
                    case 't': {
                        if (s.charAt(2) != 'y' || s.charAt(1) != 'r') break;
                        return 80;
                    }
                    case 'v': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'a') break;
                        return 121;
                    }
                }
                break;
            }
            case 4: {
                switch (s.charAt(0)) {
                    case 'b': {
                        X = "byte";
                        id = 126;
                        break;
                    }
                    case 'c': {
                        char c3 = s.charAt(3);
                        if (c3 == 'e') {
                            if (s.charAt(2) != 's' || s.charAt(1) != 'a') break;
                            return 114;
                        }
                        if (c3 != 'r' || s.charAt(2) != 'a' || s.charAt(1) != 'h') break;
                        return 126;
                    }
                    case 'e': {
                        char c4 = s.charAt(3);
                        if (c4 == 'e') {
                            if (s.charAt(2) != 's' || s.charAt(1) != 'l') break;
                            return 112;
                        }
                        if (c4 != 'm' || s.charAt(2) != 'u' || s.charAt(1) != 'n') break;
                        return 126;
                    }
                    case 'g': {
                        X = "goto";
                        id = 126;
                        break;
                    }
                    case 'l': {
                        X = "long";
                        id = 126;
                        break;
                    }
                    case 'n': {
                        X = "null";
                        id = 42;
                        break;
                    }
                    case 't': {
                        char c5 = s.charAt(3);
                        if (c5 == 'e') {
                            if (s.charAt(2) != 'u' || s.charAt(1) != 'r') break;
                            return 45;
                        }
                        if (c5 != 's' || s.charAt(2) != 'i' || s.charAt(1) != 'h') break;
                        return 43;
                    }
                    case 'v': {
                        X = "void";
                        id = 125;
                        break;
                    }
                    case 'w': {
                        X = "with";
                        id = 122;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(2)) {
                    case 'a': {
                        X = "class";
                        id = 126;
                        break;
                    }
                    case 'e': {
                        char c6 = s.charAt(0);
                        if (c6 == 'b') {
                            X = "break";
                            id = 119;
                            break;
                        }
                        if (c6 != 'y') break;
                        X = "yield";
                        id = 72;
                        break;
                    }
                    case 'i': {
                        X = "while";
                        id = 116;
                        break;
                    }
                    case 'l': {
                        X = "false";
                        id = 44;
                        break;
                    }
                    case 'n': {
                        char c7 = s.charAt(0);
                        if (c7 == 'c') {
                            X = "const";
                            id = 153;
                            break;
                        }
                        if (c7 != 'f') break;
                        X = "final";
                        id = 126;
                        break;
                    }
                    case 'o': {
                        char c8 = s.charAt(0);
                        if (c8 == 'f') {
                            X = "float";
                            id = 126;
                            break;
                        }
                        if (c8 != 's') break;
                        X = "short";
                        id = 126;
                        break;
                    }
                    case 'p': {
                        X = "super";
                        id = 126;
                        break;
                    }
                    case 'r': {
                        X = "throw";
                        id = 50;
                        break;
                    }
                    case 't': {
                        X = "catch";
                        id = 123;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "native";
                        id = 126;
                        break;
                    }
                    case 'e': {
                        char c9 = s.charAt(0);
                        if (c9 == 'd') {
                            X = "delete";
                            id = 31;
                            break;
                        }
                        if (c9 != 'r') break;
                        X = "return";
                        id = 4;
                        break;
                    }
                    case 'h': {
                        X = "throws";
                        id = 126;
                        break;
                    }
                    case 'm': {
                        X = "import";
                        id = 110;
                        break;
                    }
                    case 'o': {
                        X = "double";
                        id = 126;
                        break;
                    }
                    case 't': {
                        X = "static";
                        id = 126;
                        break;
                    }
                    case 'u': {
                        X = "public";
                        id = 126;
                        break;
                    }
                    case 'w': {
                        X = "switch";
                        id = 113;
                        break;
                    }
                    case 'x': {
                        X = "export";
                        id = 109;
                        break;
                    }
                    case 'y': {
                        X = "typeof";
                        id = 32;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "package";
                        id = 126;
                        break block0;
                    }
                    case 'e': {
                        X = "default";
                        id = 115;
                        break block0;
                    }
                    case 'i': {
                        X = "finally";
                        id = 124;
                        break block0;
                    }
                    case 'o': {
                        X = "boolean";
                        id = 126;
                        break block0;
                    }
                    case 'r': {
                        X = "private";
                        id = 126;
                        break block0;
                    }
                    case 'x': {
                        X = "extends";
                        id = 126;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "abstract";
                        id = 126;
                        break block0;
                    }
                    case 'c': {
                        X = "continue";
                        id = 120;
                        break block0;
                    }
                    case 'd': {
                        X = "debugger";
                        id = 159;
                        break block0;
                    }
                    case 'f': {
                        X = "function";
                        id = 108;
                        break block0;
                    }
                    case 'v': {
                        X = "volatile";
                        id = 126;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c10 = s.charAt(0);
                if (c10 == 'i') {
                    X = "interface";
                    id = 126;
                    break;
                }
                if (c10 == 'p') {
                    X = "protected";
                    id = 126;
                    break;
                }
                if (c10 != 't') break;
                X = "transient";
                id = 126;
                break;
            }
            case 10: {
                char c11 = s.charAt(1);
                if (c11 == 'm') {
                    X = "implements";
                    id = 126;
                    break;
                }
                if (c11 != 'n') break;
                X = "instanceof";
                id = 53;
                break;
            }
            case 12: {
                X = "synchronized";
                id = 126;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            return 0;
        }
        if (id != 0) return id & 0xFF;
        return 0;
    }

    final int getLineno() {
        return this.lineno;
    }

    final String getString() {
        return this.string;
    }

    final double getNumber() {
        return this.number;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    final int getToken() throws IOException {
        block39: while (true) {
            boolean identifierStart;
            int c2;
            if ((c2 = this.getChar()) == -1) {
                return 0;
            }
            if (c2 == 10) {
                this.dirtyLine = false;
                return 1;
            }
            if (TokenStream.isJSSpace(c2)) continue;
            if (c2 != 45) {
                this.dirtyLine = true;
            }
            if (c2 == 64) {
                return 146;
            }
            boolean isUnicodeEscapeStart = false;
            if (c2 == 92) {
                c2 = this.getChar();
                if (c2 == 117) {
                    identifierStart = true;
                    isUnicodeEscapeStart = true;
                    this.stringBufferTop = 0;
                } else {
                    identifierStart = false;
                    this.ungetChar(c2);
                    c2 = 92;
                }
            } else {
                identifierStart = Character.isJavaIdentifierStart((char)c2);
                if (identifierStart) {
                    this.stringBufferTop = 0;
                    this.addToString(c2);
                }
            }
            if (identifierStart) {
                int result;
                boolean containsEscape = isUnicodeEscapeStart;
                while (true) {
                    if (isUnicodeEscapeStart) {
                        int escapeVal = 0;
                        for (int i = 0; i != 4 && (escapeVal = Kit.xDigitToInt(c2 = this.getChar(), escapeVal)) >= 0; ++i) {
                        }
                        if (escapeVal < 0) {
                            this.parser.addError("msg.invalid.escape");
                            return -1;
                        }
                        this.addToString(escapeVal);
                        isUnicodeEscapeStart = false;
                        continue;
                    }
                    c2 = this.getChar();
                    if (c2 == 92) {
                        c2 = this.getChar();
                        if (c2 == 117) {
                            isUnicodeEscapeStart = true;
                            containsEscape = true;
                            continue;
                        }
                        this.parser.addError("msg.illegal.character");
                        return -1;
                    }
                    if (c2 == -1 || !Character.isJavaIdentifierPart((char)c2)) break;
                    this.addToString(c2);
                }
                this.ungetChar(c2);
                String str = this.getStringFromBuffer();
                if (!containsEscape && (result = TokenStream.stringToKeyword(str)) != 0) {
                    if ((result == 152 || result == 72) && this.parser.compilerEnv.getLanguageVersion() < 170) {
                        this.string = result == 152 ? "let" : "yield";
                        result = 39;
                    }
                    if (result != 126) {
                        return result;
                    }
                    if (!this.parser.compilerEnv.isReservedKeywordAsIdentifier()) {
                        return result;
                    }
                    this.parser.addWarning("msg.reserved.keyword", str);
                }
                this.string = (String)this.allStrings.intern(str);
                return 39;
            }
            if (TokenStream.isDigit(c2) || c2 == 46 && TokenStream.isDigit(this.peekChar())) {
                double dval;
                this.stringBufferTop = 0;
                int base = 10;
                if (c2 == 48) {
                    c2 = this.getChar();
                    if (c2 == 120 || c2 == 88) {
                        base = 16;
                        c2 = this.getChar();
                    } else if (TokenStream.isDigit(c2)) {
                        base = 8;
                    } else {
                        this.addToString(48);
                    }
                }
                if (base == 16) {
                    while (0 <= Kit.xDigitToInt(c2, 0)) {
                        this.addToString(c2);
                        c2 = this.getChar();
                    }
                } else {
                    while (48 <= c2 && c2 <= 57) {
                        if (base == 8 && c2 >= 56) {
                            this.parser.addWarning("msg.bad.octal.literal", c2 == 56 ? "8" : "9");
                            base = 10;
                        }
                        this.addToString(c2);
                        c2 = this.getChar();
                    }
                }
                boolean isInteger = true;
                if (base == 10 && (c2 == 46 || c2 == 101 || c2 == 69)) {
                    isInteger = false;
                    if (c2 == 46) {
                        do {
                            this.addToString(c2);
                        } while (TokenStream.isDigit(c2 = this.getChar()));
                    }
                    if (c2 == 101 || c2 == 69) {
                        this.addToString(c2);
                        c2 = this.getChar();
                        if (c2 == 43 || c2 == 45) {
                            this.addToString(c2);
                            c2 = this.getChar();
                        }
                        if (!TokenStream.isDigit(c2)) {
                            this.parser.addError("msg.missing.exponent");
                            return -1;
                        }
                        do {
                            this.addToString(c2);
                        } while (TokenStream.isDigit(c2 = this.getChar()));
                    }
                }
                this.ungetChar(c2);
                String numString = this.getStringFromBuffer();
                if (base == 10 && !isInteger) {
                    try {
                        dval = Double.valueOf(numString);
                    }
                    catch (NumberFormatException ex) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                } else {
                    dval = ScriptRuntime.stringToNumber(numString, 0, base);
                }
                this.number = dval;
                return 40;
            }
            if (c2 == 34 || c2 == 39) {
                int quoteChar = c2;
                this.stringBufferTop = 0;
                c2 = this.getChar();
                block46: while (c2 != quoteChar) {
                    if (c2 == 10 || c2 == -1) {
                        this.ungetChar(c2);
                        this.parser.addError("msg.unterminated.string.lit");
                        return -1;
                    }
                    if (c2 == 92) {
                        c2 = this.getChar();
                        switch (c2) {
                            case 98: {
                                c2 = 8;
                                break;
                            }
                            case 102: {
                                c2 = 12;
                                break;
                            }
                            case 110: {
                                c2 = 10;
                                break;
                            }
                            case 114: {
                                c2 = 13;
                                break;
                            }
                            case 116: {
                                c2 = 9;
                                break;
                            }
                            case 118: {
                                c2 = 11;
                                break;
                            }
                            case 117: {
                                int escapeStart = this.stringBufferTop;
                                this.addToString(117);
                                int escapeVal = 0;
                                for (int i = 0; i != 4; ++i) {
                                    c2 = this.getChar();
                                    escapeVal = Kit.xDigitToInt(c2, escapeVal);
                                    if (escapeVal < 0) continue block46;
                                    this.addToString(c2);
                                }
                                this.stringBufferTop = escapeStart;
                                c2 = escapeVal;
                                break;
                            }
                            case 120: {
                                c2 = this.getChar();
                                int escapeVal = Kit.xDigitToInt(c2, 0);
                                if (escapeVal < 0) {
                                    this.addToString(120);
                                    continue block46;
                                }
                                int c1 = c2;
                                c2 = this.getChar();
                                escapeVal = Kit.xDigitToInt(c2, escapeVal);
                                if (escapeVal < 0) {
                                    this.addToString(120);
                                    this.addToString(c1);
                                    continue block46;
                                }
                                c2 = escapeVal;
                                break;
                            }
                            case 10: {
                                c2 = this.getChar();
                                continue block46;
                            }
                            default: {
                                if (48 > c2 || c2 >= 56) break;
                                int val = c2 - 48;
                                c2 = this.getChar();
                                if (48 <= c2 && c2 < 56) {
                                    val = 8 * val + c2 - 48;
                                    c2 = this.getChar();
                                    if (48 <= c2 && c2 < 56 && val <= 31) {
                                        val = 8 * val + c2 - 48;
                                        c2 = this.getChar();
                                    }
                                }
                                this.ungetChar(c2);
                                c2 = val;
                            }
                        }
                    }
                    this.addToString(c2);
                    c2 = this.getChar();
                }
                String str = this.getStringFromBuffer();
                this.string = (String)this.allStrings.intern(str);
                return 41;
            }
            switch (c2) {
                case 59: {
                    return 81;
                }
                case 91: {
                    return 82;
                }
                case 93: {
                    return 83;
                }
                case 123: {
                    return 84;
                }
                case 125: {
                    return 85;
                }
                case 40: {
                    return 86;
                }
                case 41: {
                    return 87;
                }
                case 44: {
                    return 88;
                }
                case 63: {
                    return 101;
                }
                case 58: {
                    if (this.matchChar(58)) {
                        return 143;
                    }
                    return 102;
                }
                case 46: {
                    if (this.matchChar(46)) {
                        return 142;
                    }
                    if (this.matchChar(40)) {
                        return 145;
                    }
                    return 107;
                }
                case 124: {
                    if (this.matchChar(124)) {
                        return 103;
                    }
                    if (this.matchChar(61)) {
                        return 90;
                    }
                    return 9;
                }
                case 94: {
                    if (this.matchChar(61)) {
                        return 91;
                    }
                    return 10;
                }
                case 38: {
                    if (this.matchChar(38)) {
                        return 104;
                    }
                    if (this.matchChar(61)) {
                        return 92;
                    }
                    return 11;
                }
                case 61: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 46;
                        }
                        return 12;
                    }
                    return 89;
                }
                case 33: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 47;
                        }
                        return 13;
                    }
                    return 26;
                }
                case 60: {
                    if (this.matchChar(33)) {
                        if (this.matchChar(45)) {
                            if (this.matchChar(45)) {
                                this.skipLine();
                                continue block39;
                            }
                            this.ungetCharIgnoreLineEnd(45);
                        }
                        this.ungetCharIgnoreLineEnd(33);
                    }
                    if (this.matchChar(60)) {
                        if (this.matchChar(61)) {
                            return 93;
                        }
                        return 18;
                    }
                    if (this.matchChar(61)) {
                        return 15;
                    }
                    return 14;
                }
                case 62: {
                    if (this.matchChar(62)) {
                        if (this.matchChar(62)) {
                            if (this.matchChar(61)) {
                                return 95;
                            }
                            return 20;
                        }
                        if (this.matchChar(61)) {
                            return 94;
                        }
                        return 19;
                    }
                    if (this.matchChar(61)) {
                        return 17;
                    }
                    return 16;
                }
                case 42: {
                    if (this.matchChar(61)) {
                        return 98;
                    }
                    return 23;
                }
                case 47: {
                    if (this.matchChar(47)) {
                        this.skipLine();
                        continue block39;
                    }
                    if (this.matchChar(42)) {
                        boolean lookForSlash = false;
                        while (true) {
                            if ((c2 = this.getChar()) == -1) {
                                this.parser.addError("msg.unterminated.comment");
                                return -1;
                            }
                            if (c2 == 42) {
                                lookForSlash = true;
                                continue;
                            }
                            if (c2 == 47) {
                                if (!lookForSlash) continue;
                                continue block39;
                            }
                            lookForSlash = false;
                        }
                    }
                    if (this.matchChar(61)) {
                        return 99;
                    }
                    return 24;
                }
                case 37: {
                    if (this.matchChar(61)) {
                        return 100;
                    }
                    return 25;
                }
                case 126: {
                    return 27;
                }
                case 43: {
                    if (this.matchChar(61)) {
                        return 96;
                    }
                    if (this.matchChar(43)) {
                        return 105;
                    }
                    return 21;
                }
                case 45: {
                    if (this.matchChar(61)) {
                        c2 = 97;
                    } else if (this.matchChar(45)) {
                        if (!this.dirtyLine && this.matchChar(62)) {
                            this.skipLine();
                            continue block39;
                        }
                        c2 = 106;
                    } else {
                        c2 = 22;
                    }
                    this.dirtyLine = true;
                    return c2;
                }
            }
            break;
        }
        this.parser.addError("msg.illegal.character");
        return -1;
    }

    private static boolean isAlpha(int c2) {
        if (c2 <= 90) {
            return 65 <= c2;
        }
        return 97 <= c2 && c2 <= 122;
    }

    static boolean isDigit(int c2) {
        return 48 <= c2 && c2 <= 57;
    }

    static boolean isJSSpace(int c2) {
        if (c2 <= 127) {
            return c2 == 32 || c2 == 9 || c2 == 12 || c2 == 11;
        }
        return c2 == 160 || Character.getType((char)c2) == 12;
    }

    private static boolean isJSFormatChar(int c2) {
        return c2 > 127 && Character.getType((char)c2) == 16;
    }

    void readRegExp(int startToken) throws IOException {
        int c2;
        this.stringBufferTop = 0;
        if (startToken == 99) {
            this.addToString(61);
        } else if (startToken != 24) {
            Kit.codeBug();
        }
        boolean inCharSet = false;
        while ((c2 = this.getChar()) != 47 || inCharSet) {
            if (c2 == 10 || c2 == -1) {
                this.ungetChar(c2);
                throw this.parser.reportError("msg.unterminated.re.lit");
            }
            if (c2 == 92) {
                this.addToString(c2);
                c2 = this.getChar();
            } else if (c2 == 91) {
                inCharSet = true;
            } else if (c2 == 93) {
                inCharSet = false;
            }
            this.addToString(c2);
        }
        int reEnd = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (!this.matchChar(109)) break;
            this.addToString(109);
        }
        if (TokenStream.isAlpha(this.peekChar())) {
            throw this.parser.reportError("msg.invalid.re.flag");
        }
        this.string = new String(this.stringBuffer, 0, reEnd);
        this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
    }

    boolean isXMLAttribute() {
        return this.xmlIsAttribute;
    }

    int getFirstXMLToken() throws IOException {
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        this.ungetChar(60);
        return this.getNextXMLToken();
    }

    int getNextXMLToken() throws IOException {
        this.stringBufferTop = 0;
        int c2 = this.getChar();
        while (c2 != -1) {
            if (this.xmlIsTagContent) {
                switch (c2) {
                    case 62: {
                        this.addToString(c2);
                        this.xmlIsTagContent = false;
                        this.xmlIsAttribute = false;
                        break;
                    }
                    case 47: {
                        this.addToString(c2);
                        if (this.peekChar() != 62) break;
                        c2 = this.getChar();
                        this.addToString(c2);
                        this.xmlIsTagContent = false;
                        --this.xmlOpenTagsCount;
                        break;
                    }
                    case 123: {
                        this.ungetChar(c2);
                        this.string = this.getStringFromBuffer();
                        return 144;
                    }
                    case 34: 
                    case 39: {
                        this.addToString(c2);
                        if (this.readQuotedString(c2)) break;
                        return -1;
                    }
                    case 61: {
                        this.addToString(c2);
                        this.xmlIsAttribute = true;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.addToString(c2);
                        break;
                    }
                    default: {
                        this.addToString(c2);
                        this.xmlIsAttribute = false;
                    }
                }
                if (!this.xmlIsTagContent && this.xmlOpenTagsCount == 0) {
                    this.string = this.getStringFromBuffer();
                    return 147;
                }
            } else {
                block8 : switch (c2) {
                    case 60: {
                        this.addToString(c2);
                        c2 = this.peekChar();
                        switch (c2) {
                            case 33: {
                                c2 = this.getChar();
                                this.addToString(c2);
                                c2 = this.peekChar();
                                switch (c2) {
                                    case 45: {
                                        c2 = this.getChar();
                                        this.addToString(c2);
                                        c2 = this.getChar();
                                        if (c2 == 45) {
                                            this.addToString(c2);
                                            if (this.readXmlComment()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    case 91: {
                                        c2 = this.getChar();
                                        this.addToString(c2);
                                        if (this.getChar() == 67 && this.getChar() == 68 && this.getChar() == 65 && this.getChar() == 84 && this.getChar() == 65 && this.getChar() == 91) {
                                            this.addToString(67);
                                            this.addToString(68);
                                            this.addToString(65);
                                            this.addToString(84);
                                            this.addToString(65);
                                            this.addToString(91);
                                            if (this.readCDATA()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    default: {
                                        if (this.readEntity()) break block8;
                                        return -1;
                                    }
                                }
                            }
                            case 63: {
                                c2 = this.getChar();
                                this.addToString(c2);
                                if (this.readPI()) break block8;
                                return -1;
                            }
                            case 47: {
                                c2 = this.getChar();
                                this.addToString(c2);
                                if (this.xmlOpenTagsCount == 0) {
                                    this.stringBufferTop = 0;
                                    this.string = null;
                                    this.parser.addError("msg.XML.bad.form");
                                    return -1;
                                }
                                this.xmlIsTagContent = true;
                                --this.xmlOpenTagsCount;
                                break;
                            }
                            default: {
                                this.xmlIsTagContent = true;
                                ++this.xmlOpenTagsCount;
                                break;
                            }
                        }
                        break;
                    }
                    case 123: {
                        this.ungetChar(c2);
                        this.string = this.getStringFromBuffer();
                        return 144;
                    }
                    default: {
                        this.addToString(c2);
                    }
                }
            }
            c2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return -1;
    }

    private boolean readQuotedString(int quote) throws IOException {
        int c2 = this.getChar();
        while (c2 != -1) {
            this.addToString(c2);
            if (c2 == quote) {
                return true;
            }
            c2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readXmlComment() throws IOException {
        int c2 = this.getChar();
        while (c2 != -1) {
            this.addToString(c2);
            if (c2 == 45 && this.peekChar() == 45) {
                c2 = this.getChar();
                this.addToString(c2);
                if (this.peekChar() != 62) continue;
                c2 = this.getChar();
                this.addToString(c2);
                return true;
            }
            c2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readCDATA() throws IOException {
        int c2 = this.getChar();
        while (c2 != -1) {
            this.addToString(c2);
            if (c2 == 93 && this.peekChar() == 93) {
                c2 = this.getChar();
                this.addToString(c2);
                if (this.peekChar() != 62) continue;
                c2 = this.getChar();
                this.addToString(c2);
                return true;
            }
            c2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readEntity() throws IOException {
        int declTags = 1;
        int c2 = this.getChar();
        while (c2 != -1) {
            this.addToString(c2);
            switch (c2) {
                case 60: {
                    ++declTags;
                    break;
                }
                case 62: {
                    if (--declTags != 0) break;
                    return true;
                }
            }
            c2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readPI() throws IOException {
        int c2 = this.getChar();
        while (c2 != -1) {
            this.addToString(c2);
            if (c2 == 63 && this.peekChar() == 62) {
                c2 = this.getChar();
                this.addToString(c2);
                return true;
            }
            c2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c2) {
        int N = this.stringBufferTop;
        if (N == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, N);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[N] = (char)c2;
        this.stringBufferTop = N + 1;
    }

    private void ungetChar(int c2) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = c2;
    }

    private boolean matchChar(int test) throws IOException {
        int c2 = this.getCharIgnoreLineEnd();
        if (c2 == test) {
            return true;
        }
        this.ungetCharIgnoreLineEnd(c2);
        return false;
    }

    private int peekChar() throws IOException {
        int c2 = this.getChar();
        this.ungetChar(c2);
        return c2;
    }

    private int getChar() throws IOException {
        int c2;
        block11: {
            if (this.ungetCursor != 0) {
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    c2 = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    c2 = this.sourceBuffer[this.sourceCursor++];
                }
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && c2 == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (c2 <= 127) {
                    if (c2 == 10 || c2 == 13) {
                        this.lineEndChar = c2;
                        c2 = 10;
                    }
                    break block11;
                }
                if (!TokenStream.isJSFormatChar(c2)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(c2)) {
                this.lineEndChar = c2;
                c2 = 10;
            }
        }
        return c2;
    }

    private int getCharIgnoreLineEnd() throws IOException {
        int c2;
        block8: {
            if (this.ungetCursor != 0) {
                return this.ungetBuffer[--this.ungetCursor];
            }
            do {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    c2 = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    c2 = this.sourceBuffer[this.sourceCursor++];
                }
                if (c2 > 127) continue;
                if (c2 == 10 || c2 == 13) {
                    this.lineEndChar = c2;
                    c2 = 10;
                }
                break block8;
            } while (TokenStream.isJSFormatChar(c2));
            if (ScriptRuntime.isJSLineTerminator(c2)) {
                this.lineEndChar = c2;
                c2 = 10;
            }
        }
        return c2;
    }

    private void ungetCharIgnoreLineEnd(int c2) {
        this.ungetBuffer[this.ungetCursor++] = c2;
    }

    private void skipLine() throws IOException {
        int c2;
        while ((c2 = this.getChar()) != -1 && c2 != 10) {
        }
        this.ungetChar(c2);
    }

    final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    final String getLine() {
        if (this.sourceString != null) {
            int lineEnd;
            if (this.lineEndChar >= 0) {
                --lineEnd;
            } else {
                char c2;
                for (lineEnd = this.sourceCursor; lineEnd != this.sourceEnd && !ScriptRuntime.isJSLineTerminator(c2 = this.sourceString.charAt(lineEnd)); ++lineEnd) {
                }
            }
            return this.sourceString.substring(this.lineStart, lineEnd);
        }
        int lineLength = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --lineLength;
        } else {
            while (true) {
                char c3;
                int i;
                if ((i = this.lineStart + lineLength) == this.sourceEnd) {
                    try {
                        if (!this.fillSourceBuffer()) {
                        }
                    }
                    catch (IOException ioe) {}
                    break;
                    i = this.lineStart + lineLength;
                }
                if (ScriptRuntime.isJSLineTerminator(c3 = this.sourceBuffer[i])) break;
                ++lineLength;
            }
        }
        return new String(this.sourceBuffer, this.lineStart, lineLength);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] tmp = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, tmp, 0, this.sourceEnd);
                this.sourceBuffer = tmp;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }
}

