/*
 * Decompiled with CFR 0.152.
 */
package carmetal.org.mozilla.javascript;

import carmetal.org.mozilla.javascript.Context;
import carmetal.org.mozilla.javascript.Evaluator;
import carmetal.org.mozilla.javascript.SecurityUtilities;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;

public abstract class RhinoException
extends RuntimeException {
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;
    Object interpreterStackInfo;
    int[] interpreterLineData;

    RhinoException() {
        Evaluator e2 = Context.createInterpreter();
        if (e2 != null) {
            e2.captureStackInfo(this);
        }
    }

    RhinoException(String details) {
        super(details);
        Evaluator e2 = Context.createInterpreter();
        if (e2 != null) {
            e2.captureStackInfo(this);
        }
    }

    @Override
    public final String getMessage() {
        String details = this.details();
        if (this.sourceName == null || this.lineNumber <= 0) {
            return details;
        }
        StringBuffer buf = new StringBuffer(details);
        buf.append(" (");
        if (this.sourceName != null) {
            buf.append(this.sourceName);
        }
        if (this.lineNumber > 0) {
            buf.append('#');
            buf.append(this.lineNumber);
        }
        buf.append(')');
        return buf.toString();
    }

    public String details() {
        return super.getMessage();
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final void initSourceName(String sourceName) {
        if (sourceName == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceName != null) {
            throw new IllegalStateException();
        }
        this.sourceName = sourceName;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void initLineNumber(int lineNumber) {
        if (lineNumber <= 0) {
            throw new IllegalArgumentException(String.valueOf(lineNumber));
        }
        if (this.lineNumber > 0) {
            throw new IllegalStateException();
        }
        this.lineNumber = lineNumber;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final void initColumnNumber(int columnNumber) {
        if (columnNumber <= 0) {
            throw new IllegalArgumentException(String.valueOf(columnNumber));
        }
        if (this.columnNumber > 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = columnNumber;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    public final void initLineSource(String lineSource) {
        if (lineSource == null) {
            throw new IllegalArgumentException();
        }
        if (this.lineSource != null) {
            throw new IllegalStateException();
        }
        this.lineSource = lineSource;
    }

    final void recordErrorOrigin(String sourceName, int lineNumber, String lineSource, int columnNumber) {
        if (lineNumber == -1) {
            lineNumber = 0;
        }
        if (sourceName != null) {
            this.initSourceName(sourceName);
        }
        if (lineNumber != 0) {
            this.initLineNumber(lineNumber);
        }
        if (lineSource != null) {
            this.initLineSource(lineSource);
        }
        if (columnNumber != 0) {
            this.initColumnNumber(columnNumber);
        }
    }

    private String generateStackTrace() {
        CharArrayWriter writer = new CharArrayWriter();
        super.printStackTrace(new PrintWriter(writer));
        String origStackTrace = writer.toString();
        Evaluator e2 = Context.createInterpreter();
        if (e2 != null) {
            return e2.getPatchedStack(this, origStackTrace);
        }
        return null;
    }

    public String getScriptStackTrace() {
        return this.getScriptStackTrace(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".js");
            }
        });
    }

    public String getScriptStackTrace(FilenameFilter filter) {
        List<String> interpreterStack = null;
        Evaluator interpreter = Context.createInterpreter();
        if (interpreter != null) {
            interpreterStack = interpreter.getScriptStack(this);
        }
        int interpreterStackIndex = 0;
        StringBuffer buffer = new StringBuffer();
        String lineSeparator = SecurityUtilities.getSystemProperty("line.separator");
        StackTraceElement[] stack = this.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement e2 = stack[i];
            String name = e2.getFileName();
            if (e2.getLineNumber() > -1 && name != null && filter.accept(null, name)) {
                buffer.append("\tat ");
                buffer.append(e2.getFileName());
                buffer.append(':');
                buffer.append(e2.getLineNumber());
                buffer.append(lineSeparator);
                continue;
            }
            if (interpreterStack == null || interpreterStack.size() <= interpreterStackIndex || !"carmetal.org.mozilla.javascript.Interpreter".equals(e2.getClassName()) || !"interpretLoop".equals(e2.getMethodName())) continue;
            buffer.append(interpreterStack.get(interpreterStackIndex++));
        }
        return buffer.toString();
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(s);
        } else {
            s.print(this.generateStackTrace());
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(s);
        } else {
            s.print(this.generateStackTrace());
        }
    }
}

