/*
 * Decompiled with CFR 0.152.
 */
package carmetal.org.mozilla.javascript;

import carmetal.org.mozilla.javascript.IdScriptableObject;
import carmetal.org.mozilla.javascript.Kit;
import carmetal.org.mozilla.javascript.NativeCall;
import carmetal.org.mozilla.javascript.NativeFunction;
import carmetal.org.mozilla.javascript.Scriptable;
import carmetal.org.mozilla.javascript.ScriptableObject;
import carmetal.org.mozilla.javascript.UniqueTag;

final class Arguments
extends IdScriptableObject {
    static final long serialVersionUID = 4275508002492040609L;
    private static final int Id_callee = 1;
    private static final int Id_length = 2;
    private static final int Id_caller = 3;
    private static final int MAX_INSTANCE_ID = 3;
    private Object callerObj;
    private Object calleeObj;
    private Object lengthObj;
    private NativeCall activation;
    private Object[] args;

    public Arguments(NativeCall activation) {
        this.activation = activation;
        Scriptable parent = activation.getParentScope();
        this.setParentScope(parent);
        this.setPrototype(ScriptableObject.getObjectPrototype(parent));
        this.args = activation.originalArgs;
        this.lengthObj = new Integer(this.args.length);
        NativeFunction f2 = activation.function;
        this.calleeObj = f2;
        int version = f2.getLanguageVersion();
        this.callerObj = version <= 130 && version != 0 ? null : NOT_FOUND;
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (0 <= index && index < this.args.length && this.args[index] != NOT_FOUND) {
            return true;
        }
        return super.has(index, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        Object value;
        if (0 <= index && index < this.args.length && (value = this.args[index]) != NOT_FOUND) {
            NativeFunction f2;
            String argName;
            if (this.sharedWithActivation(index) && (value = this.activation.get(argName = (f2 = this.activation.function).getParamOrVarName(index), (Scriptable)this.activation)) == NOT_FOUND) {
                Kit.codeBug();
            }
            return value;
        }
        return super.get(index, start);
    }

    private boolean sharedWithActivation(int index) {
        NativeFunction f2 = this.activation.function;
        int definedCount = f2.getParamCount();
        if (index < definedCount) {
            if (index < definedCount - 1) {
                String argName = f2.getParamOrVarName(index);
                for (int i = index + 1; i < definedCount; ++i) {
                    if (!argName.equals(f2.getParamOrVarName(i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int index, Scriptable start, Object value) {
        if (0 <= index && index < this.args.length && this.args[index] != NOT_FOUND) {
            if (this.sharedWithActivation(index)) {
                String argName = this.activation.function.getParamOrVarName(index);
                this.activation.put(argName, (Scriptable)this.activation, value);
                return;
            }
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[index] != NOT_FOUND) {
                    if (this.args == this.activation.originalArgs) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[index] = value;
                    return;
                }
            }
        }
        super.put(index, start, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int index) {
        if (0 <= index && index < this.args.length) {
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[index] != NOT_FOUND) {
                    if (this.args == this.activation.originalArgs) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[index] = NOT_FOUND;
                    return;
                }
            }
        }
        super.delete(index);
    }

    @Override
    protected int getMaxInstanceId() {
        return 3;
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        int attr;
        int id = 0;
        String X = null;
        if (s.length() == 6) {
            char c2 = s.charAt(5);
            if (c2 == 'e') {
                X = "callee";
                id = 1;
            } else if (c2 == 'h') {
                X = "length";
                id = 2;
            } else if (c2 == 'r') {
                X = "caller";
                id = 3;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        switch (id) {
            case 1: 
            case 2: 
            case 3: {
                attr = 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Arguments.instanceIdInfo(attr, id);
    }

    @Override
    protected String getInstanceIdName(int id) {
        switch (id) {
            case 1: {
                return "callee";
            }
            case 2: {
                return "length";
            }
            case 3: {
                return "caller";
            }
        }
        return null;
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        switch (id) {
            case 1: {
                return this.calleeObj;
            }
            case 2: {
                return this.lengthObj;
            }
            case 3: {
                NativeCall caller;
                Object value = this.callerObj;
                if (value == UniqueTag.NULL_VALUE) {
                    value = null;
                } else if (value == null && (caller = this.activation.parentActivationCall) != null) {
                    value = caller.get("arguments", (Scriptable)caller);
                }
                return value;
            }
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected void setInstanceIdValue(int id, Object value) {
        switch (id) {
            case 1: {
                this.calleeObj = value;
                return;
            }
            case 2: {
                this.lengthObj = value;
                return;
            }
            case 3: {
                this.callerObj = value != null ? value : UniqueTag.NULL_VALUE;
                return;
            }
        }
        super.setInstanceIdValue(id, value);
    }

    @Override
    Object[] getIds(boolean getAll) {
        Object[] ids = super.getIds(getAll);
        if (getAll && this.args.length != 0) {
            boolean[] present = null;
            int extraCount = this.args.length;
            for (int i = 0; i != ids.length; ++i) {
                int index;
                Object id = ids[i];
                if (!(id instanceof Integer) || 0 > (index = ((Integer)id).intValue()) || index >= this.args.length) continue;
                if (present == null) {
                    present = new boolean[this.args.length];
                }
                if (present[index] != false) continue;
                present[index] = true;
                --extraCount;
            }
            if (extraCount != 0) {
                Object[] tmp = new Object[extraCount + ids.length];
                System.arraycopy(ids, 0, tmp, extraCount, ids.length);
                ids = tmp;
                int offset = 0;
                for (int i = 0; i != this.args.length; ++i) {
                    if (present != null && present[i]) continue;
                    ids[offset] = new Integer(i);
                    ++offset;
                }
                if (offset != extraCount) {
                    Kit.codeBug();
                }
            }
        }
        return ids;
    }
}

