/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.objects.AxisObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.FunctionObject;
import carmetal.objects.IntersectionObject;
import carmetal.objects.PointonObject;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.expression.Secant;

public class PointonObjectIntersectionObject
extends IntersectionObject {
    public double Eps = 1.0E-5;
    private boolean xAxisFunctionIntersection = false;
    private boolean yAxisFunctionIntersection = false;
    private FunctionObject F = null;
    double x;
    double y;
    double x1;
    double y1;

    public PointonObjectIntersectionObject(Construction c2, ConstructionObject p1, ConstructionObject p2) {
        super(c2, p1, p2);
        if (p1 instanceof AxisObject && p2 instanceof FunctionObject) {
            this.F = (FunctionObject)p2;
            if (this.F.getEX().toString().equals("x")) {
                AxisObject ax = (AxisObject)p1;
                if (ax.DX == 1.0) {
                    this.xAxisFunctionIntersection = true;
                } else {
                    this.yAxisFunctionIntersection = true;
                }
            }
        } else if (p2 instanceof AxisObject && p1 instanceof FunctionObject) {
            this.F = (FunctionObject)p1;
            if (this.F.getEX().toString().equals("x")) {
                AxisObject ax = (AxisObject)p2;
                if (ax.DX == 1.0) {
                    this.xAxisFunctionIntersection = true;
                } else {
                    this.yAxisFunctionIntersection = true;
                }
            }
        }
    }

    @Override
    public void validate(double x, double y) {
        this.setXY(x, y);
        this.validate();
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("first", this.P1.getName());
        xml.printArg("second", this.P2.getName());
        xml.printArg("x", "" + this.getX());
        xml.printArg("y", "" + this.getY());
        if (this.getAway() != null) {
            if (this.StayAway) {
                xml.printArg("awayfrom", this.getAway().getName());
            } else {
                xml.printArg("closeto", this.getAway().getName());
            }
        }
        this.printType(xml);
        if (!this.Restricted) {
            xml.printArg("valid", "true");
        }
    }

    @Override
    public void validate() {
        this.Valid = this.P1.valid() && this.P2.valid();
        if (!this.Valid) {
            return;
        }
        if (this.yAxisFunctionIntersection) {
            try {
                this.setXY(0.0, this.F.evaluateF(0.0));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.xAxisFunctionIntersection) {
            try {
                double xn = 0.0;
                for (int i = 0; i < 5; ++i) {
                    double distold = this.projectOnce();
                    if (!this.Valid) {
                        return;
                    }
                    double dist1 = this.projectOnce();
                    if (dist1 >= distold && dist1 < this.Eps) break;
                    distold = dist1;
                    double a2 = this.x1 - this.x;
                    double b2 = this.y1 - this.y;
                    double s = Math.max(Math.abs(a2), Math.abs(b2));
                    if (Math.abs(s) > 1.0E-13) {
                        a2 /= s;
                    }
                    b2 /= s;
                    double c2 = this.X - this.x1;
                    double d2 = this.Y - this.y1;
                    s = Math.max(Math.abs(c2), Math.abs(d2));
                    if (Math.abs(s) > 1.0E-13) {
                        c2 /= s;
                    }
                    double e2 = a2 * this.x1 + b2 * this.y1;
                    double f2 = c2 * this.X + (d2 /= s) * this.Y;
                    double det = a2 * d2 - c2 * b2;
                    if (!(Math.abs(det) > 1.0E-13)) continue;
                    xn = (e2 * d2 - f2 * b2) / det;
                    double dist2 = this.projectOnce();
                    if (!(dist2 < dist1)) continue;
                    distold = dist2;
                }
                this.setXY(Secant.compute(this.F, xn - 0.1, xn + 0.1, 1.0E-10), 0.0);
                return;
            }
            catch (Exception xn) {
                // empty catch block
            }
        }
        double distold = this.projectOnce();
        if (!this.Valid) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            double dist1 = this.projectOnce();
            if (dist1 >= distold && dist1 < this.Eps) {
                return;
            }
            distold = dist1;
            double a3 = this.x1 - this.x;
            double b3 = this.y1 - this.y;
            double s = Math.max(Math.abs(a3), Math.abs(b3));
            if (Math.abs(s) > 1.0E-13) {
                a3 /= s;
            }
            b3 /= s;
            double c3 = this.X - this.x1;
            double d3 = this.Y - this.y1;
            s = Math.max(Math.abs(c3), Math.abs(d3));
            if (Math.abs(s) > 1.0E-13) {
                c3 /= s;
            }
            double e3 = a3 * this.x1 + b3 * this.y1;
            double f3 = c3 * this.X + (d3 /= s) * this.Y;
            double det = a3 * d3 - c3 * b3;
            if (!(Math.abs(det) > 1.0E-13)) continue;
            double xn = (e3 * d3 - f3 * b3) / det;
            double yn = (a3 * f3 - c3 * e3) / det;
            double xold = this.X;
            double yold = this.Y;
            this.setXY(xn, yn);
            double dist2 = this.projectOnce();
            if (dist2 > dist1) {
                this.setXY(xold, yold);
                continue;
            }
            distold = dist2;
        }
        this.Valid = false;
    }

    public double projectOnce() {
        this.x = this.X;
        this.y = this.Y;
        ((PointonObject)((Object)this.P1)).project(this);
        double dist = Math.max(Math.abs(this.X - this.x), Math.abs(this.Y - this.y));
        this.x1 = this.X;
        this.y1 = this.Y;
        ((PointonObject)((Object)this.P2)).project(this);
        double dist1 = Math.max(Math.abs(this.X - this.x1), Math.abs(this.Y - this.y1));
        return Math.max(dist, dist1);
    }

    @Override
    public boolean moveable() {
        return true;
    }
}

