/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.eric.JPointName;
import carmetal.objects.AngleObject;
import carmetal.objects.AreaObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.DriverObject;
import carmetal.objects.InsideObject;
import carmetal.objects.MoveableObject;
import carmetal.objects.PointonObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.QuadricObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import carmetal.rene.zirkel.structures.MagnetObj;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class PointObject
extends ConstructionObject
implements MoveableObject,
DriverObject {
    protected double X;
    protected double Y;
    protected boolean BarycentricCoordsInitialzed = false;
    protected double Gx = 0.0;
    protected double Gy = 0.0;
    protected double Alpha;
    protected boolean AlphaValid = false;
    protected boolean UseAlpha = false;
    protected boolean Moveable;
    protected boolean Fixed;
    private static JPointName PointLabel = new JPointName();
    protected int Type = 0;
    public static final int SQUARE = 0;
    public static final int DIAMOND = 1;
    public static final int CIRCLE = 2;
    public static final int DOT = 3;
    public static final int CROSS = 4;
    public static final int DCROSS = 5;
    public static int MaxType = 3;
    protected Expression EX;
    protected Expression EY;
    private boolean Later;
    private String LaterBind = "";
    private boolean KeepInside;
    private boolean DontUpdate = false;
    private double Increment = 0.0;
    private ConstructionObject Bound = null;
    private double BoundOrder = Double.NaN;
    protected ConstructionObject MovedBy;
    private double LASTX = Double.NaN;
    private double LASTY = Double.NaN;
    private final Vector magnetObjects = new Vector();
    Expression magnetRayExp = null;
    private int CurrentMagnetRay = Integer.MIN_VALUE;
    private ConstructionObject CurrentMagnetObject = null;
    public ConstructionObject VirtualBound = null;
    private double Delta;
    static double[] x = new double[4];
    static double[] y = new double[4];
    private double spin = Math.random() * 2.0 * Math.PI;

    public PointObject(Construction c2, double x, double y) {
        super(c2);
        this.X = x;
        this.Y = y;
        this.Moveable = true;
        this.Fixed = false;
        this.setColor(this.ColorIndex, this.SpecialColor);
        this.setShowName(false);
        this.updateText();
        this.Type = 2;
        this.setMagnetRayExp("20");
    }

    public PointObject(Construction c2, double x, double y, ConstructionObject bound) {
        this(c2, x, y);
        this.Bound = bound;
    }

    public PointObject(Construction c2, String name) {
        super(c2, name);
        this.X = 0.0;
        this.Y = 0.0;
        this.Moveable = true;
        this.Fixed = false;
        this.setColor(this.ColorIndex, this.SpecialColor);
        this.updateText();
        this.Type = 2;
        this.setMagnetRayExp("20");
    }

    public static void setPointLabel(JPointName jpl) {
        PointLabel = jpl;
    }

    @Override
    public void setName() {
        this.Name = !this.SuperHidden && !this.Hidden ? PointLabel.getBetterName(this.Cn, false) : JPointName.getGenericName(this.Cn);
    }

    @Override
    public void setNameWithNumber(String n) {
        this.Name = "";
        if (this.Cn != null) {
            ConstructionObject o = this.Cn.find(n);
            if (o != null) {
                while (o != null && o != this) {
                    n = this.Name = JPointName.getGenericName(this.Cn);
                    this.Name = "";
                    o = this.Cn.find(n);
                }
                this.Name = n;
            } else {
                this.Name = n;
            }
        } else {
            this.Name = n;
        }
    }

    @Override
    public String getTag() {
        if (this.Bound == null) {
            return "Point";
        }
        return "PointOn";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.point.shownames", false));
        this.setShowValue(Global.getParameter("options.point.showvalues", false));
        this.setColor(Global.getParameter("options.point.color", 0), Global.getParameter("options.point.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.point.colortype", 0));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(Global.getParameter("options.point.large", false));
        this.setBold(Global.getParameter("options.point.bold", false));
        this.Type = this.Cn.DefaultType;
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.point.shownames", false));
        this.setShowValue(Global.getParameter("options.point.showvalues", false));
        this.setColor(Global.getParameter("options.point.color", 0), Global.getParameter("options.point.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.point.colortype", 0));
        this.setLarge(Global.getParameter("options.point.large", false));
        this.setBold(Global.getParameter("options.point.bold", false));
        this.Type = this.Cn.DefaultType;
    }

    @Override
    public double changedBy() {
        return this.Delta;
    }

    @Override
    public void validate() {
        if (this.DontUpdate) {
            return;
        }
        this.updateMagnetObjects();
        this.followMagnetObject();
        this.MovedBy = null;
        this.Delta = 0.0;
        this.Valid = true;
        if (this.Bound != null && !this.Bound.isInConstruction()) {
            this.Bound = null;
        }
        if (this.Bound != null && !this.Bound.valid()) {
            this.Valid = false;
            return;
        }
        if (this.Increment > 1.0E-4) {
            this.X = Math.floor(this.X / this.Increment + 0.5) * this.Increment;
            this.Y = Math.floor(this.Y / this.Increment + 0.5) * this.Increment;
        }
        if (this.Bound != null) {
            double x = this.X;
            double y = this.Y;
            if (this.KeepInside && this.Bound instanceof InsideObject) {
                ((InsideObject)((Object)this.Bound)).keepInside(this);
            } else if (!this.KeepInside && this.Bound instanceof PointonObject) {
                if (!this.AlphaValid || !this.UseAlpha) {
                    this.project(this.Bound);
                } else {
                    this.project(this.Bound, this.Alpha);
                }
            }
            if (this.Later) {
                this.Delta = Math.sqrt((x - this.X) * (x - this.X) + (y - this.Y) * (y - this.Y));
            }
        }
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception e2) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
    }

    @Override
    public void updateText() {
        if (this.Bound != null) {
            this.setText(Global.Loc("objects.boundedpoint"));
        } else if (this.EX != null && this.EY != null) {
            this.setText(Global.Loc("objects.point"));
        } else {
            this.setText(Global.Loc("objects.point"));
        }
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        String s;
        this.DisplaysText = false;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double size = PointObject.drawPoint(g, zc, this, this.X, this.Y, this.Type);
        if (this.tracked()) {
            zc.UniversalTrack.drawTrackPoint(this, this.X, this.Y, this.Type);
        }
        if (!(s = AngleObject.translateToUnicode(this.getDisplayText())).equals("")) {
            g.setLabelColor(this);
            this.DisplaysText = true;
            this.setFont(g);
            double d2 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
            if (!this.KeepClose || d2 < 1.0E-10) {
                this.TX1 = zc.col(this.X + this.XcOffset) + 2.0 * size;
                this.TY1 = zc.row(this.Y + this.YcOffset) + 2.0 * size;
                this.drawLabel(g, s);
            } else {
                this.drawPointLabel(g, s, zc, this.X, this.Y, this.YcOffset / d2, -this.XcOffset / d2, 0.0, 0.0);
            }
        }
    }

    public static double drawPoint(MyGraphics g, ZirkelCanvas zc, ConstructionObject o, double X, double Y, int type) {
        double size = zc.pointSize();
        double r = zc.col(X);
        double c2 = zc.row(Y);
        if (size < 1.0) {
            size = 1.0;
        }
        if (o.visible(zc)) {
            if (o.isStrongSelected() && g instanceof MyGraphics13) {
                ((MyGraphics13)g).drawMarkerLine(r, c2, r, c2);
            }
            g.setColor(o);
            switch (type) {
                case 0: {
                    double sx = r - size - 1.0;
                    double sy = c2 - size - 1.0;
                    double sw = 2.0 * size + 2.0;
                    if (o.getColorType() == 1) {
                        g.fillRect(sx, sy, sw, sw, true, false, o);
                    } else {
                        g.fillRect(sx, sy, sw, sw, new Color(255, 255, 255));
                    }
                    g.setColor(o);
                    g.drawRect(sx, sy, sw, sw);
                    break;
                }
                case 1: {
                    double dx = r - size - 2.0;
                    double dy = c2 - size - 2.0;
                    double dw = 2.0 * size + 4.0;
                    g.drawDiamond(dx, dy, dw, o.getColorType() == 1, o);
                    break;
                }
                case 2: {
                    double cx = r - size - 1.0;
                    double cy = c2 - size - 1.0;
                    double cw = 2.0 * size + 2.0;
                    if (o.getColorType() == 1) {
                        g.fillOval(cx, cy, cw, cw, true, false, o);
                        break;
                    }
                    g.fillOval(cx, cy, cw, cw, new Color(255, 255, 255));
                    g.setColor(o);
                    g.drawOval(cx, cy, cw, cw);
                    break;
                }
                case 3: {
                    if (o.getColorType() == 1) {
                        g.fillRect(r, c2, 1.0, 1.0, true, false, o);
                        break;
                    }
                    g.drawLine(r, c2, r, c2);
                    break;
                }
                case 4: {
                    if (o.getColorType() == 1) {
                        g.drawThickLine(r - size, c2, r + size, c2);
                        g.drawThickLine(r, c2 - size, r, c2 + size);
                        break;
                    }
                    g.drawLine(r - size, c2, r + size, c2);
                    g.drawLine(r, c2 - size, r, c2 + size);
                    break;
                }
                case 5: {
                    double dcx = r - size - 1.0;
                    double dcy = c2 - size - 1.0;
                    double dcw = 2.0 * size + 1.0;
                    g.drawDcross(dcx, dcy, dcw, o.getColorType() == 1, o);
                }
            }
        }
        return size;
    }

    @Override
    public String getDisplayValue() {
        return "(" + Global.getLocaleNumber(this.X, "lengths") + (Global.getParameter("options.germanpoints", false) ? "|" : ";") + Global.getLocaleNumber(this.Y, "lengths") + ")";
    }

    @Override
    public String getCDPDisplayValue() {
        return "(" + Global.getCDPLocaleNumber(this.X, 2) + " " + (Global.getParameter("options.germanpoints", false) ? "|" : ";") + Global.getCDPLocaleNumber(this.Y, 2) + ")";
    }

    @Override
    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        double c2 = zc.col(this.X);
        double r = zc.row(this.Y);
        int size = (int)zc.selectionSize();
        this.Value = Math.abs((double)x - c2) + Math.abs((double)y - r);
        return this.Value <= (double)(size * 3 / 2);
    }

    public boolean nearto(PointObject p) {
        if (!this.Valid) {
            return false;
        }
        double dx = p.X - this.X;
        double dy = p.Y - this.Y;
        return Math.sqrt(dx * dx + dy * dy) < 1.0E-9;
    }

    public double distanceTo(int x, int y, ZirkelCanvas zc) {
        double dx = (double)x - zc.col(this.X);
        double dy = (double)y - zc.row(this.Y);
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public boolean moveable() {
        boolean fixed = this.Fixed;
        if (this.dependsOnItselfOnly()) {
            fixed = false;
        }
        return this.Moveable && !fixed && !this.Keep;
    }

    public boolean dependsOnItselfOnly() {
        boolean res = false;
        Enumeration e2 = this.depending();
        while (e2.hasMoreElements()) {
            if ((ConstructionObject)e2.nextElement() != this) continue;
            res = true;
            break;
        }
        e2 = this.depending();
        while (e2.hasMoreElements()) {
            if ((ConstructionObject)e2.nextElement() == this) continue;
            res = false;
            break;
        }
        return res;
    }

    public boolean dependsOnParametersOnly() {
        Enumeration e2 = this.depending();
        while (e2.hasMoreElements()) {
            if (((ConstructionObject)e2.nextElement()).isParameter()) continue;
            return false;
        }
        return true;
    }

    public boolean moveableBy(ConstructionObject o) {
        if (this.Bound != null) {
            return false;
        }
        return this.moveable() && (this.MovedBy == null || this.MovedBy == o);
    }

    public boolean moveablePoint() {
        if (this.Bound != null) {
            return true;
        }
        return this.Moveable && !this.Keep;
    }

    public boolean setBound(String name) {
        block6: {
            if (name.equals("")) {
                this.Bound = null;
                this.setFixed(false);
                this.Later = false;
                return true;
            }
            try {
                this.Bound = null;
                ConstructionObject o = this.Cn.find(name);
                if (o instanceof PointonObject) {
                    this.Bound = o;
                    this.Moveable = true;
                    this.Fixed = false;
                    this.KeepInside = false;
                    break block6;
                }
                if (o instanceof InsideObject) {
                    this.Bound = o;
                    this.Moveable = true;
                    this.Fixed = false;
                    this.KeepInside = true;
                    break block6;
                }
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        if (this.Cn.before(this, this.Bound)) {
            this.Cn.needsOrdering();
            this.Cn.dovalidate();
        }
        this.updateText();
        this.clearMagnetObjects();
        return true;
    }

    public void setBound(ConstructionObject bound) {
        this.Bound = bound;
    }

    public boolean haveBoundOrder() {
        return !Double.isNaN(this.BoundOrder);
    }

    public void setBoundOrder(double boundorder) {
        this.BoundOrder = boundorder;
    }

    public void clearBoundOrder() {
        this.BoundOrder = Double.NaN;
    }

    public ConstructionObject getBound() {
        return this.Bound;
    }

    public double getBoundOrder() {
        return this.BoundOrder;
    }

    public void setMoveable(boolean flag) {
        this.Moveable = flag;
    }

    @Override
    public boolean fixed() {
        return this.Fixed;
    }

    @Override
    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    @Override
    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EX = new Expression(x, this.getConstruction(), this);
        this.EY = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    public void validCoordinates() throws Exception {
        boolean val;
        boolean bl = val = this.EX.isValid() && this.EY.isValid();
        if (!val) {
            throw new Exception("");
        }
    }

    public boolean insidewindow() {
        return this.insidewindow(this.X, this.Y);
    }

    public boolean insidewindow(double x, double y) {
        boolean b2 = x > this.Cn.getX() - this.Cn.getW();
        b2 = b2 && x < this.Cn.getX() + this.Cn.getW();
        b2 = b2 && y < this.Cn.getY() + this.Cn.getH() / 2.0;
        b2 = b2 && y > this.Cn.getY() - this.Cn.getH() / 2.0;
        return b2;
    }

    public void shake() {
        if (!this.insidewindow(this.X, this.Y)) {
            return;
        }
        this.spin += Math.random() - 0.5;
        double x = this.X + 5.0 * Math.cos(this.spin) / this.Cn.getPixel();
        double y = this.Y + 5.0 * Math.sin(this.spin) / this.Cn.getPixel();
        while (!this.insidewindow(x, y)) {
            this.spin = Math.random() * 2.0 * Math.PI;
            x = this.X + 5.0 * Math.cos(this.spin) / this.Cn.getPixel();
            y = this.Y + 5.0 * Math.sin(this.spin) / this.Cn.getPixel();
        }
        this.move(x, y);
        this.validate();
    }

    public void alea() {
        if (!this.insidewindow(this.X, this.Y)) {
            return;
        }
        double left = this.Cn.getX() - this.Cn.getW();
        double top = this.Cn.getY() + this.Cn.getH() / 2.0;
        double x = left + Math.random() * 2.0 * this.Cn.getW();
        double y = top - Math.random() * this.Cn.getH();
        while (!this.insidewindow(x, y)) {
            x = left + Math.random() * 2.0 * this.Cn.getW();
            y = top - Math.random() * this.Cn.getH();
        }
        this.move(x, y);
        this.validate();
    }

    @Override
    public void move(double x, double y) {
        if (this.X == x && this.Y == y) {
            return;
        }
        this.X = x;
        this.Y = y;
        this.AlphaValid = false;
        this.computeBarycentricCoords();
    }

    public void setXY(double x, double y) {
        if (this.X == x && this.Y == y) {
            return;
        }
        this.X = x;
        this.Y = y;
    }

    public void setXYaway(double x, double y, int r) {
        if (r > 0) {
            this.setXY(x, y);
            return;
        }
        double d2 = Math.sqrt((this.X - x) * (this.X - x) + (this.Y - y) * (this.Y - y));
        double dblr = (double)(-r) / this.Cn.getPixel();
        double xx = x + dblr;
        double yy = y;
        if (d2 != 0.0) {
            xx = x + (this.X - x) * dblr / d2;
            yy = y + (this.Y - y) * dblr / d2;
        }
        this.setXY(xx, yy);
    }

    public void setA(double alpha) {
        this.Alpha = alpha;
    }

    public void setMagnetRayExp(String s) {
        this.magnetRayExp = new Expression(s, this.Cn, this);
    }

    public String getMagnetRayExp() {
        return this.magnetRayExp.toString();
    }

    public int getMagnetRay() {
        int i = 20;
        try {
            i = (int)Math.round(this.magnetRayExp.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public boolean isMagnet() {
        return this.CurrentMagnetObject != null;
    }

    private boolean isMagnetObject(String name) {
        Enumeration e2 = this.magnetObjects.elements();
        while (e2.hasMoreElements()) {
            MagnetObj mo = (MagnetObj)e2.nextElement();
            if (!mo.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void removeMagnetObject(String name) {
        Enumeration e2 = this.magnetObjects.elements();
        while (e2.hasMoreElements()) {
            MagnetObj mo = (MagnetObj)e2.nextElement();
            if (!mo.name().equals(name)) continue;
            this.magnetObjects.remove(mo);
        }
    }

    public void addMagnetObject(String s) {
        String[] mo = s.split(":");
        String name = mo[0];
        String ray = "-2147483648";
        if (mo.length > 1) {
            ray = mo[1];
        }
        if (name.equals(this.getName())) {
            return;
        }
        ConstructionObject o = this.Cn.find(name);
        if (o != null && !this.isMagnetObject(name)) {
            this.magnetObjects.add(new MagnetObj(o, ray));
        }
    }

    public void setMagnetObjects(String namelist) {
        String st = "";
        int p = 0;
        for (int i = 0; i < namelist.length(); ++i) {
            char t = namelist.charAt(i);
            if (t == '(') {
                ++p;
            } else if (t == ')') {
                --p;
            }
            st = p > 0 && t == ',' ? st + "@@" : st + t;
        }
        String[] s = st.split(",");
        this.magnetObjects.removeAllElements();
        for (String element : s) {
            st = element.replaceAll("@@", ",");
            this.addMagnetObject(st);
        }
    }

    public void selectMagnetObjects(boolean b2) {
        Enumeration e2 = this.magnetObjects.elements();
        while (e2.hasMoreElements()) {
            MagnetObj mo = (MagnetObj)e2.nextElement();
            if (!mo.isInConstruction()) continue;
            mo.setSelected(b2);
        }
    }

    public void updateMagnetObjects() {
        Enumeration e2 = this.magnetObjects.elements();
        while (e2.hasMoreElements()) {
            MagnetObj mo = (MagnetObj)e2.nextElement();
            if (mo.isInConstruction()) continue;
            this.magnetObjects.remove(mo);
        }
    }

    public void clearMagnetObjects() {
        this.magnetObjects.removeAllElements();
        this.setMagnetRayExp("20");
    }

    public void translateMagnetObjects() {
        Enumeration e2 = this.magnetObjects.elements();
        while (e2.hasMoreElements()) {
            MagnetObj mo = (MagnetObj)e2.nextElement();
            mo.translate();
        }
    }

    public Vector getMagnetObjects() {
        return this.magnetObjects;
    }

    public String getMagnetObjectsString() {
        MagnetObj mo;
        this.updateMagnetObjects();
        String s = "";
        Enumeration e2 = this.magnetObjects.elements();
        if (e2.hasMoreElements()) {
            mo = (MagnetObj)e2.nextElement();
            s = mo.name();
            if (mo.ray() > Integer.MIN_VALUE) {
                s = s + ":" + mo.rayexp();
            }
        }
        while (e2.hasMoreElements()) {
            mo = (MagnetObj)e2.nextElement();
            s = s + "," + mo.name();
            if (mo.ray() <= Integer.MIN_VALUE) continue;
            s = s + ":" + mo.rayexp();
        }
        return s;
    }

    public void magnet() {
        Object pt;
        ConstructionObject PtOnObject = null;
        ConstructionObject PtObject = null;
        Enumeration e2 = this.magnetObjects.elements();
        int dp = Integer.MAX_VALUE;
        int dm = Integer.MAX_VALUE;
        int rayp = 0;
        int raym = 0;
        while (e2.hasMoreElements()) {
            int i;
            MagnetObj mo = (MagnetObj)e2.nextElement();
            ConstructionObject o = mo.obj();
            int mRay = mo.ray() > Integer.MIN_VALUE ? mo.ray() : this.getMagnetRay();
            int mRayAbs = Math.abs(mRay);
            if (mRayAbs == 0 || !o.valid()) continue;
            if (o instanceof PointObject) {
                i = o.getDistance(this);
                if (i > mRayAbs || i >= dp) continue;
                PtObject = o;
                rayp = mRay;
                dp = i;
                continue;
            }
            if (!(o instanceof PointonObject) || (i = o.getDistance(this)) > mRayAbs || i >= dm) continue;
            PtOnObject = o;
            raym = mRay;
            dm = i;
        }
        if (PtObject != null) {
            pt = (PointObject)PtObject;
            this.setXYaway(((PointObject)pt).getX(), ((PointObject)pt).getY(), rayp);
            if (PtObject != this.CurrentMagnetObject) {
                this.CurrentMagnetObject = PtObject;
                this.CurrentMagnetRay = rayp;
                this.Cn.reorderConstruction();
            }
        } else if (PtOnObject != null) {
            pt = (PointonObject)((Object)PtOnObject);
            if (PtOnObject != this.CurrentMagnetObject) {
                this.CurrentMagnetObject = PtOnObject;
                this.CurrentMagnetRay = raym;
                this.Cn.reorderConstruction();
            }
            pt.project(this);
        } else {
            this.CurrentMagnetObject = null;
            this.CurrentMagnetRay = Integer.MIN_VALUE;
        }
    }

    public void setCurrentMagnetObject() {
        ConstructionObject PtOnObject = null;
        ConstructionObject PtObject = null;
        Enumeration e2 = this.magnetObjects.elements();
        int dp = Integer.MAX_VALUE;
        int dm = Integer.MAX_VALUE;
        int rayp = 0;
        int raym = 0;
        while (e2.hasMoreElements()) {
            int i;
            int mRay;
            MagnetObj mo = (MagnetObj)e2.nextElement();
            ConstructionObject o = mo.obj();
            int n = mRay = mo.ray() > Integer.MIN_VALUE ? mo.ray() : this.getMagnetRay();
            if (o instanceof PointObject) {
                i = o.getDistance(this);
                if (i > mRay || i >= dp) continue;
                PtObject = o;
                rayp = mRay;
                dp = i;
                continue;
            }
            if (!(o instanceof PointonObject) || (i = o.getDistance(this)) > mRay || i >= dm) continue;
            PtOnObject = o;
            raym = mRay;
            dm = i;
        }
        if (PtObject != null) {
            this.CurrentMagnetObject = PtObject;
            this.CurrentMagnetRay = rayp;
        } else if (PtOnObject != null) {
            this.CurrentMagnetObject = PtOnObject;
            this.CurrentMagnetRay = raym;
        } else {
            this.CurrentMagnetObject = null;
            this.CurrentMagnetRay = Integer.MIN_VALUE;
        }
    }

    public ConstructionObject getCurrentMagnetObject() {
        return this.CurrentMagnetObject;
    }

    public void followMagnetObject() {
        if (this.CurrentMagnetObject != null) {
            if (this.CurrentMagnetObject instanceof PointObject) {
                PointObject pt = (PointObject)this.CurrentMagnetObject;
                if (this.CurrentMagnetRay > 0) {
                    this.setXY(pt.getX(), pt.getY());
                }
            } else if (this.CurrentMagnetObject instanceof PointonObject) {
                this.project(this.CurrentMagnetObject, this.Alpha);
            }
        }
        this.magnet();
    }

    @Override
    public int getDistance(PointObject P) {
        double d2 = Math.sqrt((this.getX() - P.getX()) * (this.getX() - P.getX()) + (this.getY() - P.getY()) * (this.getY() - P.getY()));
        return (int)Math.round(d2 * this.Cn.getPixel());
    }

    public void project(ConstructionObject o) {
        if (!(o instanceof PointonObject)) {
            return;
        }
        ((PointonObject)((Object)o)).project(this);
        if (this.UseAlpha) {
            this.AlphaValid = true;
        }
    }

    public void project(ConstructionObject o, double alpha) {
        ((PointonObject)((Object)o)).project(this, alpha);
    }

    @Override
    public void printArgs(XmlWriter xml) {
        this.updateText();
        this.updateMagnetObjects();
        if (this.Bound != null) {
            xml.printArg("on", this.Bound.getName());
            if (this.KeepInside) {
                xml.printArg("inside", "true");
            }
        }
        if (this.magnetObjects.size() > 0) {
            xml.printArg("magnetobjs", this.getMagnetObjectsString());
            xml.printArg("magnetd", "" + this.magnetRayExp.toString());
        }
        if (this.haveBoundOrder()) {
            xml.printArg("boundorder", String.valueOf(this.BoundOrder));
        }
        if (this.Fixed && this.EX != null) {
            xml.printArg("x", this.EX.toString());
            xml.printArg("actx", "" + this.X);
        } else {
            if (this.Bound != null && this.AlphaValid && this.UseAlpha) {
                xml.printArg("alpha", "" + this.Alpha);
            }
            xml.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null) {
            xml.printArg("y", this.EY.toString());
            xml.printArg("acty", "" + this.Y);
        } else {
            xml.printArg("y", "" + this.Y);
        }
        this.printType(xml);
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        if (this.Increment > 1.0E-4) {
            xml.printArg("increment", "" + this.getIncrement());
        }
    }

    public void printType(XmlWriter xml) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xml.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xml.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xml.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xml.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xml.printArg("shape", "dcross");
                }
            }
        }
    }

    @Override
    public int getType() {
        return this.Type;
    }

    @Override
    public void setType(int type) {
        this.Type = type;
    }

    public void movedBy(ConstructionObject o) {
        this.MovedBy = o;
    }

    @Override
    public boolean equals(ConstructionObject o) {
        if (!(o instanceof PointObject) || !o.valid()) {
            return false;
        }
        PointObject p = (PointObject)o;
        return this.equals(this.X, p.X) && this.equals(this.Y, p.Y);
    }

    @Override
    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    @Override
    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public boolean isOn(ConstructionObject o) {
        if (this.Bound != null) {
            return o == this.Bound;
        }
        return o.contains(this);
    }

    @Override
    public void translate() {
        if (this.Bound != null) {
            this.Bound = this.Bound.getTranslation();
        } else if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.magnetRayExp.translate();
        this.translateMagnetObjects();
    }

    @Override
    public Enumeration depending() {
        super.depending();
        if (this.Bound != null) {
            DL.add(this.Bound);
        }
        if (this.Fixed) {
            if (this.EX != null) {
                this.EX.addDep(this);
            }
            if (this.EY != null) {
                this.EY.addDep(this);
            }
        }
        return DL.elements();
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        double d2 = zc.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
        this.updateText();
    }

    public void setHalfIncrement(ZirkelCanvas zc) {
        double d2 = zc.getGridSize() / 2.0;
        this.setIncrement(d2);
        this.validate();
    }

    @Override
    public void updateCircleDep() {
        if (this.Bound != null && this.Bound instanceof PrimitiveCircleObject) {
            ((PrimitiveCircleObject)this.Bound).addDep(this);
        }
        if (this.Bound != null && this.Bound instanceof PrimitiveLineObject) {
            ((PrimitiveLineObject)this.Bound).addDep(this);
        }
    }

    public boolean isPointOn() {
        return this.Bound != null;
    }

    public boolean isPointOnOrMagnet() {
        return this.Bound != null || this.CurrentMagnetObject != null;
    }

    public void setLaterBind(String s) {
        this.LaterBind = s;
    }

    @Override
    public ConstructionObject copy(double x, double y) {
        ConstructionObject o = null;
        try {
            o = (ConstructionObject)this.clone();
            this.setTranslation(o);
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
            if (this.KeepInside && this.Bound != null && this.Bound instanceof AreaObject) {
                o.move(x, y);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o;
    }

    public void computeBarycentricCoords() {
        if (this.Bound != null && this.Bound instanceof QuadricObject) {
            QuadricObject quad = (QuadricObject)this.Bound;
            PointObject A = quad.P[0];
            PointObject B = quad.P[1];
            PointObject C = quad.P[2];
            double a2 = B.getX() - A.getX();
            double b2 = C.getX() - A.getX();
            double c2 = this.getX() - A.getX();
            double d2 = B.getY() - A.getY();
            double e2 = C.getY() - A.getY();
            double f2 = this.getY() - A.getY();
            double det = a2 * e2 - d2 * b2;
            if (det != 0.0) {
                this.Gx = (c2 * e2 - b2 * f2) / det;
                this.Gy = (a2 * f2 - c2 * d2) / det;
                this.BarycentricCoordsInitialzed = true;
            }
        } else if (this.KeepInside && this.Bound != null && this.Bound instanceof AreaObject) {
            AreaObject area = (AreaObject)this.Bound;
            if (area.V.size() > 2) {
                PointObject A = area.V.get(0);
                PointObject B = area.V.get(1);
                PointObject C = area.V.get(2);
                double a3 = B.getX() - A.getX();
                double b3 = C.getX() - A.getX();
                double c3 = this.getX() - A.getX();
                double d3 = B.getY() - A.getY();
                double e3 = C.getY() - A.getY();
                double f3 = this.getY() - A.getY();
                double det = a3 * e3 - d3 * b3;
                if (det != 0.0) {
                    this.Gx = (c3 * e3 - b3 * f3) / det;
                    this.Gy = (a3 * f3 - c3 * d3) / det;
                    this.BarycentricCoordsInitialzed = true;
                }
            }
        }
    }

    @Override
    public void setInside(boolean flag) {
        this.KeepInside = flag;
        this.computeBarycentricCoords();
    }

    @Override
    public boolean isInside() {
        return this.KeepInside;
    }

    @Override
    public void laterBind(Construction c2) {
        if (this.LaterBind.equals("")) {
            return;
        }
        ConstructionObject o = c2.find(this.LaterBind);
        if (o != null && (o instanceof PointonObject || o instanceof InsideObject)) {
            this.Bound = o;
            this.updateText();
            this.validate();
        }
        this.LaterBind = "";
    }

    public void setAlpha(double alpha) {
        this.Alpha = alpha;
        this.AlphaValid = true;
    }

    public void setUseAlpha(boolean flag) {
        this.UseAlpha = flag;
    }

    public boolean useAlpha() {
        return this.UseAlpha;
    }

    public double getAlpha() {
        return this.Alpha;
    }

    @Override
    public void round() {
        this.move(this.round(this.X, ZirkelCanvas.LengthsFactor), this.round(this.Y, ZirkelCanvas.LengthsFactor));
    }

    @Override
    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = x - this.X;
        this.YcOffset = y - this.Y;
    }

    @Override
    public boolean canKeepClose() {
        return true;
    }

    public boolean dontUpdate() {
        return this.DontUpdate;
    }

    public void dontUpdate(boolean flag) {
        this.DontUpdate = flag;
    }

    @Override
    public void startDrag(double x, double y) {
    }

    @Override
    public void dragTo(double x, double y) {
        this.clearBoundOrder();
        if (this.X == x && this.Y == y) {
            return;
        }
        this.move(x, y);
    }

    @Override
    public double getOldX() {
        return 0.0;
    }

    @Override
    public double getOldY() {
        return 0.0;
    }

    @Override
    public void setIncrement(double inc) {
        this.Increment = inc;
    }

    @Override
    public double getIncrement() {
        return this.Increment;
    }

    @Override
    public boolean isDriverObject() {
        if (this.Bound != null) {
            return true;
        }
        return this.Moveable && !this.Keep;
    }

    @Override
    public boolean somethingChanged() {
        return this.getX() != this.LASTX || this.getY() != this.LASTY;
    }

    @Override
    public void clearChanges() {
        this.LASTX = this.getX();
        this.LASTY = this.getY();
    }
}

