/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.objects.DriverObject;
import carmetal.objects.Evaluator;
import carmetal.objects.HeavyObject;
import carmetal.objects.PointObject;
import carmetal.objects.PointonObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.graphics.FunctionPolygonFiller;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.PolygonDrawer;
import carmetal.rene.zirkel.structures.Coordinates;
import java.awt.Color;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class FunctionObject
extends ConstructionObject
implements PointonObject,
HeavyObject,
DriverObject,
Evaluator {
    Expression EX = null;
    Expression EY = null;
    public Expression VarMin = null;
    public Expression VarMax = null;
    public Expression DVar = null;
    String LASTEX = "";
    String LASTEY = "";
    String LASTVarMin = "";
    String LASTVarMax = "";
    String LASTDVar = "";
    double[] X = new double[]{0.0};
    public String[] Var = new String[]{"x"};
    boolean Filled = false;
    Expression Center = null;
    protected int Type = 0;
    public static final int SQUARE = 0;
    public static final int DIAMOND = 1;
    public static final int CIRCLE = 2;
    public static final int DOT = 3;
    public static final int CROSS = 4;
    public static final int DCROSS = 5;
    protected boolean Special = false;
    public Vector V = new Vector();
    double cx;
    double cy;
    double ww;
    double wh;
    Vector DriverObjectList = new Vector();
    double c0;
    double r0;
    double c;
    double r;
    FunctionPolygonFiller PF = null;
    double C1;
    double C2;
    int C;
    int R;
    int W;
    int H;
    public boolean EditAborted;

    public FunctionObject(Construction c2) {
        super(c2);
        this.VarMin = new Expression("windowcx-windoww", c2, this);
        this.VarMax = new Expression("windowcx+windoww", c2, this);
        this.DVar = new Expression("0", c2, this);
        this.validate();
        this.updateText();
        this.cx = c2.getX();
        this.cy = c2.getY();
        this.ww = c2.getW();
        this.wh = c2.getH();
        this.Type = 4;
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.locus.shownames", false));
        this.setShowValue(Global.getParameter("options.locus.showvalues", false));
        this.setColor(Global.getParameter("options.locus.color", 0));
        this.setColorType(Global.getParameter("options.locus.colortype", 0));
        this.setFilled(Global.getParameter("options.locus.filled", false));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.locus.shownames", false));
        this.setShowValue(Global.getParameter("options.locus.showvalues", false));
        this.setColor(Global.getParameter("options.locus.color", 0), Global.getParameter("options.locus.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.locus.colortype", 0));
        this.setFilled(Global.getParameter("options.locus.filled", false));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
    }

    @Override
    public void searchDependencies(Construction c2) {
        this.DriverObjectList.clear();
        if (this.RekValidating) {
            return;
        }
        this.RekValidating = true;
        Enumeration e2 = c2.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).setRekFlag(false);
        }
        ConstructionObject[] oEX = this.EX.getDepList().getArray();
        ConstructionObject[] oEY = this.EY.getDepList().getArray();
        ConstructionObject[] oVarMin = this.VarMin.getDepList().getArray();
        ConstructionObject[] oVarMax = this.VarMax.getDepList().getArray();
        ConstructionObject[] oDVar = this.DVar.getDepList().getArray();
        for (ConstructionObject element : oEX) {
            this.recursiveSearchDependencies(element);
        }
        for (ConstructionObject element : oEY) {
            this.recursiveSearchDependencies(element);
        }
        for (ConstructionObject element : oVarMin) {
            this.recursiveSearchDependencies(element);
        }
        for (ConstructionObject element : oVarMax) {
            this.recursiveSearchDependencies(element);
        }
        for (ConstructionObject element : oDVar) {
            this.recursiveSearchDependencies(element);
        }
        e2 = c2.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject oc = (ConstructionObject)e2.nextElement();
            if (!oc.isRekFlag() || !oc.isDriverObject()) continue;
            this.DriverObjectList.addElement(oc);
        }
        this.RekValidating = false;
        this.NeedsRecompute = true;
    }

    public void recursiveSearchDependencies(ConstructionObject o) {
        ConstructionObject[] d2;
        if (o.isRekFlag()) {
            return;
        }
        o.setRekFlag(true);
        for (ConstructionObject element : d2 = o.getDepArray()) {
            this.recursiveSearchDependencies(element);
        }
    }

    @Override
    public void compute() {
        double d2;
        double varmax;
        double varmin;
        this.V.clear();
        if (!this.Valid) {
            return;
        }
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            d2 = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
            }
            if (d2 < 0.0) {
                d2 = -d2;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return;
        }
        this.X[0] = varmin;
        if (this.mayHaveDiscontinuityPb()) {
            if (d2 == 0.0) {
                try {
                    d2 = new Expression("1/pixel", this.getConstruction(), this).getValue();
                }
                catch (Exception e2) {}
            } else if (d2 < (varmax - varmin) / 1000.0) {
                d2 = (varmax - varmin) / 1000.0;
            }
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            double yM = 0.0;
            double X0 = 0.0;
            int nbsteps = (int)Math.round((varmax - varmin) / d2) + 1;
            try {
                x1 = this.EX.getValue();
                y1 = this.EY.getValue();
                this.V.add(new Coordinates(x1, y1, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 1; i < nbsteps; ++i) {
                try {
                    X0 = this.X[0];
                    this.X[0] = this.X[0] + d2 / 2.0;
                    this.EX.getValue();
                    yM = this.EY.getValue();
                    this.X[0] = this.X[0] + d2 / 2.0;
                    x2 = this.EX.getValue();
                    y2 = this.EY.getValue();
                    if (y1 == yM && y2 == yM) {
                        this.V.add(new Coordinates(x2, y2, true));
                    } else if (yM > y1 && yM < y2 || yM > y2 && yM < y1) {
                        double mm = Math.abs(y1 - yM) / Math.abs(y2 - yM);
                        if (mm < 0.1 || mm > 10.0) {
                            this.V.add(new Coordinates(x2, y2, false));
                        } else {
                            this.V.add(new Coordinates(x2, y2, true));
                        }
                    } else {
                        this.V.add(new Coordinates(x2, y2, false));
                    }
                    x1 = x2;
                    y1 = y2;
                    continue;
                }
                catch (Exception ex) {
                    try {
                        this.X[0] = X0 + d2;
                        x1 = this.EX.getValue();
                        y1 = this.EY.getValue();
                        this.V.add(new Coordinates(x1, y1, false));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        } else {
            if (d2 == 0.0) {
                d2 = (varmax - varmin) / 100.0;
            } else if (d2 < (varmax - varmin) / 1000.0) {
                d2 = (varmax - varmin) / 1000.0;
            }
            int nbsteps = (int)Math.round((varmax - varmin) / d2) + 1;
            for (int i = 0; i < nbsteps; ++i) {
                try {
                    this.V.add(new Coordinates(this.EX.getValue(), this.EY.getValue()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.X[0] = this.X[0] + d2;
            }
        }
    }

    public void setNeedsToRecompte(boolean n) {
        this.NeedsRecompute = n;
    }

    @Override
    public boolean needsToRecompute() {
        boolean needs = false;
        Enumeration pl = this.DriverObjectList.elements();
        while (pl.hasMoreElements()) {
            DriverObject oc = (DriverObject)pl.nextElement();
            if (!oc.somethingChanged()) continue;
            Global.addClearList(oc);
            needs = true;
        }
        if (this.Cn.getX() != this.cx || this.Cn.getY() != this.cy || this.Cn.getW() != this.ww || this.Cn.getH() != this.wh) {
            this.cx = this.Cn.getX();
            this.cy = this.Cn.getY();
            this.ww = this.Cn.getW();
            this.wh = this.Cn.getH();
            needs = true;
        }
        if (this.NeedsRecompute) {
            this.NeedsRecompute = false;
            return true;
        }
        return needs;
    }

    @Override
    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    @Override
    public boolean isFilled() {
        return this.Filled;
    }

    @Override
    public String getTag() {
        return "Function";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        if (this.EX != null && this.EY != null) {
            this.setText(FunctionObject.text2(Global.name("text.function"), this.EX.toString(), this.EY.toString()));
        } else {
            this.setText(FunctionObject.text2(Global.name("text.function"), "", ""));
        }
    }

    @Override
    public void validate() {
        this.Valid = this.EX != null && this.EY != null ? this.EX.isValid() && this.EY.isValid() && this.VarMin.isValid() && this.VarMax.isValid() && this.DVar.isValid() : false;
    }

    public void setExpressions(String t, String ex, String ey) {
        StringTokenizer tok = new StringTokenizer(t);
        this.Var = new String[tok.countTokens()];
        this.X = new double[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.Var[i++] = tok.nextToken();
        }
        if (ex.equals("")) {
            ex = this.Var[0];
        }
        this.EX = new Expression(ex, this.getConstruction(), this, this.Var);
        this.EY = new Expression(ey, this.getConstruction(), this, this.Var);
        this.validate();
        this.searchDependencies(this.Cn);
    }

    public boolean isCartesian() {
        return this.EX.toString().equals("x");
    }

    public boolean mayHaveDiscontinuityPb() {
        String[] Pbs = new String[]{"floor(", "ceil(", "tan(", "sign("};
        if (this.EX.toString().equals("x")) {
            for (String pb : Pbs) {
                if (this.EY.toString().indexOf(pb) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public void setRange(String min, String max, String d2) {
        this.VarMin = new Expression(min, this.getConstruction(), this);
        this.VarMax = new Expression(max, this.getConstruction(), this);
        this.DVar = new Expression(d2, this.getConstruction(), this);
        this.searchDependencies(this.Cn);
    }

    @Override
    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return this.Var[0];
    }

    @Override
    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "0";
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        Coordinates C = null;
        Enumeration e2 = this.V.elements();
        g.setColor(this);
        if (this.Special) {
            if (this.Filled) {
                this.PF = new FunctionPolygonFiller(g, this, zc.getY(), zc.getY() + zc.getHeight());
                while (e2.hasMoreElements()) {
                    C = (Coordinates)e2.nextElement();
                    this.PF.add(zc.col(C.X), zc.row(C.Y));
                }
                this.PF.fillPolygon(zc.row(0.0));
                e2 = this.V.elements();
                g.setColor(this);
            }
            while (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                PointObject.drawPoint(g, zc, this, C.X, C.Y, this.Type);
            }
        } else if (this.Tracked) {
            zc.UniversalTrack.TrackIG.setColor(this);
            zc.UniversalTrack.setActive(true);
            PolygonDrawer pd = new PolygonDrawer(g, this);
            PolygonDrawer pdt = new PolygonDrawer(zc.UniversalTrack.TrackIG, this);
            if (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                this.c0 = zc.col(C.X);
                this.r0 = zc.row(C.Y);
                pd.startPolygon(this.c0, this.r0);
                pdt.startPolygon(this.c0, this.r0);
            }
            while (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                double c2 = zc.col(C.X);
                double r = zc.row(C.Y);
                if (Math.abs(pd.c() - c2) < 1000.0 && Math.abs(pd.r() - r) < 1000.0) {
                    pd.drawTo(c2, r);
                    pdt.drawTo(c2, r);
                    continue;
                }
                pd.finishPolygon();
                pdt.finishPolygon();
                pd.startPolygon(c2, r);
                pdt.startPolygon(c2, r);
            }
            pd.finishPolygon();
            pdt.finishPolygon();
        } else {
            if (this.Filled) {
                this.PF = new FunctionPolygonFiller(g, this, zc.getY(), zc.getY() + zc.getHeight());
                while (e2.hasMoreElements()) {
                    C = (Coordinates)e2.nextElement();
                    this.PF.add(zc.col(C.X), zc.row(C.Y));
                }
                this.PF.fillPolygon(zc.row(0.0));
                e2 = this.V.elements();
                g.setColor(this);
            }
            PolygonDrawer pd = new PolygonDrawer(g, this);
            if (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                this.c0 = zc.col(C.X);
                this.r0 = zc.row(C.Y);
                pd.startPolygon(this.c0, this.r0);
            }
            while (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                double c3 = zc.col(C.X);
                double r = zc.row(C.Y);
                if (C.join) {
                    pd.drawTo(c3, r);
                    continue;
                }
                pd.finishPolygon();
                pd.startPolygon(c3, r);
            }
            pd.finishPolygon();
        }
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.X[0];
    }

    public double getValue(String var) throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        for (int i = 0; i < this.Var.length; ++i) {
            if (!var.equals(this.Var[i])) continue;
            return this.X[i];
        }
        return this.X[0];
    }

    public double getIntegral() throws ConstructionException {
        return this.getSum();
    }

    @Override
    public String getDisplayValue() {
        if (this.getEX().equals(this.getVar())) {
            return this.EY.toString();
        }
        return "(" + this.EX.toString() + "," + this.EY.toString() + ")";
    }

    @Override
    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        Enumeration e2 = this.V.elements();
        double xx = zc.x(x);
        double yy = zc.y(y);
        double mymax = 7.0 / this.Cn.getPixel();
        if (this.Special) {
            while (e2.hasMoreElements()) {
                Coordinates CS = (Coordinates)e2.nextElement();
                if (!(Math.abs(CS.X - xx) < mymax) || !(Math.abs(CS.Y - yy) < mymax)) continue;
                return true;
            }
        } else {
            double xA = 0.0;
            double yA = 0.0;
            double xB = 0.0;
            double yB = 0.0;
            if (e2.hasMoreElements()) {
                Coordinates CS0 = (Coordinates)e2.nextElement();
                xA = CS0.X;
                yA = CS0.Y;
            }
            while (e2.hasMoreElements()) {
                double cc;
                double aa;
                double bb;
                double d2;
                Coordinates CS1 = (Coordinates)e2.nextElement();
                xB = CS1.X;
                yB = CS1.Y;
                double p1 = (xx - xA) * (xB - xA) + (yy - yA) * (yB - yA);
                double p2 = (xx - xB) * (xA - xB) + (yy - yB) * (yA - yB);
                if (p1 > 0.0 && p2 > 0.0 && (d2 = Math.abs(-(bb = yB - yA) * xx + (aa = xB - xA) * yy + (cc = bb * xA - aa * yA)) / Math.sqrt(aa * aa + bb * bb)) < mymax) {
                    return true;
                }
                xA = xB;
                yA = yB;
            }
        }
        return false;
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("x", this.EX.toString());
        xml.printArg("y", this.EY.toString());
        xml.printArg("var", this.getVar());
        xml.printArg("min", "" + this.VarMin);
        xml.printArg("max", "" + this.VarMax);
        xml.printArg("d", "" + this.DVar);
        if (this.Special) {
            xml.printArg("special", "true");
        }
        this.printType(xml);
        if (this.Filled) {
            xml.printArg("filled", "true");
        }
        if (this.getCenter() != null) {
            xml.printArg("center", this.getCenter().getName());
        }
        xml.printArg("color", "" + this.getColorIndex());
    }

    @Override
    public void setType(int type) {
        this.Type = type;
    }

    @Override
    public int getType() {
        return this.Type;
    }

    public void printType(XmlWriter xml) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xml.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xml.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xml.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xml.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xml.printArg("shape", "dcross");
                }
            }
        }
    }

    @Override
    public ConstructionObject copy(double x, double y) {
        FunctionObject fo = new FunctionObject(this.getConstruction());
        fo.copyProperties(this);
        fo.EX = new Expression(this.EX.toString(), this.getConstruction(), fo, this.Var);
        fo.EY = new Expression(this.EY.toString(), this.getConstruction(), fo, this.Var);
        fo.VarMin = new Expression(this.VarMin.toString(), this.getConstruction(), fo);
        fo.VarMax = new Expression(this.VarMax.toString(), this.getConstruction(), fo);
        fo.DVar = new Expression(this.DVar.toString(), this.getConstruction(), fo);
        fo.Special = this.Special;
        ConstructionObject O = this.getTranslation();
        fo.setTranslation(this);
        fo.EX.translate();
        fo.EY.translate();
        fo.VarMin.translate();
        fo.VarMax.translate();
        fo.DVar.translate();
        fo.translateConditionals();
        fo.X = this.X;
        fo.Var = this.Var;
        fo.validate();
        fo.setTranslation(O);
        fo.searchDependencies(this.Cn.getTranslation());
        return fo;
    }

    @Override
    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    @Override
    public boolean equals(ConstructionObject o) {
        return false;
    }

    @Override
    public Enumeration depending() {
        DL.reset();
        this.addDepending(this.EX);
        this.addDepending(this.EY);
        this.addDepending(this.VarMin);
        this.addDepending(this.VarMax);
        this.addDepending(this.DVar);
        return DL.elements();
    }

    public void addDepending(Expression E) {
        if (E != null) {
            Enumeration e2 = E.getDepList().elements();
            while (e2.hasMoreElements()) {
                DL.add((ConstructionObject)e2.nextElement());
            }
        }
    }

    @Override
    public boolean hasUnit() {
        return false;
    }

    public double evaluateF(double[] x) throws ConstructionException {
        int i;
        int n = x.length;
        if (n > this.X.length) {
            n = this.X.length;
        }
        for (i = 0; i < n; ++i) {
            this.X[i] = x[i];
        }
        for (i = n; i < this.X.length; ++i) {
            this.X[i] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    @Override
    public double evaluateF(double x) throws ConstructionException {
        this.X[0] = x;
        for (int i = 1; i < this.X.length; ++i) {
            this.X[i] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    @Override
    public int getDistance(PointObject P) {
        double varmax;
        double varmin;
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            double dvar = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
            }
            if (dvar < 0.0) {
                dvar = -dvar;
            }
            if (dvar == 0.0) {
                dvar = (varmax - varmin) / 100.0;
            } else if (dvar < (varmax - varmin) / 1000.0) {
                dvar = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return Integer.MAX_VALUE;
        }
        try {
            if (this.getEX().equals("x")) {
                double x = P.getX() < varmin ? varmin : P.getX();
                x = P.getX() > varmax ? varmax : x;
                double y = this.evaluateF(x);
                double dd = Math.sqrt((P.getX() - x) * (P.getX() - x) + (P.getY() - y) * (P.getY() - y));
                return (int)Math.round(dd * this.Cn.getPixel());
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            if (!this.getEX().equals("x") && this.Special) {
                if (P.haveBoundOrder()) {
                    this.X[0] = P.getBoundOrder();
                    double dd = Math.sqrt((P.getX() - this.EX.getValue()) * (P.getX() - this.EX.getValue()) + (P.getY() - this.EY.getValue()) * (P.getY() - this.EY.getValue()));
                    return (int)Math.round(dd * this.Cn.getPixel());
                }
                Enumeration e3 = this.V.elements();
                double delta0 = 0.0;
                double delta1 = 0.0;
                double xx = 0.0;
                double yy = 0.0;
                int i = 0;
                if (e3.hasMoreElements()) {
                    Coordinates CS = (Coordinates)e3.nextElement();
                    delta0 = Math.abs(CS.X - P.getX()) + Math.abs(CS.Y - P.getY());
                    xx = CS.X;
                    yy = CS.Y;
                }
                while (e3.hasMoreElements()) {
                    ++i;
                    Coordinates CS = (Coordinates)e3.nextElement();
                    delta1 = Math.abs(CS.X - P.getX()) + Math.abs(CS.Y - P.getY());
                    if (!(delta1 < delta0)) continue;
                    delta0 = delta1;
                    xx = CS.X;
                    yy = CS.Y;
                }
                double dd = Math.sqrt((P.getX() - xx) * (P.getX() - xx) + (P.getY() - yy) * (P.getY() - yy));
                return (int)Math.round(dd * this.Cn.getPixel());
            }
        }
        catch (Exception e4) {
            this.Valid = false;
            return Integer.MAX_VALUE;
        }
        if (this.needsToRecompute()) {
            this.compute();
        }
        Enumeration e5 = this.V.elements();
        double x = 0.0;
        double y = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double dmin = 0.0;
        boolean started = false;
        while (e5.hasMoreElements()) {
            Coordinates c2 = (Coordinates)e5.nextElement();
            double x1 = c2.X;
            double y1 = c2.Y;
            if (!started) {
                dmin = Math.sqrt((P.getX() - x1) * (P.getX() - x1) + (P.getY() - y1) * (P.getY() - y1));
                x0 = x = x1;
                y0 = y = y1;
                started = true;
                continue;
            }
            if (c2.flag) {
                double g;
                double h = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
                if (h < 1.0E-10) {
                    h = 1.0E-10;
                }
                if ((g = (P.getX() - x0) * (x1 - x0) + (P.getY() - y0) * (y1 - y0)) < 0.0) {
                    g = 0.0;
                }
                if (g > h) {
                    g = h;
                }
                double x2 = x0 + g / h * (x1 - x0);
                double y2 = y0 + g / h * (y1 - y0);
                double d2 = Math.sqrt((P.getX() - x2) * (P.getX() - x2) + (P.getY() - y2) * (P.getY() - y2));
                if (d2 < dmin) {
                    dmin = d2;
                    x = x2;
                    y = y2;
                }
            }
            x0 = x1;
            y0 = y1;
        }
        if (started) {
            P.Valid = true;
            double dd = Math.sqrt((P.getX() - x) * (P.getX() - x) + (P.getY() - y) * (P.getY() - y));
            return (int)Math.round(dd * this.Cn.getPixel());
        }
        P.Valid = false;
        return Integer.MAX_VALUE;
    }

    @Override
    public void project(PointObject P) {
        double dvar;
        double varmax;
        double varmin;
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            dvar = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
            }
            if (dvar < 0.0) {
                dvar = -dvar;
            }
            if (dvar == 0.0) {
                dvar = (varmax - varmin) / 100.0;
            } else if (dvar < (varmax - varmin) / 1000.0) {
                dvar = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return;
        }
        try {
            if (!this.getEX().equals("x") && P.isPointOnOrMagnet() && this.Special) {
                if (P.haveBoundOrder()) {
                    this.X[0] = P.getBoundOrder();
                    P.setXY(this.EX.getValue(), this.EY.getValue());
                    return;
                }
                Enumeration e3 = this.V.elements();
                double delta0 = 0.0;
                double delta1 = 0.0;
                double xx = 0.0;
                double yy = 0.0;
                int i = 0;
                int k = 0;
                if (e3.hasMoreElements()) {
                    Coordinates CS = (Coordinates)e3.nextElement();
                    delta0 = Math.abs(CS.X - P.getX()) + Math.abs(CS.Y - P.getY());
                    xx = CS.X;
                    yy = CS.Y;
                }
                while (e3.hasMoreElements()) {
                    ++i;
                    Coordinates CS = (Coordinates)e3.nextElement();
                    delta1 = Math.abs(CS.X - P.getX()) + Math.abs(CS.Y - P.getY());
                    if (!(delta1 < delta0)) continue;
                    k = i;
                    delta0 = delta1;
                    xx = CS.X;
                    yy = CS.Y;
                }
                P.setXY(xx, yy);
                P.setBoundOrder(varmin + (double)k * dvar);
                return;
            }
        }
        catch (Exception e4) {
            this.Valid = false;
            return;
        }
        try {
            if (P.isPointOnOrMagnet() && this.getEX().equals("x")) {
                double x = P.getX() < varmin ? varmin : P.getX();
                x = P.getX() > varmax ? varmax : x;
                double y = this.evaluateF(x);
                P.move(x, y);
                return;
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        if (this.needsToRecompute()) {
            this.compute();
        }
        Enumeration e5 = this.V.elements();
        double x = 0.0;
        double y = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double dmin = 0.0;
        boolean started = false;
        while (e5.hasMoreElements()) {
            Coordinates c2 = (Coordinates)e5.nextElement();
            double x1 = c2.X;
            double y1 = c2.Y;
            if (!started) {
                dmin = Math.sqrt((P.getX() - x1) * (P.getX() - x1) + (P.getY() - y1) * (P.getY() - y1));
                x0 = x = x1;
                y0 = y = y1;
                started = true;
                continue;
            }
            if (c2.flag) {
                double g;
                double h = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
                if (h < 1.0E-10) {
                    h = 1.0E-10;
                }
                if ((g = (P.getX() - x0) * (x1 - x0) + (P.getY() - y0) * (y1 - y0)) < 0.0) {
                    g = 0.0;
                }
                if (g > h) {
                    g = h;
                }
                double x2 = x0 + g / h * (x1 - x0);
                double y2 = y0 + g / h * (y1 - y0);
                double d2 = Math.sqrt((P.getX() - x2) * (P.getX() - x2) + (P.getY() - y2) * (P.getY() - y2));
                if (d2 < dmin) {
                    dmin = d2;
                    x = x2;
                    y = y2;
                }
            }
            x0 = x1;
            y0 = y1;
        }
        if (started) {
            P.setXY(x, y);
            P.Valid = true;
        } else {
            P.Valid = false;
        }
    }

    public double getSum() {
        double dvar;
        double varmax;
        double varmin;
        boolean reverse = false;
        boolean parametric = !this.getEX().equals(this.getVar());
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            dvar = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
                reverse = true;
            }
            if (dvar < 0.0) {
                dvar = -dvar;
            }
            if (dvar == 0.0) {
                dvar = (varmax - varmin) / 100.0;
            } else if (dvar < (varmax - varmin) / 1000.0) {
                dvar = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return 0.0;
        }
        this.X[0] = varmin;
        double x0 = 0.0;
        double y0 = 0.0;
        boolean started = false;
        double sum = 0.0;
        while (true) {
            try {
                double x1 = this.EX.getValue();
                double y1 = this.EY.getValue();
                if (parametric) {
                    double x = 0.0;
                    double y = 0.0;
                    if (this.getCenter() != null) {
                        x = this.getCenter().getX();
                        y = this.getCenter().getY();
                    }
                    if (started) {
                        sum += ((x0 - x) * (y1 - y) - (y0 - y) * (x1 - x)) / 2.0;
                    }
                } else if (started) {
                    sum = this.Special ? (reverse ? (sum += (x1 - x0) * y1) : (sum += (x1 - x0) * y0)) : (sum += (x1 - x0) * (y0 + y1) / 2.0);
                }
                x0 = x1;
                y0 = y1;
                started = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.X[0] >= varmax) break;
            this.X[0] = this.X[0] + dvar;
            if (!(this.X[0] > varmax)) continue;
            this.X[0] = varmax;
        }
        return sum;
    }

    public double getLength() {
        double dvar;
        double varmax;
        double varmin;
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            dvar = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
            }
            if (dvar < 0.0) {
                dvar = -dvar;
            }
            if (dvar == 0.0) {
                dvar = (varmax - varmin) / 100.0;
            } else if (dvar < (varmax - varmin) / 1000.0) {
                dvar = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return 0.0;
        }
        this.X[0] = varmin;
        double x0 = 0.0;
        double y0 = 0.0;
        boolean started = false;
        double sum = 0.0;
        while (true) {
            try {
                double x1 = this.EX.getValue();
                double y1 = this.EY.getValue();
                if (started) {
                    sum += Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
                }
                started = true;
                x0 = x1;
                y0 = y1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.X[0] >= varmax) break;
            this.X[0] = this.X[0] + dvar;
            if (!(this.X[0] > varmax)) continue;
            this.X[0] = varmax;
        }
        return sum;
    }

    @Override
    public boolean isSpecial() {
        return this.Special;
    }

    @Override
    public void setSpecial(boolean f2) {
        this.Special = f2;
    }

    @Override
    public void project(PointObject P, double alpha) {
        this.project(P);
    }

    @Override
    public boolean maybeTransparent() {
        return true;
    }

    @Override
    public boolean canDisplayName() {
        return false;
    }

    public void setCenter(String s) {
        if (this.Cn == null) {
            return;
        }
        this.Center = new Expression("@\"" + s + "\"", this.Cn, this);
    }

    @Override
    public boolean isFilledForSelect() {
        return false;
    }

    public PointObject getCenter() {
        try {
            return (PointObject)this.Center.getObject();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String getVar() {
        String vars = this.Var[0];
        for (int i = 1; i < this.Var.length; ++i) {
            vars = vars + " " + this.Var[i];
        }
        return vars;
    }

    @Override
    public boolean canInteresectWith(ConstructionObject o) {
        return true;
    }

    @Override
    public boolean isDriverObject() {
        return true;
    }

    @Override
    public boolean somethingChanged() {
        boolean b2 = !this.EX.toString().equals(this.LASTEX);
        b2 = b2 || !this.EY.toString().equals(this.LASTEY);
        return b2;
    }

    @Override
    public void clearChanges() {
        this.LASTEX = this.EX.toString();
        this.LASTEY = this.EY.toString();
    }

    @Override
    public void repulse(PointObject P) {
        this.project(P);
    }
}

