/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.objects.MoveableObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.SimulationObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.expression.InvalidException;
import java.util.Enumeration;

public class FixedCircleObject
extends PrimitiveCircleObject
implements MoveableObject,
SimulationObject {
    Expression E;
    boolean EditAborted = false;
    boolean Dragable = false;
    double x1;
    double y1;
    double x2;
    double y2;

    public FixedCircleObject(Construction c2, PointObject p1, double x, double y) {
        super(c2, p1);
        this.init(c2, x, y);
    }

    public void init(Construction c2, double x, double y) {
        this.E = new Expression("" + Math.sqrt((x - this.M.getX()) * (x - this.M.getX()) + (y - this.M.getY()) * (y - this.M.getY())), c2, this);
        this.validate();
        this.updateText();
    }

    @Override
    public String getTag() {
        return "Circle";
    }

    @Override
    public void updateText() {
        if (this.E == null || !this.E.isValid()) {
            return;
        }
        this.setText(FixedCircleObject.text2(Global.name("text.fixedcircle"), this.M.getName(), "" + this.E.toString()));
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.M.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X = this.M.getX();
        this.Y = this.M.getY();
        if (this.E != null && !this.E.isValid()) {
            return;
        }
        try {
            if (this.E != null) {
                this.R = this.E.getValue();
            }
        }
        catch (Exception e2) {
            this.R = 0.0;
            this.Valid = false;
        }
        if (this.R < -1.0E-10) {
            this.Valid = false;
            return;
        }
    }

    @Override
    public void printArgs(XmlWriter xml) {
        if (this.E.isValid()) {
            xml.printArg("fixed", this.E.toString());
        } else {
            xml.printArg("fixed", "" + this.R);
        }
        if (this.Dragable) {
            xml.printArg("dragable", "true");
        }
        super.printArgs(xml);
    }

    @Override
    public boolean canFix() {
        return true;
    }

    @Override
    public boolean fixed() {
        return true;
    }

    @Override
    public void setFixed(String s) {
        this.E = new Expression(s, this.getConstruction(), this);
    }

    @Override
    public void round() {
        try {
            this.setFixed(this.round(this.E.getValue(), ZirkelCanvas.LengthsFactor) + "");
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (!this.Valid && this.M.valid()) {
            return this.M.nearto(c2, r, zc);
        }
        return super.nearto(c2, r, zc);
    }

    public boolean isValidFix() {
        return this.E.isValid();
    }

    @Override
    public void translate() {
        super.translate();
        try {
            this.setFixed(this.E.toString());
            this.E.translate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getStringLength() {
        return this.E.toString();
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    @Override
    public Enumeration depending() {
        super.depending();
        Enumeration e2 = this.E.getDepList().elements();
        while (e2.hasMoreElements()) {
            DL.add((ConstructionObject)e2.nextElement());
        }
        return DL.elements();
    }

    @Override
    public void move(double x, double y) {
        this.init(this.getConstruction(), x, y);
    }

    @Override
    public boolean moveable() {
        return this.Dragable || this.M.moveable();
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    public boolean isEditAborted() {
        return this.EditAborted;
    }

    @Override
    public boolean isDragable() {
        return this.Dragable;
    }

    @Override
    public void setDragable(boolean f2) {
        this.Dragable = f2;
    }

    public boolean fixedByNumber() {
        return this.E != null && this.E.isNumber();
    }

    @Override
    public void setSimulationValue(double x) {
        this.R = x;
        Expression OldE = this.E;
        this.E = null;
        this.validate();
        this.E = OldE;
    }

    @Override
    public void resetSimulationValue() {
        this.validate();
    }

    @Override
    public void startDrag(double x, double y) {
        this.x1 = this.M.getX();
        this.y1 = this.M.getY();
        this.x2 = x;
        this.y2 = y;
    }

    @Override
    public void dragTo(double x, double y) {
        if (this.Dragable) {
            this.move(x, y);
        } else {
            this.M.move(this.x1 + (x - this.x2), this.y1 + (y - this.y2));
        }
    }

    @Override
    public double getOldX() {
        return 0.0;
    }

    @Override
    public double getOldY() {
        return 0.0;
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        if (this.moveable() && !this.Dragable) {
            this.M.snap(zc);
        }
    }
}

