/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.objects.IntersectionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.structures.Coordinates;

public class CircleIntersectionObject
extends IntersectionObject {
    public CircleIntersectionObject(Construction c2, PrimitiveCircleObject P1, PrimitiveCircleObject P2, boolean first) {
        super(c2, P1, P2);
        this.First = first;
        this.validate();
    }

    @Override
    public void updateCircleDep() {
        ((PrimitiveCircleObject)this.P1).addDep(this);
        ((PrimitiveCircleObject)this.P2).addDep(this);
    }

    @Override
    public void validate() {
        boolean oldvalid = this.Valid;
        this.Valid = this.P1.valid() && this.P2.valid();
        if (!this.Valid) {
            return;
        }
        Coordinates c2 = PrimitiveCircleObject.intersect((PrimitiveCircleObject)this.P1, (PrimitiveCircleObject)this.P2);
        if (c2 == null) {
            if (oldvalid && this.getConstruction().shouldSwitch()) {
                this.doSwitch();
                if (!this.getConstruction().noteSwitch()) {
                    this.Switched = false;
                }
            } else if (oldvalid && this.Alternate && this.Away == null && this.getConstruction().canAlternate()) {
                this.First = !this.First;
            }
            this.Valid = false;
            return;
        }
        PointObject oa = this.getAway();
        if (oa != null) {
            double r1;
            boolean flag;
            double y;
            double x = oa.getX();
            double r = (x - c2.X) * (x - c2.X) + ((y = oa.getY()) - c2.Y) * (y - c2.Y);
            boolean bl = flag = r > (r1 = (x - c2.X1) * (x - c2.X1) + (y - c2.Y1) * (y - c2.Y1));
            if (!this.StayAway) {
                boolean bl2 = flag = !flag;
            }
            if (flag) {
                this.setXY(c2.X, c2.Y);
            } else {
                this.setXY(c2.X1, c2.Y1);
            }
        } else if (this.First) {
            this.setXY(c2.X, c2.Y);
        } else {
            this.setXY(c2.X1, c2.Y1);
        }
        if (this.Restricted) {
            if (((PrimitiveCircleObject)this.P1).getStart() != this && ((PrimitiveCircleObject)this.P1).getEnd() != this && !((PrimitiveCircleObject)this.P1).contains(this.X, this.Y)) {
                this.Valid = false;
            }
            if (((PrimitiveCircleObject)this.P2).getStart() != this && ((PrimitiveCircleObject)this.P2).getEnd() != this && !((PrimitiveCircleObject)this.P2).contains(this.X, this.Y)) {
                this.Valid = false;
            }
        }
    }

    @Override
    public void printArgs(XmlWriter xml) {
        super.printArgs(xml);
        if (this.First) {
            xml.printArg("which", "first");
        } else {
            xml.printArg("which", "second");
        }
    }

    @Override
    public boolean isSwitchable() {
        return true;
    }

    @Override
    public boolean canAlternate() {
        return true;
    }
}

