/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.restrict;

import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.util.ArrayList;
import java.util.Arrays;

public class RestrictItems {
    private ZirkelCanvas ZC;
    private ArrayList<String> hiddenItems = new ArrayList();
    public static final String DISK = "z_disk";
    public static final String EDIT = "z_edit";
    public static final String GEOM = "z_geom";
    public static final String ASPECT = "z_aspect";
    public static final String FUNC = "z_func";
    public static final String TEST = "z_test";
    public static final String CTRL = "z_ctrl";
    public static final String GRID = "z_grid";
    public static final String HIST = "z_hist";
    public static final String BACK = "z_back";
    public static final String SIZE = "z_size";
    public static final String PREC = "z_prec";
    public static final String MENU = "x_menu";
    public static final String MCRP = "x_macr";
    public static final String HISTP = "x_hist";
    public static final String HLPP = "x_help";
    public static final String LMCR = "x_lmcr";
    public static String[] geom_icns;
    public static String[] disk_icns;
    public static String[] edit_icns;
    public static String[] func_icns;
    public static String[] test_icns;
    public static String[] control_icns;
    public static String[] grid_icns;
    public static String[] history_icns;
    public static String[] back_icns;
    public static String[] size_icns;
    public static String[] prec_icns;
    public static String standardRestrictedHiddenItems;

    public RestrictItems(ZirkelCanvas zc) {
        this.ZC = zc;
    }

    public boolean isRestricted() {
        return this.hiddenItems.size() > 0;
    }

    public boolean isHidden(String s) {
        for (int i = 0; i < this.hiddenItems.size(); ++i) {
            if (!s.equals(this.hiddenItems.get(i))) continue;
            return true;
        }
        return false;
    }

    public void add(String s) {
        if (!this.isHidden(s)) {
            this.hiddenItems.add(s);
        }
    }

    public void remove(String s) {
        this.hiddenItems.remove(s);
    }

    public ArrayList<String> get() {
        return this.hiddenItems;
    }

    public void set(String items) {
        this.hiddenItems = new ArrayList<String>(Arrays.asList(items.split(",")));
    }

    public void set(ArrayList<String> items) {
        this.hiddenItems.clear();
        for (int i = 0; i < items.size(); ++i) {
            this.hiddenItems.add(items.get(i));
        }
    }

    public void initRestrictedHiddenItemsFromFactorySettings() {
        if (this.hiddenItems.size() > 0) {
            this.hiddenItems = new ArrayList<String>(Arrays.asList(standardRestrictedHiddenItems.split(",")));
        }
    }

    public void initRestrictedHiddenItems() {
        if (this.hiddenItems.size() == 0) {
            String items = Global.getParameter("standardRestrictedHiddenItems", standardRestrictedHiddenItems);
            this.hiddenItems = "".equals(items) ? new ArrayList() : new ArrayList<String>(Arrays.asList(items.split(",")));
        }
    }

    public void setStandardRestrictedItems() {
        if (this.hiddenItems.size() > 0) {
            Global.setParameter("standardRestrictedHiddenItems", this.getHiddenItems());
        }
    }

    public String getHiddenItems() {
        String items = this.hiddenItems.toString();
        items = items.replace(" ", "");
        items = items.replace("[", "");
        items = items.replace("]", "");
        return items;
    }

    public void printArgs(XmlWriter xml) {
        if (this.hiddenItems.size() > 0) {
            xml.startTagStart("RestrictedSession");
            xml.printArg("HiddenIcons", this.getHiddenItems());
            xml.finishTagNewLine();
        }
    }

    public static void init_disk_icns(String[] icns) {
        disk_icns = icns;
    }

    public static void init_edit_icns(String[] icns) {
        edit_icns = icns;
    }

    public static void init_geom_icns(String[] icns) {
        geom_icns = icns;
    }

    public static void init_func_icns(String[] icns) {
        func_icns = icns;
    }

    public static void init_test_icns(String[] icns) {
        test_icns = icns;
    }

    public static void init_control_icns(String[] icns) {
        control_icns = icns;
    }

    public static void init_grid_icns(String[] icns) {
        grid_icns = icns;
    }

    public static void init_history_icns(String[] icns) {
        history_icns = icns;
    }

    public static void init_back_icns(String[] icns) {
        back_icns = icns;
    }

    public static void init_size_icns(String[] icns) {
        size_icns = icns;
    }

    public static void init_prec_icns(String[] icns) {
        prec_icns = icns;
    }

    static {
        standardRestrictedHiddenItems = "save,copy,exportpng,exporteps,edit,animate,grid,z_disk,new,load,bi_trans,intersection,fixedsegment,vector,quadric,image3,z_func,tracker,objecttracker,locus,bi_function_u,function,equationxy,z_test,bi_t_align,bi_t_para,bi_t_perp,bi_t_equi,bi_t_app,bi_t_conf,z_ctrl,ctrl_edit,ctrl_slider,ctrl_popup,ctrl_chkbox,ctrl_txtfield,ctrl_button,z_grid,z_hist,z_back,z_size,z_prec";
    }
}

