/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.macros;

import carmetal.construction.ConstructionException;
import carmetal.construction.Count;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.JZirkelCanvas;
import carmetal.objects.TextObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlReader;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTagPI;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.macro.Macro;
import carmetal.rene.zirkel.macro.MacroItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class MacroTools {
    public static final int LIBRARY_MACRO = 0;
    public static final int FILE_MACRO = 2;
    private static Vector librarymacros = new Vector();
    public static Vector builtinmacros = new Vector();
    public static String MacrosLibraryFileName = "";
    public static String MacrosBackupLibraryFileName = "";

    public static void createLocalDirectory() {
        String mypath = Global.AppPath();
        if (Global.isNewVersion() || !new File(Global.getHomeDirectory() + "docs").exists()) {
            try {
                Global.copyFiles(new File(mypath + "docs"), new File(Global.getHomeDirectory() + "docs"));
            }
            catch (IOException ex) {
                System.out.println("bug : createLocalDirectory()");
            }
        }
        String Filename = "library.mcr";
        if (new File(mypath + Global.name("language", "") + "library.mcr").exists()) {
            Filename = Global.name("language", "") + "library.mcr";
        } else if (new File(Global.getHomeDirectory() + Global.name("language", "") + "library.mcr").exists()) {
            Filename = Global.name("language", "") + "library.mcr";
        }
        MacrosLibraryFileName = Global.getHomeDirectory() + Filename;
        if (new File(MacrosLibraryFileName).exists()) {
            if (Global.isNewVersion()) {
                MacrosBackupLibraryFileName = Global.getHomeDirectory() + "library_backup.mcr";
                Global.copyFile(MacrosLibraryFileName, MacrosBackupLibraryFileName);
                Global.copyFile(mypath + Filename, MacrosLibraryFileName);
            }
        } else {
            new File(Global.getHomeDirectory()).mkdirs();
            Global.copyFile(mypath + Filename, MacrosLibraryFileName);
        }
        Global.makeWindowConfigFolderInvisible();
    }

    public static Vector getBuiltinMacros() {
        return builtinmacros;
    }

    public static Vector getLibraryMacros() {
        return librarymacros;
    }

    public static void clearLibraryMacros() {
        librarymacros.removeAllElements();
    }

    public static void addToLibraryMacros(MacroItem mi) {
        librarymacros.add(mi);
    }

    public static void updateLibraryMacros() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            librarymacros.clear();
            Vector V = zc.getMacros();
            for (int i = 0; i < V.size(); ++i) {
                MacroItem mi = (MacroItem)V.get(i);
                if (!mi.M.isProtected() || mi.M.Name.startsWith("@builtin@")) continue;
                librarymacros.add(V.get(i));
            }
        }
    }

    public static void runBuiltinMacro(String macroname) {
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        if (ZF == null) {
            return;
        }
        Vector mc = builtinmacros;
        for (int i = 0; i < mc.size(); ++i) {
            TextObject t;
            Macro m = ((MacroItem)mc.elementAt((int)i)).M;
            if (!m.getName().equals(macroname)) continue;
            if (m.getName().equals("@builtin@/syma")) {
                m.Prompts[0] = Global.Loc("macro.bi_syma.0");
                m.Prompts[1] = Global.Loc("macro.bi_syma.1");
            } else if (m.getName().equals("@builtin@/symc")) {
                m.Prompts[0] = Global.Loc("macro.bi_symc.0");
                m.Prompts[1] = Global.Loc("macro.bi_symc.1");
            } else if (m.getName().equals("@builtin@/trans")) {
                m.Prompts[0] = Global.Loc("macro.bi_trans.0");
                m.Prompts[1] = Global.Loc("macro.bi_trans.1");
                m.Prompts[2] = Global.Loc("macro.bi_trans.2");
            } else if (m.getName().equals("@builtin@/med")) {
                m.Prompts[0] = Global.Loc("macro.bi_med.0");
                m.Prompts[1] = Global.Loc("macro.bi_med.1");
            } else if (m.getName().equals("@builtin@/biss")) {
                m.Prompts[0] = Global.Loc("macro.bi_biss.0");
                m.Prompts[1] = Global.Loc("macro.bi_biss.1");
                m.Prompts[2] = Global.Loc("macro.bi_biss.2");
            } else if (m.getName().equals("@builtin@/circ")) {
                m.Prompts[0] = Global.Loc("macro.bi_circ.0");
                m.Prompts[1] = Global.Loc("macro.bi_circ.1");
                m.Prompts[2] = Global.Loc("macro.bi_circ.2");
            } else if (m.getName().equals("@builtin@/arc")) {
                m.Prompts[0] = Global.Loc("macro.bi_circ.0");
                m.Prompts[1] = Global.Loc("macro.bi_circ.1");
                m.Prompts[2] = Global.Loc("macro.bi_circ.2");
            } else if (m.getName().equals("@builtin@/function_u")) {
                m.Prompts[0] = Global.Loc("macro.bi_expression.0");
            } else if (m.getName().equals("@builtin@/t_align")) {
                m.Prompts[0] = Global.Loc("macro.bi_circ.0");
                m.Prompts[1] = Global.Loc("macro.bi_circ.1");
                m.Prompts[2] = Global.Loc("macro.bi_circ.2");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(Global.Loc("macro.bi_t_align.text1"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(Global.Loc("macro.bi_t_align.text0"));
            } else if (m.getName().equals("@builtin@/t_para")) {
                m.Prompts[0] = Global.Loc("macro.bi_t_para.0");
                m.Prompts[1] = Global.Loc("macro.bi_t_para.1");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(Global.Loc("macro.bi_t_para.text0"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(Global.Loc("macro.bi_t_para.text1"));
            } else if (m.getName().equals("@builtin@/t_perp")) {
                m.Prompts[0] = Global.Loc("macro.bi_t_para.0");
                m.Prompts[1] = Global.Loc("macro.bi_t_para.1");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(Global.Loc("macro.bi_t_perp.text1"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(Global.Loc("macro.bi_t_perp.text0"));
            } else if (m.getName().equals("@builtin@/t_equi")) {
                m.Prompts[0] = Global.Loc("macro.bi_t_equi.0");
                m.Prompts[1] = Global.Loc("macro.bi_t_equi.1");
                m.Prompts[2] = Global.Loc("macro.bi_t_equi.2");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(Global.Loc("macro.bi_t_equi.text0"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(Global.Loc("macro.bi_t_equi.text1"));
            } else if (m.getName().equals("@builtin@/t_app")) {
                m.Prompts[0] = Global.Loc("macro.bi_t_app.0");
                m.Prompts[1] = Global.Loc("macro.bi_t_app.1");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(Global.Loc("macro.bi_t_app.text1"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(Global.Loc("macro.bi_t_app.text0"));
            } else if (m.getName().equals("@builtin@/t_conf")) {
                m.Prompts[0] = Global.Loc("macro.bi_t_conf.0");
                m.Prompts[1] = Global.Loc("macro.bi_t_conf.1");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(Global.Loc("macro.bi_t_conf.text1"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(Global.Loc("macro.bi_t_conf.text0"));
            } else if (m.getName().equals("@builtin@/3Dcoords")) {
                m.Prompts[4] = Global.Loc("macro.bi_3Dcoords.0");
            } else if (m.getName().equals("@builtin@/3Dcube")) {
                m.Prompts[4] = Global.Loc("macro.bi_3Dcube.0");
            } else if (m.getName().equals("@builtin@/3Darete")) {
                m.Prompts[0] = Global.Loc("macro.bi_3Darete.0");
                m.Prompts[1] = Global.Loc("macro.bi_3Darete.1");
                m.Prompts[2] = Global.Loc("macro.bi_3Darete.2");
                m.Prompts[3] = Global.Loc("macro.bi_3Darete.3");
            } else if (m.getName().equals("@builtin@/3Dtetra")) {
                m.Prompts[4] = Global.Loc("macro.bi_3Dtetra.0");
            } else if (m.getName().equals("@builtin@/3Ddode")) {
                m.Prompts[4] = Global.Loc("macro.bi_3Ddode.0");
            }
            ZF.runMacro(m);
        }
    }

    private static void LoadMacros(InputStream in, Vector Macros) throws Exception {
        XmlReader xml = new XmlReader();
        xml.init(in);
        XmlTree tree = xml.scan();
        if (tree == null) {
            throw new ConstructionException("XML file not recognized");
        }
        Enumeration e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            tree = (XmlTree)e2.nextElement();
            if (tree.getTag() instanceof XmlTagPI) continue;
            if (tree.getTag().name().equals("CaR")) break;
            throw new ConstructionException("CaR tag not found");
        }
        e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            tree = (XmlTree)e2.nextElement();
            XmlTag tag = tree.getTag();
            if (tag.name().equals("Macro")) {
                try {
                    Count.setAllAlternate(true);
                    Macro m = new Macro(null, tree);
                    int i = 0;
                    for (i = 0; i < Macros.size() && !((MacroItem)Macros.elementAt((int)i)).M.getName().equals(m.getName()); ++i) {
                    }
                    if (i >= Macros.size()) {
                        m.setProtected(true);
                        MacroItem mi = new MacroItem(m, null);
                        Macros.addElement(mi);
                    }
                }
                catch (ConstructionException ex) {
                    Count.setAllAlternate(false);
                    throw ex;
                }
                Count.setAllAlternate(false);
                continue;
            }
            throw new ConstructionException("Construction not found");
        }
    }

    public static void LoadDefaultMacrosAtStartup() {
        InputStream o;
        try {
            o = MacroTools.class.getResourceAsStream("/carmetal/builtin.mcr");
            MacroTools.LoadMacros(o, builtinmacros);
            o.close();
        }
        catch (Exception e2) {
            System.out.println("builtinmacros bug");
        }
        if (!themes.isApplet() && new File(MacrosLibraryFileName).exists()) {
            try {
                o = new FileInputStream(MacrosLibraryFileName);
                MacroTools.LoadMacros(o, librarymacros);
                o.close();
                if (!MacrosBackupLibraryFileName.equals("")) {
                    FileInputStream o2 = new FileInputStream(MacrosBackupLibraryFileName);
                    MacroTools.LoadMacros(o2, librarymacros);
                    ((InputStream)o2).close();
                    File f2 = new File(MacrosBackupLibraryFileName);
                    f2.delete();
                }
                return;
            }
            catch (Exception e3) {
                System.out.println("librarymacros bug");
            }
        }
        try {
            o = MacroTools.class.getResourceAsStream("/carmetal/default.mcr");
            MacroTools.LoadMacros(o, librarymacros);
            o.close();
            return;
        }
        catch (Exception e4) {
            System.out.println("default macros bug");
            return;
        }
    }

    public static void saveLibraryToDisk() {
        if (JZirkelCanvas.getCurrentZF() != null) {
            ZirkelFrame ZF = new ZirkelFrame(pipe_tools.isApplet());
            ZF.dosave(MacrosLibraryFileName, false, true, true, false, librarymacros);
        }
    }

    public static void populateMacrosTypeChanges() {
        int max = JZirkelCanvas.getZCsSize();
        for (int i = 0; i < max; ++i) {
            ZirkelCanvas zc = JZirkelCanvas.getZC(i);
            MacroTools.setDefaultMacros(zc);
        }
    }

    public static void setDefaultMacros(ZirkelCanvas zc) {
        if (builtinmacros.size() == 0) {
            MacroTools.LoadDefaultMacrosAtStartup();
        }
        if (zc != null) {
            int i = 0;
            Vector F = new Vector();
            Vector V = zc.getMacros();
            for (i = 0; i < V.size(); ++i) {
                MacroItem mi = (MacroItem)V.get(i);
                if (mi.M.isProtected()) continue;
                F.add(V.get(i));
            }
            V.clear();
            for (i = 0; i < librarymacros.size(); ++i) {
                zc.appendMacro(((MacroItem)MacroTools.librarymacros.get((int)i)).M);
            }
            for (i = 0; i < F.size(); ++i) {
                zc.appendMacro(((MacroItem)F.get((int)i)).M);
            }
        }
    }
}

