/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.jobs;

import carmetal.eric.FileTools;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.jobs.Base64Coder;
import carmetal.eric.jobs.JobControlPanel;
import carmetal.eric.jobs.JobValidPanel;
import carmetal.eric.jobs.JobValidation;
import carmetal.eric.jobs.StringCompressionUtils;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.tools.DefineJobTool;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;

public class JobManager {
    ZirkelCanvas ZC;
    private String target_names = null;
    private ArrayList<ConstructionObject> targets = new ArrayList();
    private String backup = null;
    private String message_ok = Global.getParameter("job.message.ok", Global.Loc("job.message.ok"));
    private String message_failed = Global.getParameter("job.message.failed", Global.Loc("job.message.failed"));
    private boolean hidefinals = false;
    private JobControlPanel controlPanel = null;
    private JobValidPanel validPanel = null;
    private boolean printExerciseArguments = true;
    private int ctrlX = 3;
    private int ctrlY = 3;
    private int ctrlW = 374;
    private int ctrlH = 133;
    private int validX;
    private int validY;
    private int validW = 550;
    private int validH = 36;

    public JobManager(ZirkelCanvas zc) {
        this.ZC = zc;
    }

    public void backup() {
        try {
            this.printExerciseArguments = false;
            String file = FileTools.getCurrentFileSource();
            this.printExerciseArguments = true;
            byte[] b2 = StringCompressionUtils.Compress(file.getBytes());
            this.backup = new String(Base64Coder.encode(b2));
        }
        catch (Exception ex) {
            System.out.println("backup error");
        }
    }

    public void restore() {
        if (this.backup != null) {
            try {
                String targets_backup = this.getTargetNames();
                byte[] b2 = Base64Coder.decode(this.backup);
                byte[] b1 = StringCompressionUtils.Decompress(b2);
                FileTools.setCurrentFileSource(new String(b1));
                this.setTargets(targets_backup);
                this.setTargetsColor(true);
                this.setHiddenToSuperHidden();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ArrayList<ConstructionObject> getTargets() {
        return this.targets;
    }

    public String getTargetNames() {
        String names = "";
        for (int i = 0; i < this.targets.size(); ++i) {
            names = names + ";" + this.targets.get(i).getName();
        }
        return names.replaceFirst(";", "");
    }

    public void setTargetNames(String t) {
        this.target_names = t;
    }

    public void setTargets() {
        if (this.target_names != null) {
            this.setTargets(this.target_names);
            this.target_names = null;
            this.setTargetsColor(true);
            this.addValidPanel();
        }
    }

    public void setTargets(String t) {
        this.setTargetSelected(false);
        this.targets.clear();
        String[] names = t.split(";");
        for (int i = 0; i < names.length; ++i) {
            ConstructionObject o = this.ZC.getConstruction().find(names[i]);
            if (o == null) continue;
            this.targets.add(o);
        }
        this.setTargetSelected(true);
    }

    public void addTarget(ConstructionObject o) {
        this.targets.add(o);
    }

    public void removeTarget(ConstructionObject o) {
        this.targets.remove(o);
    }

    public void setTargetSelected(boolean sel) {
        for (int i = 0; i < this.targets.size(); ++i) {
            this.targets.get(i).setSelected(sel);
        }
        this.ZC.repaint();
    }

    public void setHiddenToSuperHidden() {
        Enumeration e2 = this.ZC.getConstruction().elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (!c2.isHidden(true)) continue;
            c2.setSuperHidden(true);
        }
        this.ZC.reloadCD();
    }

    public void setSuperHiddenToHidden() {
        Enumeration e2 = this.ZC.getConstruction().elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            if (!c2.isSuperHidden(true)) continue;
            c2.setSuperHidden(false);
            c2.setHidden(true);
        }
        this.ZC.reloadCD();
    }

    public void setTargetsColor(boolean select) {
        int i;
        Enumeration e2 = this.ZC.getConstruction().elements();
        while (e2.hasMoreElements()) {
            ConstructionObject c2 = (ConstructionObject)e2.nextElement();
            c2.setJobTarget(false);
        }
        for (i = 0; i < this.targets.size(); ++i) {
            this.targets.get(i).setSuperHidden(false);
        }
        if (select) {
            for (i = 0; i < this.targets.size(); ++i) {
                this.targets.get(i).setJobTarget(true);
                this.targets.get(i).setSuperHidden(this.hidefinals);
            }
        }
        this.ZC.repaint();
    }

    public String getMessage_ok() {
        return this.message_ok;
    }

    public void setMessage_ok(String mess_ok) {
        this.message_ok = mess_ok;
        Global.setParameter("job.message.ok", this.message_ok);
    }

    public String getMessage_failed() {
        return this.message_failed;
    }

    public void setMessage_failed(String mess_failed) {
        this.message_failed = mess_failed;
        Global.setParameter("job.message.failed", this.message_failed);
    }

    public boolean isHidefinals() {
        return this.hidefinals;
    }

    public void setHidefinals(boolean hidef) {
        this.hidefinals = hidef;
    }

    public void setBackup(String s) {
        this.backup = s;
    }

    public void printArgs(XmlWriter xml) {
        if (this.targets.size() > 0 && this.printExerciseArguments) {
            xml.startTagStart("Exercise");
            xml.printArg("message_ok", this.message_ok);
            xml.printArg("message_failed", this.message_failed);
            xml.printArg("hidefinals", String.valueOf(this.hidefinals));
            xml.printArg("targets", this.getTargetNames());
            xml.printArg("backup", this.backup);
            xml.finishTagNewLine();
        }
    }

    public void init() {
        if (this.controlPanel != null) {
            this.controlPanel.init();
        } else if (this.validPanel != null) {
            this.validPanel.init(this.ZC.getSize().width, this.ZC.getSize().height);
        }
    }

    public void addControlPanel() {
        this.removeControlPanel();
        this.controlPanel = new JobControlPanel(this, this.ctrlX, this.ctrlY, this.ctrlW, this.ctrlH);
        this.ZC.add((Component)this.controlPanel, 0);
        this.ZC.repaint();
        this.init();
    }

    public void removeControlPanel() {
        if (this.controlPanel != null) {
            this.ctrlX = this.controlPanel.getLocation().x;
            this.ctrlY = this.controlPanel.getLocation().y;
            this.ZC.remove(this.controlPanel);
            this.controlPanel = null;
            this.ZC.repaint();
        }
    }

    public void addValidPanel() {
        this.removeValidPanel();
        if (this.targets.size() > 0) {
            this.validPanel = new JobValidPanel(this, 0, 0, this.validW, this.validH);
            this.ZC.add((Component)this.validPanel, 0);
            this.ZC.repaint();
            this.init();
        }
    }

    public void removeValidPanel() {
        if (this.validPanel != null) {
            this.ZC.remove(this.validPanel);
            this.validPanel = null;
            this.ZC.repaint();
        }
    }

    public void cancelControlDialog() {
        this.hideControlDialog(false);
    }

    public void hideControlDialog(boolean createJob) {
        this.setTargetSelected(false);
        this.removeControlPanel();
        pipe_tools.getContent().requestFocus();
        if (createJob && this.targets.size() > 0) {
            this.backup();
            this.addValidPanel();
            this.setHiddenToSuperHidden();
        } else {
            this.targets.clear();
            this.backup = null;
            this.setSuperHiddenToHidden();
        }
        this.setTargetsColor(true);
        PaletteManager.ClicOn("point");
    }

    public void showControlDialog() {
        this.removeValidPanel();
        this.restore();
        this.setTargetsColor(false);
        this.setSuperHiddenToHidden();
        this.addControlPanel();
        this.setTargetsField();
        this.setJobTool();
    }

    public void setJobTool() {
        this.setTargetSelected(true);
        PaletteManager.deselectgeomgroup();
        this.ZC.setTool(new DefineJobTool());
    }

    public void setTargetsField() {
        if (this.controlPanel != null) {
            this.controlPanel.setTargetslist(this.getTargetNames());
        }
    }

    public void validate() {
        JobValidation v = new JobValidation(this.ZC);
        v.checkAllsteps();
    }
}

