/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.jobs;

import carmetal.eric.GUI.ZDialog.ZButton;
import carmetal.eric.GUI.ZDialog.ZCheckBox;
import carmetal.eric.GUI.ZDialog.ZDialog;
import carmetal.eric.GUI.ZDialog.ZTextFieldAndLabel;
import carmetal.eric.jobs.JobManager;
import carmetal.rene.gui.Global;

public class JobControlPanel
extends ZDialog {
    private ZButton createBTN;
    private ZButton removeBTN;
    private ZCheckBox hideFinalBox;
    private ZTextFieldAndLabel okMessage;
    private ZTextFieldAndLabel failedMessage;
    private ZTextFieldAndLabel targetslist;
    private JobManager MAN;

    public JobControlPanel(JobManager man, int x, int y, int w, int h) {
        super(Global.Loc("job.gui.title"), x, y, w, h, true, true);
        this.MAN = man;
        this.createBTN = new ZButton(Global.Loc("job.gui.close")){

            @Override
            public void action() {
                JobControlPanel.this.MAN.hideControlDialog(true);
            }
        };
        this.removeBTN = new ZButton(Global.Loc("job.gui.delete")){

            @Override
            public void action() {
                JobControlPanel.this.MAN.hideControlDialog(false);
            }
        };
        this.okMessage = new ZTextFieldAndLabel(Global.Loc("job.gui.ok"), man.getMessage_ok(), this.LWIDTH, this.CHEIGHT){

            @Override
            public void actionKey() {
                JobControlPanel.this.MAN.setMessage_ok(JobControlPanel.this.okMessage.getText());
            }
        };
        this.failedMessage = new ZTextFieldAndLabel(Global.Loc("job.gui.failed"), man.getMessage_failed(), this.LWIDTH, this.CHEIGHT){

            @Override
            public void actionKey() {
                JobControlPanel.this.MAN.setMessage_failed(JobControlPanel.this.failedMessage.getText());
            }
        };
        this.targetslist = new ZTextFieldAndLabel(Global.Loc("job.gui.targets"), man.getTargetNames(), 0, this.CHEIGHT){

            @Override
            public void actionMouse() {
                JobControlPanel.this.MAN.setJobTool();
            }

            @Override
            public void actionKey() {
                JobControlPanel.this.MAN.setTargets(JobControlPanel.this.targetslist.getText());
            }
        };
        this.hideFinalBox = new ZCheckBox(Global.Loc("job.gui.hidebox"), man.isHidefinals()){

            @Override
            public void action() {
                JobControlPanel.this.MAN.setHidefinals(JobControlPanel.this.hideFinalBox.isSelected());
            }
        };
        this.add(this.createBTN);
        this.add(this.removeBTN);
        this.add(this.hideFinalBox);
        this.add(this.okMessage);
        this.add(this.failedMessage);
        this.add(this.targetslist);
        this.fixComponents();
    }

    @Override
    public void fixComponents() {
        this.targetslist.setBounds(this.MARGINW, this.MARGINTOP1, this.CWIDTH, this.CHEIGHT);
        this.okMessage.setBounds(this.MARGINW, this.MARGINTOP2, this.CWIDTH, this.CHEIGHT);
        this.failedMessage.setBounds(this.MARGINW, this.MARGINTOP3, this.CWIDTH, this.CHEIGHT);
        this.hideFinalBox.setBounds(this.MARGINW, this.MARGINTOP4, this.CWIDTH, this.CHEIGHT);
        this.createBTN.setBounds(this.D_WIDTH - this.BWIDTH - this.MARGINW, this.MARGINTOP4, this.BWIDTH, this.CHEIGHT);
        this.removeBTN.setBounds(this.D_WIDTH - this.MARGINW - this.CWIDTH + this.LWIDTH, this.MARGINTOP4, this.BWIDTH, this.CHEIGHT);
    }

    @Override
    public void doClose() {
        this.MAN.cancelControlDialog();
    }

    public String getTargetslist() {
        return this.targetslist.getText();
    }

    public void setTargetslist(String targets) {
        this.targetslist.setText(targets);
    }
}

