/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.controls;

import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class SliderSnap
extends BasicSliderUI {
    private static Class sliderClass;
    private static Method xForVal;
    private static Method yForVal;
    private static ReinitListener reinitListener;

    public SliderSnap() {
        super(null);
    }

    public static ComponentUI createUI(JComponent c2) {
        if (c2 == null || sliderClass == null) {
            return null;
        }
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        try {
            ComponentUI uiObject;
            Method m = (Method)defaults.get(sliderClass);
            if (m == null) {
                m = sliderClass.getMethod("createUI", JComponent.class);
                defaults.put(sliderClass, m);
            }
            if ((uiObject = (ComponentUI)m.invoke(null, c2)) instanceof BasicSliderUI) {
                c2.addHierarchyListener(new MouseAttacher());
            }
            return uiObject;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void init() {
        if (sliderClass != null) {
            return;
        }
        Init init = new Init();
        if (EventQueue.isDispatchThread()) {
            init.run();
        } else {
            try {
                EventQueue.invokeAndWait(init);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static void attachTo(JSlider c2) {
        MouseMotionListener[] listeners;
        for (MouseMotionListener m : listeners = c2.getMouseMotionListeners()) {
            if (!(m instanceof BasicSliderUI.TrackListener)) continue;
            c2.removeMouseMotionListener(m);
            SnapListener listen = new SnapListener(m, (BasicSliderUI)c2.getUI(), c2);
            c2.addMouseMotionListener(listen);
            c2.addMouseListener(listen);
            c2.addPropertyChangeListener("UI", listen);
        }
    }

    static {
        reinitListener = new ReinitListener();
    }

    private static class SnapListener
    extends MouseInputAdapter
    implements PropertyChangeListener {
        private final MouseMotionListener delegate;
        private final BasicSliderUI ui;
        private final JSlider slider;
        private int offset;

        public SnapListener(MouseMotionListener delegate, BasicSliderUI ui, JSlider slider) {
            this.delegate = delegate;
            this.ui = ui;
            this.slider = slider;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("UI".equals(evt.getPropertyName())) {
                this.slider.removeMouseMotionListener(this);
                this.slider.removeMouseListener(this);
                this.slider.removePropertyChangeListener("UI", this);
                SliderSnap.attachTo(this.slider);
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            int pos;
            if (this.slider.getSnapToTicks() && (pos = this.getLocationForValue(this.getSnappedValue(evt))) > -1) {
                if (this.slider.getOrientation() == 0) {
                    evt.translatePoint(pos - evt.getX() + this.offset, 0);
                } else {
                    evt.translatePoint(0, pos - evt.getY() + this.offset);
                }
            }
            this.delegate.mouseDragged(evt);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            int pos = this.slider.getOrientation() == 0 ? evt.getX() : evt.getY();
            int loc = this.getLocationForValue(this.getSnappedValue(evt));
            this.offset = loc < 0 ? 0 : pos - loc;
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            this.delegate.mouseMoved(evt);
        }

        public int getSnappedValue(MouseEvent evt) {
            int value;
            int snappedValue = value = this.slider.getOrientation() == 0 ? this.ui.valueForXPosition(evt.getX()) : this.ui.valueForYPosition(evt.getY());
            int tickSpacing = 0;
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0 && (value - this.slider.getMinimum()) % tickSpacing != 0) {
                float temp = (float)(value - this.slider.getMinimum()) / (float)tickSpacing;
                snappedValue = this.slider.getMinimum() + Math.round(temp) * tickSpacing;
            }
            return snappedValue;
        }

        public int getLocationForValue(int value) {
            try {
                Method m = this.slider.getOrientation() == 0 ? xForVal : yForVal;
                Integer result = (Integer)m.invoke((Object)this.ui, new Integer(value));
                return result;
            }
            catch (InvocationTargetException e2) {
                return -1;
            }
            catch (IllegalAccessException e3) {
                return -1;
            }
        }
    }

    private static class Init
    implements Runnable {
        private Init() {
        }

        @Override
        public void run() {
            try {
                UIDefaults defaults = UIManager.getLookAndFeelDefaults();
                sliderClass = defaults.getUIClass("SliderUI");
                xForVal = BasicSliderUI.class.getDeclaredMethod("xPositionForValue", Integer.TYPE);
                yForVal = BasicSliderUI.class.getDeclaredMethod("yPositionForValue", Integer.TYPE);
                xForVal.setAccessible(true);
                yForVal.setAccessible(true);
                defaults.put("SliderUI", SliderSnap.class.getName());
                UIManager.addPropertyChangeListener(reinitListener);
            }
            catch (Exception e2) {
                sliderClass = null;
                xForVal = (yForVal = null);
            }
        }
    }

    private static class ReinitListener
    implements PropertyChangeListener {
        private ReinitListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("lookAndFeel".equals(evt.getPropertyName())) {
                sliderClass = null;
                xForVal = (yForVal = null);
                UIManager.removePropertyChangeListener(reinitListener);
                SliderSnap.init();
            }
        }
    }

    private static class MouseAttacher
    implements HierarchyListener {
        private MouseAttacher() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent evt) {
            long flags = evt.getChangeFlags();
            if ((flags & 2L) > 0L && evt.getComponent() instanceof JSlider) {
                JSlider c2 = (JSlider)evt.getComponent();
                c2.removeHierarchyListener(this);
                SliderSnap.attachTo(c2);
            }
        }
    }
}

