/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.controls;

import carmetal.eric.controls.JCanvasPanel;
import carmetal.objects.ExpressionObject;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JCanvasSlider
extends JCanvasPanel {
    private static final long serialVersionUID = 1L;
    static int PREFEREDVMAX = 10000;
    int VMAX = PREFEREDVMAX;
    int TICKS = 1000;
    double xMIN;
    double xMAX;
    double xTICKS;
    MyJSlider JCS;

    public JCanvasSlider(ZirkelCanvas zc, ExpressionObject o, double min, double max, double val) {
        super(zc, o);
        this.xMIN = min;
        this.xMAX = max;
        this.xTICKS = this.getCurrentTicks();
        this.setVal(val);
        this.JSL = new MyJSlider(0, this.VMAX, this.TICKS, (int)Math.round((val - this.xMIN) * (double)this.VMAX / (this.xMAX - this.xMIN)));
        this.JSL.putClientProperty("JComponent.sizeVariant", "regular");
        this.JCS = (MyJSlider)this.JSL;
        this.JCS.addMouseListener(this);
        this.JCS.addMouseMotionListener(this);
        this.setComment(this.O.getName() + "=");
        this.add(this.JCS);
        this.add(this.JCPlabel);
        this.add(this.JCPresize);
        zc.add(this);
    }

    public void setGoodKnobPos(double x) {
        int i = (int)Math.round((x - this.xMIN) * ((double)this.VMAX / (this.xMAX - this.xMIN)));
        this.JCS.setValue(i);
    }

    public double getCurrentTicks() {
        return (double)this.TICKS * (this.xMAX - this.xMIN) / (double)this.VMAX;
    }

    public void setTicks(String s) {
        this.setTicks(Double.parseDouble(s));
    }

    public void setTicks(double x) {
        this.xTICKS = x;
        this.adjustVirtualMax();
        this.TICKS = (int)Math.round(x * (double)this.VMAX / (this.xMAX - this.xMIN));
        this.JCS.setMinorTickSpacing(this.TICKS);
        this.revalidate();
        this.repaint();
    }

    public String getTicks() {
        return String.valueOf(this.xTICKS);
    }

    public void adjustVirtualMax() {
        if (this.xMAX - this.xMIN < 1.0) {
            return;
        }
        int mySQRT = (int)Math.round(Math.sqrt(PREFEREDVMAX));
        this.VMAX = (int)Math.round(Math.ceil((double)mySQRT / (this.xMAX - this.xMIN)) * (this.xMAX - this.xMIN));
        this.VMAX *= (int)Math.round(Math.ceil((double)mySQRT / this.xTICKS) * this.xTICKS);
        this.JCS.setMaximum(this.VMAX);
    }

    public void setMax(String s) {
        this.setMax(Double.parseDouble(s));
    }

    public void setMax(double x) {
        this.xMAX = x;
        if (this.xMIN > this.xMAX) {
            this.xMIN = this.xMAX - 10.0;
        }
        this.adjustVirtualMax();
        double newval = this.getVal() > this.xMAX ? this.xMAX : this.getVal();
        newval = this.getVal() < this.xMIN ? this.xMIN : this.getVal();
        this.setVal(newval);
        this.JCS.setValue((int)Math.round((newval - this.xMIN) * (double)this.VMAX / (this.xMAX - this.xMIN)));
        this.setTicks(this.xTICKS);
        this.revalidate();
        this.repaint();
    }

    public String getMax() {
        return String.valueOf(this.xMAX);
    }

    public void setMin(String s) {
        this.setMin(Double.parseDouble(s));
    }

    public void setMin(double x) {
        this.xMIN = x;
        if (this.xMIN > this.xMAX) {
            this.xMAX = this.xMIN + 10.0;
        }
        this.adjustVirtualMax();
        double newval = this.getVal() > this.xMAX ? this.xMAX : this.getVal();
        newval = this.getVal() < this.xMIN ? this.xMIN : this.getVal();
        this.setVal(newval);
        this.JCS.setValue((int)Math.round((newval - this.xMIN) * (double)this.VMAX / (this.xMAX - this.xMIN)));
        this.setTicks(this.xTICKS);
        this.revalidate();
        this.repaint();
    }

    public String getMin() {
        return String.valueOf(this.xMIN);
    }

    public void setSnap(boolean b2) {
        this.JCS.setSnapToTicks(b2);
        this.revalidate();
        this.repaint();
    }

    public boolean getSnap() {
        return this.JCS.getSnapToTicks();
    }

    public void setShowTicks(boolean b2) {
        this.JCS.setPaintTicks(b2);
        this.revalidate();
        this.repaint();
    }

    public boolean getShowTicks() {
        return this.JCS.getPaintTicks();
    }

    @Override
    public double getVal() {
        return this.xMIN + (double)this.JCS.getValue() * (this.xMAX - this.xMIN) / (double)this.VMAX;
    }

    @Override
    public void PrintXmlTags(XmlWriter xml) {
        xml.startTagStart("CTRLslider");
        super.PrintXmlTags(xml);
        xml.printArg("min", "" + this.xMIN);
        xml.printArg("max", "" + this.xMAX);
        xml.printArg("T", "" + this.xTICKS);
        xml.printArg("fixT", "" + this.JCS.getSnapToTicks());
        xml.printArg("showT", "" + this.JCS.getPaintTicks());
        xml.finishTagNewLine();
    }

    class MyJSlider
    extends JSlider
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        int oldvalue;

        MyJSlider(int min, int max, int ticks, int val) {
            super(min, max, val);
            this.oldvalue = val;
            this.setOpaque(false);
            this.setFocusable(false);
            this.setMinorTickSpacing(ticks);
            this.setPaintTicks(true);
            this.setSnapToTicks(true);
            this.setOpaque(false);
            this.addChangeListener(this);
        }

        @Override
        public int getValue() {
            if (JCanvasSlider.this.isEditMode()) {
                return this.oldvalue;
            }
            this.oldvalue = super.getValue();
            return this.oldvalue;
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            try {
                double val = this.getValue();
                val = JCanvasSlider.this.xMIN + (JCanvasSlider.this.xMAX - JCanvasSlider.this.xMIN) / (double)JCanvasSlider.this.VMAX * val;
                if (this.getSnapToTicks()) {
                    int i = (int)Math.round((val - JCanvasSlider.this.xMIN) / JCanvasSlider.this.xTICKS);
                    val = JCanvasSlider.this.xMIN + JCanvasSlider.this.xTICKS * (double)i;
                    double ex = Math.pow(10.0, 5L - Math.round(Math.log10(val)));
                    if (Double.isNaN(val = (double)Math.round(val * ex) / ex)) {
                        val = 0.0;
                    }
                }
                JCanvasSlider.this.setVal(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

