/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.bar;

import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.bar.JControlProperties;
import carmetal.eric.controls.JCanvasPanel;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JPropertiesBar
extends JFrame
implements MouseListener,
MouseMotionListener {
    private static int Bx = 0;
    private static int By = 0;
    private static int Bwidth = 1000;
    private static int Bheight = 60;
    CPane CP;
    TitleBar titlebar;
    JControlProperties Content;
    private MouseEvent pressed;
    private Point location;
    private static JPropertiesBar JPB = null;

    public JPropertiesBar() {
        JPB = this;
        Bx = Global.getParameter("props.paletteX", 0);
        if (Bx < Global.getScreenX()) {
            Bx = Global.getScreenX();
        }
        By = Global.getScreenY();
        this.CP = new CPane();
        this.setContentPane(this.CP);
        this.titlebar = new TitleBar(this, 18);
        this.Content = new JControlProperties(Bwidth - this.titlebar.getSize().width, Bheight);
        this.Content.addPanel(Global.Loc("props.aspecttab"));
        this.Content.addPanel(Global.Loc("props.numerictab"));
        this.Content.addPanel(Global.Loc("props.conditionaltab"));
        this.Content.selectTab(Global.getParameter("props.selectedtab", 0));
        this.CP.add(this.titlebar);
        this.CP.add(this.Content);
        this.setSize(Bwidth + 2, Bheight + 2);
        this.setLocation(Bx, By);
        this.setUndecorated(true);
        this.setFocusable(true);
    }

    public static int getBarHeight() {
        if (JPB != null && JPB.isVisible()) {
            return Bheight;
        }
        return 0;
    }

    public void clearme() {
        this.Content.clearme();
    }

    public void refresh() {
        this.Content.refresh();
    }

    public void showme(boolean vis) {
        if (vis) {
            this.setVisible(true);
            pipe_tools.setWindowBounds();
            pipe_tools.toFront();
        } else {
            this.setVisible(false);
        }
    }

    public static void ShowHideBar() {
        if (JPB != null) {
            JPB.showme(!JPB.isVisible());
        }
    }

    public static boolean isBarVisible() {
        return JPB != null && JPB.isVisible();
    }

    public static void EditObject(ConstructionObject o) {
        JPropertiesBar.EditObject(o, true, true);
    }

    public static void EditObject(ConstructionObject o, boolean forcevisible, boolean forcefocus) {
        if (JPB != null && o != null) {
            JPB.setObject(o, forcevisible, forcefocus);
        }
    }

    public static void EditObject(JCanvasPanel jcp) {
        if (JPB != null && jcp.O != null) {
            JPB.setObject(jcp);
        }
    }

    public static void SelectPropertiesTab(int i) {
        JPB.selectTab(i);
    }

    public static void RefreshBar() {
        if (JPB != null) {
            JPB.refresh();
        }
    }

    public static void CreatePopertiesBar() {
        JPB = new JPropertiesBar();
        JPB.showme(false);
    }

    public void setObject(ConstructionObject O, boolean forcevisible, boolean forcefocus) {
        if (forcevisible) {
            this.showme(true);
        }
        if (!this.isVisible() && !forcefocus) {
            return;
        }
        this.Content.setObject(O, forcevisible, forcefocus);
    }

    public void selectTab(int i) {
        this.Content.selectTab(i);
    }

    public void setObject(JCanvasPanel jcp) {
        this.showme(true);
        this.Content.setObject(jcp);
    }

    private static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    private void setBarLocation(MouseEvent me) {
        this.location = this.getLocation(this.location);
        int x = this.location.x - this.pressed.getX() + me.getX();
        if (x < Global.getScreenX() + 20) {
            x = Global.getScreenX();
        } else if (x + Bwidth > Global.getScreenX() + Global.getScreenW() - 20) {
            x = Global.getScreenX() + Global.getScreenW() - Bwidth;
        }
        this.setLocation(x, Global.getScreenY());
        Toolkit.getDefaultToolkit().sync();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.setBarLocation(me);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.pressed = me;
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.setBarLocation(e2);
        Global.setParameter("props.paletteX", this.getLocation().x);
        Bx = this.getLocation().x;
        By = this.getLocation().y;
        pipe_tools.setWindowLocation();
        pipe_tools.toFront();
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    private class CPane
    extends JPanel {
        public CPane() {
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createLineBorder(new Color(80, 80, 80), 1));
        }
    }

    private class TitleBar
    extends JPanel {
        ImageIcon closeimg = new ImageIcon(this.getClass().getResource("gui/Pclose.png"));
        ImageIcon closeoverimg = new ImageIcon(this.getClass().getResource("gui/Pcloseover.png"));
        ImageIcon myicon = new ImageIcon(this.getClass().getResource("gui/titlebar.png"));
        JButton closebtn;
        JPropertiesBar Mother;

        @Override
        public void paintComponent(Graphics g) {
            Dimension d2 = this.getSize();
            g.drawImage(this.myicon.getImage(), 0, 0, d2.width, d2.height, this);
            super.paintComponent(g);
        }

        public TitleBar(JPropertiesBar parent, int width) {
            this.Mother = parent;
            this.setLayout(new BoxLayout(this, 1));
            this.setOpaque(false);
            JPropertiesBar.fixsize(this, width, Bheight);
            this.addMouseListener(parent);
            this.addMouseMotionListener(parent);
            this.closebtn = new JButton(this.closeimg);
            this.closebtn.setRolloverIcon(this.closeoverimg);
            this.closebtn.setBorder(BorderFactory.createEmptyBorder());
            this.closebtn.setOpaque(false);
            this.closebtn.setContentAreaFilled(false);
            this.closebtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e2) {
                    TitleBar.this.Mother.showme(false);
                }
            });
            this.add(this.closebtn);
        }
    }
}

