/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.animations;

import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.myJMenuItem;
import carmetal.eric.animations.Animation;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnimationPanel
extends JPanel
implements MouseListener {
    private ZirkelCanvas ZC;
    private Vector<Animation> V = new Vector();
    private static Image icon = themes.getImage("animation.png");
    private int W = 32;
    private int H = 32;
    private int X = 10;
    private int Y = 47;
    private int minspeed = 0;
    private int maxspeed = 100;
    private int speed = 40;
    private boolean stopped = false;
    private double a;
    private double b;
    private double A1;
    private double A2;
    private double B2;

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(icon, 0, 0, this.W, this.H, this);
    }

    public int getMaxSpeed() {
        return this.maxspeed;
    }

    public AnimationPanel(ZirkelCanvas zc) {
        this.ZC = zc;
        this.setBounds(this.X, this.Y, this.W, this.H);
        this.addMouseListener(this);
        this.a = this.maxspeed / 10;
        this.b = this.maxspeed - 10;
        this.A1 = this.b / this.a;
        this.A2 = ((double)this.maxspeed - this.b) / ((double)this.maxspeed - this.a);
        this.B2 = (double)this.maxspeed * (this.b - this.a) / ((double)this.maxspeed - this.a);
    }

    public double getDelay() {
        int cur = this.speed;
        double v = (double)cur > this.a ? this.A2 * (double)cur + this.B2 : this.A1 * (double)cur;
        double d2 = ((double)this.maxspeed - v) * 6.0;
        return d2;
    }

    public void setDelay(double delay) {
        double cur = (double)this.maxspeed - delay / 6.0;
        this.speed = cur > this.b ? (int)((cur - this.B2) / this.A2) : (int)(cur / this.A1);
    }

    public void showPopup() {
        JPopupMenu popup = new JPopupMenu();
        myJMenuItem item = new myJMenuItem(Global.Loc("animation.run")){

            @Override
            public void action() {
                AnimationPanel.this.startAnimation();
            }
        };
        popup.add(item);
        item = new myJMenuItem(Global.Loc("animation.stop")){

            @Override
            public void action() {
                AnimationPanel.this.stopAnimation();
            }
        };
        popup.add(item);
        item = new myJMenuItem(Global.Loc("animation.reverse")){

            @Override
            public void action() {
                AnimationPanel.this.reverseAnimation();
            }
        };
        popup.add(item);
        popup.add(new JSeparator());
        item = new myJMenuItem(Global.Loc("animation.removeall")){

            @Override
            public void action() {
                AnimationPanel.this.removeAllAnimations();
            }
        };
        popup.add(item);
        popup.add(new JSeparator());
        popup.add(new SpeedSliderMenuItem());
        popup.show(this, this.W - 10, this.H);
    }

    public Vector<Animation> getAnimations() {
        return this.V;
    }

    public void reverseAnimation() {
        for (int i = 0; i < this.V.size(); ++i) {
            this.V.get(i).setNegative(!this.V.get(i).getNegative());
        }
    }

    public void setAnimationNegative(String objectname, boolean negative) {
        for (int i = 0; i < this.V.size(); ++i) {
            if (!objectname.equals(this.V.get(i).getObjectName())) continue;
            this.V.get(i).setNegative(negative);
            return;
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stopAnimation() {
        this.stopped = true;
    }

    public void startAnimation() {
        this.stopped = false;
        this.run();
    }

    public void run() {
        if (!this.stopped) {
            for (int i = 0; i < this.V.size(); ++i) {
                this.V.get(i).run();
            }
        }
    }

    public boolean isAnimated(ConstructionObject o) {
        for (int i = 0; i < this.V.size(); ++i) {
            if (!this.V.get(i).getObject().equalsTo(o)) continue;
            return true;
        }
        return false;
    }

    public void removeAllAnimations() {
        for (int i = 0; i < this.V.size(); ++i) {
            this.V.get(i).killThread();
        }
        this.V.removeAllElements();
        this.ZC.remove(this);
        this.ZC.repaint();
    }

    public void removeAnimation(ConstructionObject o) {
        for (int i = 0; i < this.V.size(); ++i) {
            if (!o.equalsTo(this.V.get(i).getObject())) continue;
            this.V.get(i).killThread();
            this.V.remove(this.V.get(i));
        }
        if (this.V.size() == 0) {
            this.ZC.remove(this);
            this.ZC.repaint();
        }
    }

    public void addAnimation(ConstructionObject o) {
        if (o == null) {
            return;
        }
        Animation anim = new Animation(this.ZC, this, o);
        this.V.add(anim);
        if (this.V.size() == 1) {
            this.ZC.add(this);
            this.ZC.repaint();
        }
        if (!this.stopped) {
            anim.run();
        }
    }

    public void addAnimation(String objectname) {
        this.V.add(new Animation(this.ZC, this, objectname));
        if (this.V.size() == 1) {
            this.ZC.add(this);
            this.ZC.repaint();
        }
    }

    public void setObjectSelected(boolean sel) {
        for (int i = 0; i < this.V.size(); ++i) {
            this.V.get(i).getObject().setSelected(sel);
        }
    }

    public void printArgs(XmlWriter xml) {
        for (int i = 0; i < this.V.size(); ++i) {
            ConstructionObject o = this.V.get(i).getObject();
            if (o != null && o instanceof PointObject) {
                PointObject p = (PointObject)o;
                if (p == null || !p.isPointOn() || !p.isInConstruction()) continue;
                xml.startTagStart("Animate");
                xml.printArg("animate", p.getName());
                xml.printArg("negative", "" + this.V.get(i).getNegative());
                xml.printArg("delay", "" + this.getDelay());
                xml.printArg("stopped", "" + this.stopped);
                xml.finishTagNewLine();
                continue;
            }
            if (o == null || !(o instanceof ExpressionObject)) continue;
            xml.startTagStart("Animate");
            xml.printArg("animate", o.getName());
            xml.printArg("negative", "" + this.V.get(i).getNegative());
            xml.printArg("delay", "" + this.getDelay());
            xml.printArg("stopped", "" + this.stopped);
            xml.finishTagNewLine();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.showPopup();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    class SpeedSliderMenuItem
    extends JSlider
    implements ChangeListener {
        TitledBorder ttle;

        public SpeedSliderMenuItem() {
            this.ttle = new TitledBorder(" " + Global.Loc("animation.speed") + "=" + AnimationPanel.this.speed + "% ");
            this.ttle.setTitleFont(themes.TabMenusFont);
            this.setBorder(this.ttle);
            this.setMinimum(AnimationPanel.this.minspeed);
            this.setMaximum(AnimationPanel.this.maxspeed);
            this.setValue(AnimationPanel.this.speed);
            this.setMajorTickSpacing(20);
            this.setMinorTickSpacing(10);
            this.setFocusable(false);
            this.addChangeListener(this);
            this.putClientProperty("JComponent.sizeVariant", "small");
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            AnimationPanel.this.speed = this.getValue();
            this.ttle.setTitle(" " + Global.Loc("animation.speed") + "=" + AnimationPanel.this.speed + "% ");
            this.repaint();
        }
    }
}

